/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.format;

import com.inet.annotations.PublicApi;
import com.inet.report.chart.f;
import com.inet.report.i;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.NumberFormat;
import org.w3c.dom.Element;

@PublicApi
public class Abbreviation
implements Serializable {
    public static final Abbreviation ABBREVIATION_NONE = new Abbreviation(1.0, "");
    public static final Abbreviation ABBREVIATION_THOUSANDS = new Abbreviation(1000.0, "K");
    public static final Abbreviation ABBREVIATION_MILLIONS = new Abbreviation(1000000.0, "M");
    public static final Abbreviation ABBREVIATION_BILLIONS = new Abbreviation(1.0E9, "B");
    private static final Abbreviation[] XW = new Abbreviation[]{ABBREVIATION_NONE, ABBREVIATION_THOUSANDS, ABBREVIATION_MILLIONS, ABBREVIATION_BILLIONS};
    private final double XX;
    private final String XY;
    private boolean XZ;

    private Abbreviation(double divisor, String symbol) {
        if (symbol == null) {
            throw i.d("symbol");
        }
        this.XX = divisor;
        this.XY = symbol;
    }

    public double getDivisor() {
        return this.XX;
    }

    public String getSymbol() {
        return this.XY;
    }

    String a(double d2, NumberFormat numberFormat) {
        d2 /= this.XX;
        if (this.XZ) {
            return this.XY + numberFormat.format(d2);
        }
        return numberFormat.format(d2) + this.XY;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Abbreviation) {
            Abbreviation abbreviation = (Abbreviation)object;
            if (this.getDivisor() != abbreviation.getDivisor()) {
                return false;
            }
            return this.getSymbol().equals(abbreviation.getSymbol());
        }
        return false;
    }

    public int hashCode() {
        return (this.XY + this.XX + this.XZ).hashCode();
    }

    void g(StringBuilder stringBuilder, int n2) {
        if (this.equals(ABBREVIATION_NONE)) {
            return;
        }
        f.b(stringBuilder, n2, "Abbreviation", this.getSymbol());
    }

    public static Abbreviation getAbbreviation(Element element) {
        Abbreviation abbreviation = ABBREVIATION_NONE;
        String string = element.getAttribute("value");
        if (string.length() > 0) {
            for (int i2 = 0; i2 < XW.length; ++i2) {
                if (!XW[i2].getSymbol().equals(string)) continue;
                abbreviation = XW[i2];
                break;
            }
        }
        return abbreviation;
    }

    private Object readResolve() throws ObjectStreamException {
        Abbreviation abbreviation = null;
        if (this.equals(ABBREVIATION_BILLIONS)) {
            abbreviation = ABBREVIATION_BILLIONS;
        } else if (this.equals(ABBREVIATION_MILLIONS)) {
            abbreviation = ABBREVIATION_MILLIONS;
        } else if (this.equals(ABBREVIATION_NONE)) {
            abbreviation = ABBREVIATION_NONE;
        } else if (this.equals(ABBREVIATION_THOUSANDS)) {
            abbreviation = ABBREVIATION_THOUSANDS;
        }
        return abbreviation;
    }
}

