/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.ChartTitle;
import com.inet.report.chart.axis.AbstractMarker;
import com.inet.report.chart.axis.AxisPosition;
import com.inet.report.chart.axis.c;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.i;
import com.inet.report.j;
import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@PublicApi
public class BaseAxis
implements Serializable {
    public static final int DEFAULT_TICK_LABEL_COLOR = 0;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_GRIDLINE_COLOR = ColorUtils.toCcColor((Color)Color.lightGray);
    public static final int DEFAULT_AXIS_LINE_COLOR = ColorUtils.toCcColor((Color)new Color(221, 221, 221));
    public static final ChartTitle DEFAULT_TITLE = new ChartTitle(new Font("SansSerif", 1, 14), 0);
    public static final String TOKEN_CATEGORY_AXIS = "CategoryAxis";
    public static final String TOKEN_SERIES_AXIS = "SeriesAxis";
    public static final String TOKEN_DATA_AXIS = "DataAxis";
    private ChartTitle WP;
    private Font WQ;
    private int WR = 0;
    private ChartFormat WS;
    private boolean WT = true;
    private int WU;
    private int WV;
    private boolean WW = false;
    private AxisPosition WX = AxisPosition.ON_MIN;

    public BaseAxis() {
        this.WP = DEFAULT_TITLE.clone();
        this.WQ = DEFAULT_TICK_LABEL_FONT;
        this.WU = DEFAULT_GRIDLINE_COLOR;
        this.WV = DEFAULT_AXIS_LINE_COLOR;
    }

    public boolean isGridlinesVisible() {
        return this.WT;
    }

    public void setGridlinesVisible(boolean gridlinesVisible) {
        this.WT = gridlinesVisible;
    }

    public int getGridlineColor() {
        return this.WU;
    }

    public void setGridlineColor(int gridlineColor) {
        if (gridlineColor == -1) {
            throw i.e("gridlineColor");
        }
        this.WU = gridlineColor;
    }

    public int getAxisLineColor() {
        return this.WV;
    }

    public boolean isInverseOrder() {
        return this.WW;
    }

    public void setInverseOrder(boolean inverseOrder) {
        this.WW = inverseOrder;
    }

    public void setAxisLineColor(int axisLineColor) {
        if (axisLineColor == -1) {
            throw i.e("axisLineColor");
        }
        this.WV = axisLineColor;
    }

    public ChartTitle getTitle() {
        return this.WP;
    }

    public void setTitle(ChartTitle title) {
        if (title == null) {
            throw i.d("title");
        }
        this.WP = title;
    }

    public Font getTickLabelFont() {
        return this.WQ;
    }

    public void setTickLabelFont(Font tickLabelFont) {
        if (tickLabelFont == null) {
            throw i.d("tickLabelFont");
        }
        this.WQ = tickLabelFont;
    }

    public int getTickLabelColor() {
        return this.WR;
    }

    public void setTickLabelColor(int tickLabelColor) {
        if (tickLabelColor == -1) {
            throw i.e("tickLabelColor");
        }
        this.WR = tickLabelColor;
    }

    public ChartFormat getTickLabelFormat() {
        return this.WS;
    }

    public void setTickLabelFormat(ChartFormat tickLabelFormat) {
        this.WS = tickLabelFormat;
    }

    public AxisPosition getAxisPosition() {
        return this.WX;
    }

    public void setAxisPosition(AxisPosition position) {
        if (position == null) {
            throw i.d("axis position");
        }
        this.WX = position;
    }

    public void copyTo(BaseAxis that) {
        that.setAxisLineColor(this.getAxisLineColor());
        that.setGridlineColor(this.getGridlineColor());
        that.setGridlinesVisible(this.isGridlinesVisible());
        that.setInverseOrder(this.isInverseOrder());
        that.setAxisPosition(this.getAxisPosition());
        that.setTickLabelColor(this.getTickLabelColor());
        that.setTickLabelFont(this.getTickLabelFont());
        that.setTitle(this.getTitle());
    }

    public void saveProperties(PrintWriter out, int depth, String axisType) {
        String string = BaseUtils.getIndent(depth);
        StringBuilder stringBuilder = this.cl(++depth);
        f.a(out, string, axisType, this.getAxisPosition().lr(), false);
        if (stringBuilder.length() > 0) {
            out.print(stringBuilder.toString());
        }
        this.B(out, depth);
        f.a(out, string, axisType, null, true);
    }

    protected StringBuilder cl(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        f.b(stringBuilder, n2, "GridlinesVisible", String.valueOf(this.isGridlinesVisible()));
        if (this.getGridlineColor() != DEFAULT_GRIDLINE_COLOR) {
            f.b(stringBuilder, n2, "GridlineColor", String.valueOf(this.getGridlineColor()));
        }
        if (this.getAxisLineColor() != DEFAULT_AXIS_LINE_COLOR) {
            f.b(stringBuilder, n2, "AxisLineColor", String.valueOf(this.getAxisLineColor()));
        }
        if (!this.WP.isEqualToDefault(DEFAULT_TITLE)) {
            this.WP.saveProperties(stringBuilder, "AxisTitle", n2);
        }
        if (this.getTickLabelFormat() != null) {
            this.getTickLabelFormat().saveProperties(stringBuilder, n2);
        }
        if (!this.getTickLabelFont().equals(DEFAULT_TICK_LABEL_FONT) || this.getTickLabelColor() != 0) {
            f.b(stringBuilder, n2, this.getTickLabelFont(), this.getTickLabelColor());
        }
        if (this.isInverseOrder()) {
            f.b(stringBuilder, n2, "InverseOrder", String.valueOf(this.isInverseOrder()));
        }
        return stringBuilder;
    }

    protected void B(PrintWriter printWriter, int n2) {
    }

    public void readProperties(Element element, Chart2 chart) {
        AxisPosition axisPosition = AxisPosition.d(element);
        if (axisPosition != null) {
            this.setAxisPosition(axisPosition);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("GridlinesVisible")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setGridlinesVisible(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("GridlineColor")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n2 = Integer.parseInt(element2.getAttribute("value"));
                this.setGridlineColor(n2);
                continue;
            }
            if (element2.getNodeName().equals("AxisLineColor")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n3 = Integer.parseInt(element2.getAttribute("value"));
                this.setAxisLineColor(n3);
                continue;
            }
            if (element2.getNodeName().equals("AxisTitle")) {
                this.WP.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("Format")) {
                this.WS = j.b(element2);
                if (this.WS == null) continue;
                this.WS.readProperties(element2);
                continue;
            }
            if (element2.getNodeName().equals("Label")) {
                object = element2.getChildNodes();
                if (object.getLength() > 0) {
                    this.setTickLabelColor(j.b(object.item(0).getChildNodes()));
                    this.setTickLabelFont(j.a(object.item(0).getChildNodes()));
                } else {
                    NamedNodeMap namedNodeMap = element2.getAttributes();
                    for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                        Node node = namedNodeMap.item(i3);
                        if (node.getNodeName().equals("font")) {
                            Font font = f.aI(node.getNodeValue());
                            if (font == null) continue;
                            this.setTickLabelFont(font);
                            continue;
                        }
                        if (!node.getNodeName().equals("color")) continue;
                        int n4 = Integer.parseInt(node.getNodeValue());
                        this.setTickLabelColor(n4);
                    }
                    continue;
                }
            }
            if (!element2.getNodeName().equals("InverseOrder") || ((String)(object = element2.getAttribute("value"))).length() <= 0) continue;
            this.setInverseOrder(Boolean.valueOf((String)object));
        }
    }

    public List<Object> getReferencedObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        if (this.WP != null && this.WP.getTitleFormula() != null) {
            arrayList.add(this.WP.getTitleFormula());
        }
        if (this instanceof c) {
            arrayList.addAll(AbstractMarker.getMarkerReferencesIfExist((c)((Object)this)));
        }
        return arrayList;
    }
}

