/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportComponent;
import com.inet.report.Section;
import com.inet.report.SignatureProperties;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.i18n.Msg;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.xml.sax.Attributes;

@PublicApi
public class SignatureForm
extends Element
implements BorderProperties,
SignatureProperties {
    public static final int INSET_LEFT = 20;
    public static final int INSET_RIGHT = 20;
    public static final int INSET_TOP = 40;
    public static final int INSET_BOTTOM = 20;
    private String Mi;
    private String Mj;
    private String Mk;
    private String Ml;
    private String Mm;
    private String Mn;
    private String Mo;
    private Date Mp;
    private Date Mq;
    private String Mr;
    private String Ms;
    private boolean Mt;
    private boolean Mu;
    private int Mv;
    private boolean Mw;
    private boolean Mx;
    private boolean My;
    private boolean Mz;
    private boolean MA;
    private boolean MB;

    SignatureForm(Engine engine, Section parentSection) {
        super(70, engine.bI(), parentSection);
        this.iK();
    }

    void init() {
        CertificateInfoFactory certificateInfoFactory = RDC.getCertificateFactory();
        if (certificateInfoFactory == null) {
            throw new IllegalStateException("signature parameters are not defined: please define ceritifate info factory");
        }
        CertificateInfo certificateInfo = certificateInfoFactory.getCertificateInfo(this.getEngine());
        Certificate certificate = certificateInfo.getCertificate();
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            this.Mp = x509Certificate.getNotBefore();
            this.Mq = x509Certificate.getNotAfter();
            this.Mm = x500Principal2.getName();
            this.Mo = x500Principal.getName();
            if (this.Mo != null) {
                int n2 = this.Mo.indexOf("CN=");
                if (n2 == -1 && ((n2 = this.Mo.indexOf("cn=")) == -1 || n2 + "CN=".length() >= this.Mo.length())) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning("pdf signature: common name is not defined in the certificate");
                    }
                    this.Mn = "";
                    return;
                }
                int n3 = this.Mo.indexOf(44, n2);
                if (n3 == -1) {
                    n3 = this.Mo.length();
                }
                this.Mn = this.Mo.substring(n2 + "CN=".length(), n3);
            } else {
                this.Mn = "";
            }
        }
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", Element.c.nz.name()) + this.ca() + ">\n");
        this.b(printWriter, ++n2, Element.lY);
        this.a(printWriter, n2, Element.lY);
        this.r(printWriter, n2);
        this.y(printWriter, n2);
        printWriter.print(string + "</Element>\n");
    }

    final void y(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, ++n2, a.ME.name(), k.g(this.getDivideField()));
        k.a(stringBuilder, n2, a.MG.name(), k.g(this.getShowSubjectName()));
        k.a(stringBuilder, n2, a.MF.name(), k.g(this.getWriteCertificateLabels()));
        k.a(stringBuilder, n2, a.MH.name(), k.g(this.getWriteCertificateSubjectName()));
        k.a(stringBuilder, n2, a.MI.name(), k.g(this.getWriteCertificateDistinguishedName()));
        k.a(stringBuilder, n2, a.MJ.name(), k.g(this.getWriteCertificateLocation()));
        k.a(stringBuilder, n2, a.MK.name(), k.g(this.getWriteCertificateReason()));
        k.a(stringBuilder, n2, a.ML.name(), k.g(this.getWriteCertificateDate()));
        k.a(stringBuilder, n2, a.MM.name(), k.z(this.getTextPosition()));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<" + XMLTag.SignatureFormProperties.name() + ">\n");
            printWriter.print(stringBuilder.toString());
            printWriter.print(string + "</" + XMLTag.SignatureFormProperties.name() + ">\n");
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    NodeParser nodeParser = super.parseElement(group, tag, atts, parserMap);
                    return nodeParser;
                }
                case SignatureFormProperties: {
                    String string = atts.getValue("value");
                    if (string == null) {
                        return null;
                    }
                    try {
                        this.t(tag, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return null;
        }
        NodeParser nodeParser = null;
        XMLTag xMLTag = XMLTag.getValueOf(tag);
        switch (xMLTag) {
            // Empty switch
        }
        return nodeParser;
    }

    private void t(String string, String string2) {
        a a2 = a.MD;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case ME: {
                this.Mt = Boolean.valueOf(string2);
                break;
            }
            case MG: {
                this.Mu = Boolean.valueOf(string2);
                break;
            }
            case MH: {
                this.MB = Boolean.valueOf(string2);
                break;
            }
            case MI: {
                this.Mx = Boolean.valueOf(string2);
                break;
            }
            case MJ: {
                this.Mz = Boolean.valueOf(string2);
                break;
            }
            case MK: {
                this.MA = Boolean.valueOf(string2);
                break;
            }
            case MF: {
                this.My = Boolean.valueOf(string2);
                break;
            }
            case ML: {
                this.Mw = Boolean.valueOf(string2);
                break;
            }
            case MM: {
                this.setTextPosition(Integer.parseInt(string2));
            }
        }
    }

    @Override
    public boolean getDivideField() {
        return this.Mt;
    }

    @Override
    public boolean getShowSubjectName() {
        return this.Mu;
    }

    @Override
    public int getTextPosition() {
        return this.Mv;
    }

    @Override
    public boolean getWriteCertificateDate() {
        return this.Mw;
    }

    @Override
    public boolean getWriteCertificateDistinguishedName() {
        return this.Mx;
    }

    @Override
    public boolean getWriteCertificateLabels() {
        return this.My;
    }

    @Override
    public boolean getWriteCertificateLocation() {
        return this.Mz;
    }

    @Override
    public boolean getWriteCertificateReason() {
        return this.MA;
    }

    @Override
    public boolean getWriteCertificateSubjectName() {
        return this.MB;
    }

    @Override
    public void setDivideField(boolean val) {
        this.Mt = val;
    }

    @Override
    public void setShowSubjectName(boolean val) {
        this.Mu = val;
    }

    @Override
    public void setTextPosition(int pos) {
        this.Mv = 1;
        if (pos == 0) {
            this.Mv = pos;
        }
    }

    @Override
    public void setWriteCertificateDate(boolean val) {
        this.Mw = val;
    }

    @Override
    public void setWriteCertificateDistinguishedName(boolean val) {
        this.Mx = val;
    }

    @Override
    public void setWriteCertificateLabels(boolean val) {
        this.My = val;
    }

    @Override
    public void setWriteCertificateLocation(boolean val) {
        this.Mz = val;
    }

    @Override
    public void setWriteCertificateReason(boolean val) {
        this.MA = val;
    }

    @Override
    public void setWriteCertificateSubjectName(boolean val) {
        this.MB = val;
    }

    private void iK() {
        this.Mi = Msg.getMsg(this.bB.ressourceLocale, "ExportSignSignedby", new Object[0]);
        this.Mj = Msg.getMsg(this.bB.ressourceLocale, "ExportSignReason", new Object[0]) + " ";
        this.Mk = Msg.getMsg(this.bB.ressourceLocale, "ExportSignLocation", new Object[0]) + " ";
        this.Ml = Msg.getMsg(this.bB.ressourceLocale, "ExportSignSignDate", new Object[0]) + " ";
    }

    String iL() {
        return this.Mn;
    }

    String iM() {
        return this.Mo;
    }

    String iN() {
        return this.Mr;
    }

    String iO() {
        return this.Ms;
    }

    String iP() {
        return this.Mi;
    }

    String iQ() {
        return this.Mj;
    }

    String iR() {
        return this.Mk;
    }

    String iS() {
        return this.Ml;
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return null;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a MD = new a();
        public static final /* enum */ a ME = new a();
        public static final /* enum */ a MF = new a();
        public static final /* enum */ a MG = new a();
        public static final /* enum */ a MH = new a();
        public static final /* enum */ a MI = new a();
        public static final /* enum */ a MJ = new a();
        public static final /* enum */ a MK = new a();
        public static final /* enum */ a ML = new a();
        public static final /* enum */ a MM = new a();
        private static final /* synthetic */ a[] MN;

        public static a[] values() {
            return (a[])MN.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] iT() {
            return new a[]{MD, ME, MF, MG, MH, MI, MJ, MK, ML, MM};
        }

        static {
            MN = a.iT();
        }
    }
}

