/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.StringList;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.FieldPart;
import com.inet.report.Group;
import com.inet.report.PropertyConstants;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportComponent;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SortField;
import com.inet.report.SummaryField;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.ac;
import com.inet.report.ah;
import com.inet.report.as;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.FieldFilter;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.ToSQLResult;
import com.inet.report.formula.b;
import com.inet.report.formula.c;
import com.inet.report.formula.d;
import com.inet.report.formula.g;
import com.inet.report.formula.highlighter.Descriptor;
import com.inet.report.formula.highlighter.Highlighter;
import com.inet.report.formula.j;
import com.inet.report.formula.m;
import com.inet.report.formula.p;
import com.inet.report.formula.parser.FormulaParserException;
import com.inet.report.formula.parser.Token;
import com.inet.report.formula.parser.e;
import com.inet.report.formula.q;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.report.y;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

@PublicApi
public class FormulaField
extends Field
implements ReferenceHolder,
Validatable,
IFormulaData {
    private static final ConfigValue<Integer> rt = new ConfigValue(ConfigKey.COMPATIBILITY_LEVEL);
    public static final int FORMULA_USER = 0;
    public static final int FORMULA_RECORD_SELECTION = 1;
    public static final int FORMULA_GROUP_SELECTION = 2;
    public static final int FORMULA_PROPERTY = 3;
    public static final int TREAT_NULL_AS_NULL = 0;
    public static final int TREAT_NULL_BY_DEFAULT = 1;
    public static final int TREAT_NULL_BY_EXCEPTION = 2;
    public static final int UNSPECIFIED_EVALUATE_TIME = -1;
    public static final int BEFORE_READING_RECORDS = 0;
    public static final int WHILE_READING_RECORDS = 1;
    public static final int WHILE_PRINTING_RECORDS = 2;
    public static final int SYNTAX_CRYSTAL = 1001;
    public static final int SYNTAX_BASIC = 1002;
    private HashMap<ReferencedObject, ah> lE = new HashMap();
    private int ru = 1001;
    private String rv = "";
    private q rw;
    private int rx = 0;
    private int ry = -1;
    boolean rz = true;
    private boolean rA = false;
    private boolean rB = false;
    private transient boolean rC;
    private transient Evaluable rD;
    private transient Object lJ;
    private transient int rE;
    private transient boolean rF;
    private transient Object rG;
    @Deprecated
    public int loopCount;
    private Field op;
    private Object rH;
    private int rI = -1;
    private Object rJ;
    private Object[] rK;
    @Deprecated
    private int rL;
    @Deprecated
    int rM;
    @Deprecated
    ReportComponent rN;
    private boolean rO = false;
    private transient ThreadLocal<Boolean> rP = new ThreadLocal();
    private transient ThreadLocal<Boolean> rQ = new ThreadLocal();
    private boolean rR = false;
    private Validity rS;
    private boolean rT = false;
    private boolean rU;
    private m rV;

    FormulaField(RendererBase<?> ren) {
        this.type = 13;
        this.bB = ren;
        this.rJ = this;
    }

    public ReportComponent getElementOfPropertyFormula() {
        return this.rN;
    }

    Object a(Field field, Object object) throws ReportException {
        this.d(object);
        this.setCurrentField(field);
        RendererBase rendererBase = this.bB;
        d d2 = rendererBase.getFormula();
        b b2 = d2.a(this, object, this.getCurrentField());
        return this.a(field, object, b2);
    }

    Object a(Field field, Object object, g g2) throws ReportException {
        try {
            block21: {
                this.d(object);
                this.setCurrentField(field);
                if (this.getFormulaTree() == null) {
                    this.ry = -1;
                }
                if (!this.rC && this.getFormulaTree() != null) {
                    if (this.valueType < 0 && this.getNullBehavior() != 0) {
                        this.dd();
                        this.valueType = g2.aG(true);
                    }
                    g2.S(!this.bB.isMain());
                    g2.po();
                    this.rC = true;
                }
                try {
                    this.b(true, true);
                }
                catch (FormulaException formulaException) {
                    if ((Integer)rt.get() < 9) break block21;
                    throw formulaException;
                }
            }
            ac ac2 = ((j)((Object)g2)).getDataProvider();
            if (this.ry == 0 && !ac2.isEvaluateNewWhileReading()) {
                if (this.rG == null) {
                    this.rG = g2.pl();
                    if (this.rG == null) {
                        this.rG = this;
                    }
                }
                if (this.rG == this) {
                    return null;
                }
                return this.rG;
            }
            if (ac2.isUseLastValueCache() && this.ry == 1 && !ac2.isEvaluateNewWhileReading()) {
                Object object2;
                int n2 = ac2.getRowPosition() - 1;
                if (this.rG == null) {
                    int n3 = ac2.getRowCount();
                    this.rG = new Object[n3 == 0 ? 1 : n3];
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 >= ((Object[])this.rG).length) {
                    n2 = ((Object[])this.rG).length;
                }
                if ((object2 = ((Object[])this.rG)[n2]) == null) {
                    object2 = g2.pl();
                    if (object2 == null) {
                        object2 = this;
                    }
                    ((Object[])this.rG)[n2] = object2;
                }
                if (object2 == this) {
                    return null;
                }
                return object2;
            }
            if (!ac2.isUseLastValueCache()) {
                return g2.pl();
            }
            int n4 = ac2.getRowPosition();
            if (!this.rF || this.rE != n4) {
                this.lJ = g2.pl();
                this.rE = n4;
                if (this.rL != 3) {
                    this.rF = true;
                }
            }
            return this.lJ;
        }
        catch (FormulaException formulaException) {
            formulaException.setFormulaField(this);
            throw formulaException;
        }
    }

    final void X(int n2) {
        this.rF = false;
        if (n2 > 0) {
            this.rG = null;
        }
    }

    @Override
    public void rename(String newName) throws ReportException {
        if (newName == null || newName.trim().length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.EmptyFieldNameForbidden, new Object[0]);
        }
        if (newName.matches(".*[\\}@].*")) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.illegalCharInAliasname, "}, @");
        }
        super.rename(newName);
    }

    @Override
    public void setName(String name) {
        if (this.rL != 0) {
            this.name = name;
            return;
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(ReportingServerPlugin.MSG.getMsg(ReportErrorCode.EmptyFieldNameForbidden.name(), new Object[0]));
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (this.bB.getFields().checkIfNameExists(13, name)) {
            throw y.b("FormulaField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    @Override
    public String getFormula() {
        return this.rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFormula(String formula) {
        if (this.rB) {
            return;
        }
        this.rB = true;
        try {
            Validity.States states;
            if (formula == null) {
                formula = "";
            }
            int n2 = this.valueType;
            Validity validity = this.rS;
            try {
                if (this.getFormulaTree() != null) {
                    n2 = this.getValueType();
                }
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
            this.rv = formula;
            this.resetReferences();
            this.setReferences();
            this.getValueType();
            if (this.valueType == -1 && this.getFormulaTree() != null) {
                this.valueType = n2;
            }
            this.rC = false;
            this.ry = -1;
            try {
                this.dd();
            }
            catch (ReportException reportException) {
                this.rS = new Validity(Validity.States.ERROR, reportException);
            }
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            Validity.States states2 = validity != null ? validity.getState() : null;
            Validity.States states3 = states = this.rS != null ? this.rS.getState() : null;
            if (n2 != this.valueType || states2 != states) {
                for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                    ReferencedObject referencedObject;
                    if (referenceHolderArray[i2] instanceof FormulaField) {
                        referencedObject = (FormulaField)referenceHolderArray[i2];
                        ((FormulaField)referencedObject).setFormula(((FormulaField)referencedObject).getFormula());
                    }
                    if (referenceHolderArray[i2] instanceof Group) {
                        referencedObject = (Group)referenceHolderArray[i2];
                        this.bB.getFields().a(((Group)referencedObject).getGroupNameField(), 2);
                    }
                    if (!(referenceHolderArray[i2] instanceof SummaryField)) continue;
                    referencedObject = (SummaryField)referenceHolderArray[i2];
                    this.bB.getFields().a((Field)referencedObject, 2);
                }
            }
            this.bB.getFields().a(this, 2);
        }
        catch (Exception exception) {
        }
        finally {
            this.rB = false;
        }
    }

    @Override
    public int getSyntax() {
        return this.ru;
    }

    @Override
    public void setSyntax(int syntax) {
        switch (syntax) {
            case 1001: 
            case 1002: {
                this.ru = syntax;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getFormulaType() {
        return this.rL;
    }

    public void setFormulaType(int type) {
        if (type != 0 && type != 1 && type != 2 && type != 3) {
            throw y.a(type, "formula type", null);
        }
        this.rL = type;
    }

    static final String Y(int n2) {
        switch (n2) {
            case 3: {
                return "Property Formula";
            }
            case 0: {
                return "User Formula";
            }
            case 1: {
                return "Record Selection Formula";
            }
            case 2: {
                return "Group Selection Formula";
            }
        }
        return Integer.toString(n2);
    }

    public static int checkFormula(String formula, boolean basic, Engine engine) throws ReportException {
        return FormulaField.checkFormula(formula, basic, engine, null, null);
    }

    public static int checkFormula(String formula, boolean basic, Engine engine, Field currentField, Object defaultAttribute) throws ReportException {
        return FormulaField.checkFormula(formula, basic, engine, currentField, defaultAttribute, 0, 0);
    }

    public static int checkFormula(String formula, boolean basic, Engine engine, Field currentField, Object defaultAttribute, int formulaType) throws ReportException {
        return FormulaField.checkFormula(formula, basic, engine, currentField, defaultAttribute, formulaType, 0);
    }

    public static int checkFormula(String formula, boolean basic, Engine engine, Field currentField, Object defaultAttribute, int formulaType, int nullBehavior) throws ReportException {
        d d2 = engine.bB.getFormula();
        b b2 = d2.a(formula, basic, formulaType, nullBehavior, defaultAttribute, currentField);
        b2.aF(true);
        return FormulaField.a(engine, formulaType, d2, b2, null);
    }

    private static int a(Engine engine, int n2, d d2, b b2, FormulaField formulaField) throws ReportException {
        int n3;
        block15: {
            ArrayList arrayList;
            try {
                Object object;
                b2.pn();
                int n4 = b2.aG(true);
                b2.checkContext();
                if (n2 == 1) {
                    if (b2.isEmpty()) {
                        int n5 = 8;
                        return n5;
                    }
                    b2.po();
                    var6_8 = engine.getDatabaseTables();
                    object = null;
                    for (int i2 = 0; i2 < ((DatabaseTables)var6_8).getDatasourceCount(); ++i2) {
                        Datasource datasource = ((DatabaseTables)var6_8).getDatasource(i2);
                        Serializable serializable = datasource.k(false);
                        if (!DatabaseUtils.useJdbcDriver(serializable)) continue;
                        object = b2.a((Database)serializable, false, true, new FieldFilter(datasource));
                    }
                    if (object != null && ((ToSQLResult)object).hasNonDBPart()) {
                        throw ((ToSQLResult)object).getPartExceptions().get(0);
                    }
                } else {
                    if (formulaField != null && (object = FormulaField.a(formulaField, (var6_8 = FormulaField.a(b2)).keySet().toArray(new ReferencedObject[var6_8.size()]), new HashSet<ReferenceHolder>())) != null) {
                        com.inet.report.formula.ast.j j2 = (com.inet.report.formula.ast.j)var6_8.get(object);
                        FormulaException formulaException = FormulaException.create(ReportErrorCode.ErrorSelfReference, j2 != null ? j2.getPosition() : null, null);
                        formulaException.setFormulaField(formulaField);
                        throw formulaException;
                    }
                    b2.po();
                }
                n3 = n4;
                object = d2.pM();
                if (object == null || ((ArrayList)object).size() <= 0) break block15;
                arrayList = new ArrayList();
                arrayList.addAll(object);
            }
            catch (ReportException reportException) {
                throw reportException;
            }
            finally {
                ArrayList<SummaryField> arrayList2 = d2.pM();
                if (arrayList2 != null && arrayList2.size() > 0) {
                    ArrayList<SummaryField> arrayList3 = new ArrayList<SummaryField>();
                    arrayList3.addAll(arrayList2);
                    for (SummaryField summaryField : arrayList3) {
                        FormulaField.a(summaryField, engine.bB);
                    }
                }
            }
            for (Serializable serializable : arrayList) {
                FormulaField.a((SummaryField)serializable, engine.bB);
            }
        }
        return n3;
    }

    private static Map<ReferenceHolder, com.inet.report.formula.ast.j> a(b b2) throws ReportException {
        Evaluable evaluable = b2.getFormulaTree();
        com.inet.report.formula.a<com.inet.report.formula.ast.j> a2 = new com.inet.report.formula.a<com.inet.report.formula.ast.j>(evaluable, com.inet.report.formula.ast.j.class);
        HashMap<ReferenceHolder, com.inet.report.formula.ast.j> hashMap = new HashMap<ReferenceHolder, com.inet.report.formula.ast.j>();
        while (a2.hasNext()) {
            ReferenceHolder referenceHolder;
            com.inet.report.formula.ast.j j2 = a2.oZ();
            Object object = j2.qy();
            if (object instanceof String) {
                object = b2.a(false, (String)object, false);
            }
            if (!(object instanceof ReferenceHolder) || hashMap.containsKey(referenceHolder = (ReferenceHolder)object)) continue;
            hashMap.put(referenceHolder, j2);
        }
        return hashMap;
    }

    public int checkFormula(String formula, boolean basic, int nullBehavior) throws ReportException {
        d d2 = this.bB.getFormula();
        b b2 = d2.a(formula, basic, this.rL, nullBehavior, this.rH, this.op);
        b2.aF(true);
        if (b2 instanceof c) {
            c c2 = (c)b2;
            c2.a(this);
            Set<Integer> set = c2.pH();
            c2.a((IFormulaData)null);
            c2.b(set);
            c2.a(new p(d2.pi(), this));
        }
        return FormulaField.a(this.bB.getEngine(), this.rL, this.bB.getFormula(), b2, this);
    }

    @Override
    public int getValueType() {
        if (this.rP == null) {
            this.rP = new ThreadLocal();
        }
        try {
            if (this.rP.get() == Boolean.TRUE) {
                this.valueType = -1;
            } else {
                this.rP.set(Boolean.TRUE);
                if (this.valueType == -1) {
                    b b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
                    this.valueType = b2.aG(false);
                    this.dd();
                }
            }
        }
        catch (ReportException reportException) {
            this.valueType = -1;
        }
        finally {
            this.rP.set(Boolean.FALSE);
        }
        return this.valueType;
    }

    public void checkContext() throws ReportException {
        if (this.bB != null && this.bB.getFormula() != null) {
            b b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
            b2.aF(true);
            b2.checkContext();
        }
    }

    public static boolean isEmpty(String formula, boolean basic, Engine engine) throws ReportException {
        return FormulaField.isEmpty(formula, basic, engine, null, null);
    }

    public boolean isEmpty() {
        try {
            if (this.isOptimized()) {
                boolean bl2;
                boolean bl3 = bl2 = this.getFormulaTree() == null;
                if (bl2) {
                    String string = FormulaField.c(this);
                    return string == null || string.length() == 0;
                }
                return bl2;
            }
            return FormulaField.a(this.rv, this.getSyntax() == 1002, this.bB, this.op, this.rH);
        }
        catch (ReportException reportException) {
            return false;
        }
    }

    public static boolean isEmpty(String formula, boolean basic, Engine engine, Field currentField, Object defaultAttribute) throws ReportException {
        return FormulaField.a(formula, basic, engine.bI(), currentField, defaultAttribute);
    }

    private static boolean a(String string, boolean bl2, RendererBase<?> rendererBase, Field field, Object object) throws ReportException {
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        g g2 = rendererBase.getFormula().a(string, bl2, 0, object, field);
        return g2.isEmpty();
    }

    @Override
    Field[] D(int n2) {
        return new FormulaField[n2];
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.paramString());
        stringBuilder.append(ReportingServerPlugin.MSG.getMsg("ofType", new Object[]{"'" + FormulaField.Y(this.rL) + "'"}));
        stringBuilder.append(ReportingServerPlugin.MSG.getMsg("withBody", new Object[]{"'" + this.rv + "'"}));
        stringBuilder.append(ReportingServerPlugin.MSG.getMsg("returnType", new Object[]{"'" + this.getValueTypeString() + "'"}));
        return stringBuilder.toString();
    }

    void a(Properties properties, as as2) {
        this.rL = 3;
        this.valueType = as2.a(properties, "valueType", -1);
        if (this.valueType == 0) {
            this.valueType = -1;
        }
        this.name = as.a(properties, "propertyType", "");
        this.rM = PropertyConstants.toToken(this.name);
    }

    void b(Object object) {
        if (object instanceof ReportComponent) {
            ReportComponent reportComponent = (ReportComponent)object;
            reportComponent.a(this);
        } else if (object instanceof Group) {
            Group group = (Group)object;
            group.a(this);
        } else if (object instanceof SortField) {
            SortField sortField = (SortField)object;
            try {
                sortField.setSortDirectionFormula(this);
            }
            catch (ReportException reportException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToSQLResult toSql(SqlSyntax syntax, FieldFilter filter, boolean useDesignMode) throws ReportException {
        b b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
        b2.aF(useDesignMode);
        if (this.getFormulaTree() == null) {
            return null;
        }
        if (filter == null) {
            filter = new FieldFilter();
        }
        if (this.bB.isMain()) {
            b2.po();
            this.rC = true;
            return b2.a(syntax, false, false, filter);
        }
        Evaluable evaluable = this.getFormulaTree();
        boolean bl2 = this.rC;
        try {
            ToSQLResult toSQLResult = b2.a(syntax, false, false, filter);
            return toSQLResult;
        }
        finally {
            this.rC = bl2;
            this.setFormulaTree(evaluable);
        }
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "FormulaType", k.z(this.rL));
        k.a(stringBuilder, n2, a.sc.name(), k.z(this.getSyntax()));
        if (this.rx != 0) {
            k.a(stringBuilder, n2, a.se.name(), k.z(this.rx));
        }
        stringBuilder.append(string + k.h(this.rv) + "\n");
        if (this.getGroup() != null && this.getGroup().sn == null && this.getGroup().so == null && this.lL) {
            this.getGroup().a(printWriter, n2, false);
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    void a(int n2, String string, as as2) {
        switch (n2) {
            case 225: {
                this.setSyntax(Boolean.parseBoolean(string) ? 1002 : 1001);
                break;
            }
            case 224: {
                this.rL = Integer.parseInt(string);
                if (this.bB.getRecordSelectionFormula() == this) {
                    this.rL = 1;
                    break;
                }
                if (this.bB.getGroupSelection() != this) break;
                this.rL = 2;
                break;
            }
            default: {
                super.a(n2, string, as2);
            }
        }
    }

    int t(boolean bl2) throws ReportException {
        return this.b(bl2, false);
    }

    int b(boolean bl2, boolean bl3) throws ReportException {
        if (this.ry != -1) {
            return this.ry;
        }
        try {
            b b2 = null;
            if (this.getFormulaTree() == null) {
                b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
            }
            if (bl2 && !this.rC && this.getFormulaTree() != null) {
                if (this.valueType <= -1 && this.getNullBehavior() != 0) {
                    this.getValueType();
                }
                if (b2 == null) {
                    b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
                }
                b2.S(!this.bB.isMain());
                b2.po();
                this.rC = true;
            }
            this.ry = this.u(bl3);
            return this.ry;
        }
        catch (FormulaException formulaException) {
            formulaException.setFormulaField(this);
            throw formulaException;
        }
    }

    public int getEvaluateTimeReal() throws ReportException {
        return this.t(false);
    }

    private final int u(boolean bl2) throws ReportException {
        b b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
        if (this.getFormulaTree() == null) {
            return 0;
        }
        int n2 = d.c(this.getFormulaTree());
        if (this.rL == 3) {
            return 2;
        }
        if (this.rL == 1) {
            return 1;
        }
        if (this.rL == 2) {
            return 2;
        }
        int n3 = b2.getEvaluateTime();
        if (n2 != -1 && n2 < n3) {
            if (bl2 || this.bB != null && this.bB.getFormula() != null && b2.pk()) {
                FormulaException formulaException = FormulaException.create(ReportErrorCode.EvalTimeError, null, FormulaField.Z(n3), FormulaField.Z(n2));
                formulaException.setFormulaField(this);
                throw formulaException;
            }
            return -1;
        }
        if (n2 != -1) {
            this.ry = n2;
            return this.ry;
        }
        if (n3 == 0) {
            this.ry = 0;
            return 0;
        }
        if (n3 == 2) {
            this.ry = 2;
            return 2;
        }
        this.ry = 2;
        try {
            for (ReferenceHolder referenceHolder : this.getReferenceHolders()) {
                if (referenceHolder instanceof SummaryField && !((SummaryField)referenceHolder).jk()) {
                    this.ry = 1;
                    return 1;
                }
                if (!(referenceHolder instanceof FormulaField) || ((FormulaField)referenceHolder).u(bl2) != 1) continue;
                this.ry = 1;
                return 1;
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
        return this.ry;
    }

    private static String Z(int n2) {
        switch (n2) {
            case 0: {
                return "before reading records";
            }
            case 2: {
                return "while printing records";
            }
            case 1: {
                return "while reading records";
            }
        }
        return "unknown evaluate time " + n2;
    }

    public int getEvaluateTime() throws ReportException {
        if (this.rQ == null) {
            this.rQ = new ThreadLocal();
        }
        if (this.rQ.get() == Boolean.TRUE) {
            FormulaException formulaException = FormulaException.create(ReportErrorCode.ErrorSelfReference, null, null);
            formulaException.setFormulaField(this);
            throw formulaException;
        }
        try {
            this.rQ.set(Boolean.TRUE);
            b b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
            int n2 = b2.getEvaluateTime();
            return n2;
        }
        finally {
            this.rQ.set(Boolean.FALSE);
        }
    }

    private void dd() throws ReportException {
        Object object;
        if (!this.rT) {
            object = FormulaField.a(this, this.getReferencedObjects(), new HashSet<ReferenceHolder>());
            this.rU = object != null;
            Map<ReferenceHolder, com.inet.report.formula.ast.j> map = FormulaField.a(this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField()));
            com.inet.report.formula.ast.j j2 = map.get(object);
            if (j2 != null) {
                this.rV = j2.getPosition();
            }
            this.rT = true;
        }
        if (this.rU) {
            object = FormulaException.create(ReportErrorCode.ErrorSelfReference, this.rV, null);
            ((FormulaException)object).setFormulaField(this);
            throw object;
        }
    }

    private static ReferenceHolder a(ReferenceHolder referenceHolder, ReferencedObject[] referencedObjectArray, Set<ReferenceHolder> set) {
        if (referencedObjectArray != null) {
            for (ReferencedObject referencedObject : referencedObjectArray) {
                ReferenceHolder referenceHolder2;
                if (referencedObject == referenceHolder) {
                    return referenceHolder;
                }
                if (!(referencedObject instanceof ReferenceHolder) || set.contains(referenceHolder2 = (ReferenceHolder)((Object)referencedObject))) continue;
                set.add(referenceHolder2);
                if (FormulaField.a(referenceHolder, referenceHolder2.getReferencedObjects(), set) != null) {
                    return referenceHolder2;
                }
                set.add(referenceHolder2);
            }
        }
        return null;
    }

    static Field f(Field field) {
        if (field instanceof FormulaField && ((FormulaField)field).rL == 3) {
            ((FormulaField)field).rL = 0;
            int n2 = 0;
            while (true) {
                try {
                    field.setName(field.name + ++n2);
                }
                catch (ReportException reportException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                break;
            }
        }
        return field;
    }

    void b(String string, String string2, Datasource datasource) throws ReportException {
        StringList stringList = new StringList();
        if (datasource != null) {
            stringList.addAll(datasource.getAliasList());
        }
        this.a(string, string2, stringList);
    }

    private final String a(String string, StringList stringList) {
        Object object = string;
        if (((String)object).length() == 0) {
            object = "(";
            for (int i2 = 0; i2 < stringList.size(); ++i2) {
                object = (String)object + Pattern.quote(stringList.elementAt(i2));
                if (i2 >= stringList.size() - 1) continue;
                object = (String)object + "|";
            }
            object = (String)object + ")";
        } else {
            object = Pattern.quote((String)object);
        }
        return object;
    }

    private boolean a(int n2, List<Descriptor> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Descriptor descriptor = list.get(i2);
            if (n2 < descriptor.getStart() || n2 >= descriptor.getStart() + descriptor.getLength()) continue;
            return true;
        }
        return false;
    }

    private void a(String string, String string2, StringList stringList) {
        Object object;
        Highlighter highlighter = Highlighter.getHighlighter(this.bB.getEngine());
        List<Descriptor> list = highlighter.getHighlights(this.rv, this.ru, this.rw, true);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((Descriptor)object).getType() == Descriptor.TYPE.string) continue;
            object2.remove();
        }
        object2 = this.a(string, stringList);
        object = "\\{(\\s*)" + (String)object2 + "(?=\\s*[\\}\\.])";
        String string3 = "\\{$1" + string2.replace("\\", "\\\\").replace("$", "\\$");
        Pattern pattern = Pattern.compile((String)object);
        Matcher matcher = pattern.matcher(this.rv);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (this.a(matcher.start(), list)) continue;
            matcher.appendReplacement(stringBuffer, string3);
        }
        matcher.appendTail(stringBuffer);
        if (string.isEmpty() && !stringBuffer.isEmpty()) {
            object = "\\{(\\s*)%(?=\\w+\\s*\\})";
            string3 = string3 + ".";
            pattern = Pattern.compile((String)object);
            matcher = pattern.matcher(stringBuffer.toString());
            stringBuffer.setLength(0);
            while (matcher.find()) {
                if (this.a(matcher.start(), list)) continue;
                matcher.appendReplacement(stringBuffer, string3);
            }
            matcher.appendTail(stringBuffer);
        }
        this.setFormula(stringBuffer.toString());
    }

    @Override
    public void addReferencedObject(ReferencedObject reference) {
        ah ah2 = this.bY().get(reference);
        if (ah2 == null) {
            this.bY().put(reference, new ah(1));
        } else {
            ah2.dA();
        }
    }

    HashMap<ReferencedObject, ah> bY() {
        if (this.lE == null) {
            this.lE = new HashMap();
        }
        return this.lE;
    }

    @Override
    public ReferencedObject[] getReferencedObjects() {
        return this.bY().keySet().toArray(new ReferencedObject[0]);
    }

    @Override
    public int getReferencedObjectCount() {
        return this.bY().size();
    }

    @Override
    public int getRealReferencedObjectCount() {
        int n2 = 0;
        ReferencedObject[] referencedObjectArray = this.getReferencedObjects();
        for (int i2 = 0; i2 < referencedObjectArray.length; ++i2) {
            ah ah2 = this.bY().get(referencedObjectArray[i2]);
            n2 += ah2 != null ? ah2.getValue() : 0;
        }
        return n2;
    }

    @Override
    public void removeReferencedObject(ReferencedObject reference) {
        ah ah2 = this.bY().get(reference);
        if (ah2 != null && ah2.dB() == 0) {
            this.bY().remove(reference);
        }
    }

    @Override
    public void setReferences() {
        if (this.rA) {
            return;
        }
        this.rA = true;
        b b2 = null;
        try {
            b2 = this.bB.getFormula().a(this, this.getDefaultAttribute(), this.getCurrentField());
            if (b2 instanceof b) {
                b2.pq();
            }
            this.valueType = -1;
            this.rC = false;
            this.ry = -1;
            this.rS = null;
            this.rT = false;
            this.rU = false;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ReportException) {
                this.rS = this.a((ReportException)throwable, b2 != null && b2.pk());
            }
        }
        finally {
            this.rA = false;
        }
    }

    @Override
    public void resetReferences() {
        this.setFormulaTree(null);
        ReferencedObject[] referencedObjectArray = this.getReferencedObjects();
        for (int i2 = 0; i2 < referencedObjectArray.length; ++i2) {
            while (this.bY().get(referencedObjectArray[i2]) != null) {
                referencedObjectArray[i2].removeReferenceHolder(this);
                if (!(referencedObjectArray[i2] instanceof SummaryField)) continue;
                FormulaField.a((SummaryField)referencedObjectArray[i2], this.bB);
            }
        }
        this.valueType = -1;
        this.rC = false;
        this.ry = -1;
        this.rS = null;
        this.rT = false;
        this.rU = false;
    }

    private static void a(SummaryField summaryField, RendererBase<?> rendererBase) {
        try {
            ArrayList<SummaryField> arrayList = rendererBase.getFormula().pM();
            if (arrayList.contains(summaryField)) {
                if (summaryField.getReferenceHolderCount() == 0) {
                    arrayList.remove(summaryField);
                    for (int i2 = 0; i2 < rendererBase.getFields().getSummaryFieldsCount(); ++i2) {
                        if (rendererBase.getFields().getSummaryField(i2) != summaryField) continue;
                        rendererBase.getFields().removeSummaryField(i2);
                    }
                } else {
                    ReferenceHolder[] referenceHolderArray = summaryField.getReferenceHolders();
                    boolean bl2 = false;
                    for (ReferenceHolder referenceHolder : referenceHolderArray) {
                        if (!(referenceHolder instanceof FormulaField)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        arrayList.remove(summaryField);
                    }
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isUsed() {
        try {
            if (this.rR) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                this.dd();
            }
            catch (ReportException reportException) {
                if (reportException instanceof FormulaParserException) {
                    boolean bl3 = false;
                    this.rR = false;
                    return bl3;
                }
                boolean bl4 = true;
                this.rR = false;
                return bl4;
            }
            this.rR = true;
            if (this.getFormulaType() == 3 || this.getFormulaType() == 2 || this.getFormulaType() == 1) {
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = super.isUsed();
            return bl6;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rR = false;
        }
    }

    @Override
    public void setOptimized() {
        this.rC = true;
    }

    @Override
    public boolean isOptimized() {
        return this.rC;
    }

    static final String c(FormulaField formulaField) {
        if (formulaField.rO) {
            return formulaField.rv;
        }
        String string = formulaField.rv;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[string.length()];
        int n2 = 0;
        string.getChars(0, cArray.length, cArray, 0);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == n2) {
                n2 = 0;
            } else if (cArray[i2] == '\'') {
                n2 = 39;
            } else if (cArray[i2] == '\"') {
                n2 = 34;
            } else if (cArray[i2] == '{') {
                n2 = 125;
            }
            if (i2 < cArray.length - 1 && cArray[i2] == '/' && cArray[i2 + 1] == '/' && n2 == 0) {
                while (i2 < cArray.length && cArray[i2] != '\n') {
                    ++i2;
                }
                continue;
            }
            stringBuilder.append(cArray[i2]);
        }
        formulaField.rO = true;
        formulaField.rv = stringBuilder.toString().trim();
        return formulaField.rv;
    }

    static final void d(FormulaField formulaField) {
        if (formulaField == null) {
            return;
        }
        formulaField.resetReferences();
        formulaField.bB.getFormula().l(formulaField);
    }

    void G(String string) {
        this.rC = false;
        this.rv = string;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            a.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.error("Unknown Tag for <Field type=\"FormulaField\">: <" + tag + ">");
            return null;
        }
        String string = "";
        string = atts.getValue("value");
        if (string == null) {
            BaseUtils.error("No attribute 'value' for <" + tag + ">");
            return null;
        }
        try {
            this.r(tag, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        String string = this.getFormula();
        this.setFormula(string);
        switch (this.rL) {
            case 3: {
                if (this.rN == null) break;
                this.b(this.rN);
            }
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        String string = this.getFormula();
        string = string.concat(text);
        this.G(string);
    }

    private void r(String string, String string2) throws ReportException {
        a a2 = a.rZ;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case sa: {
                this.setName(string2);
                break;
            }
            case sd: {
                int n2 = Integer.parseInt(string2);
                if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
                    return;
                }
                this.setFormulaType(n2);
                if (this.bB.getRecordSelectionFormula() == this) {
                    this.setFormulaType(1);
                    break;
                }
                if (this.bB.getGroupSelection() != this) break;
                this.setFormulaType(2);
                break;
            }
            case sc: {
                this.setSyntax(1001);
                if (string2.length() <= 0) break;
                try {
                    this.setSyntax(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    BaseUtils.warning(numberFormatException);
                    boolean bl2 = Boolean.valueOf(string2);
                    if (!bl2) break;
                    this.setSyntax(1002);
                }
                break;
            }
            case se: {
                if (string2.length() <= 0) break;
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 >= 0 && n3 <= 2) {
                        this.setNullBehavior(n3);
                        break;
                    }
                    BaseUtils.warning("Invalid Null-Behavior constant was defined for formula field '" + this.getName() + "'");
                }
                catch (NumberFormatException numberFormatException) {
                    BaseUtils.warning(numberFormatException);
                }
                break;
            }
        }
    }

    void a(StringBuilder stringBuilder, int n2, String string) {
        switch (this.rL) {
            case 0: 
            case 1: 
            case 2: {
                throw new RuntimeException("internal error in FormulaField.save()");
            }
            case 3: {
                if (this.getFormula().trim().length() == 0) break;
                String string2 = BaseUtils.getIndent(n2);
                ++n2;
                StringBuilder stringBuilder2 = new StringBuilder();
                if (this.name != null) {
                    k.a(stringBuilder2, n2, a.sa.name(), this.name);
                }
                stringBuilder.append(string2 + "<PropertyFormula" + k.l("propertyType", string) + ">\n");
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                k.a(stringBuilder, n2, a.sc.name(), k.z(this.getSyntax()));
                k.a(stringBuilder, n2, a.se.name(), k.z(this.getNullBehavior()));
                stringBuilder.append(BaseUtils.getIndent(n2) + k.h(this.rv) + "\n");
                stringBuilder.append(string2 + "</PropertyFormula>\n");
            }
        }
    }

    Object[] de() {
        return this.rK;
    }

    void b(Object[] objectArray) {
        this.rK = objectArray;
    }

    Object df() {
        return this.rJ;
    }

    void c(Object object) {
        this.rJ = object;
    }

    @Override
    public Field duplicate(String name) {
        FormulaField formulaField = this.bB.getFields().addFormulaField(name, this.rv, this.rL);
        formulaField.ru = this.ru;
        formulaField.setCurrentField(this.op);
        formulaField.rM = this.rM;
        formulaField.rx = this.rx;
        return formulaField;
    }

    public int getNullBehavior() {
        return this.rx;
    }

    public void setNullBehavior(int nullBehavior) {
        this.rx = nullBehavior < 0 ? 0 : (nullBehavior > 2 ? 2 : nullBehavior);
    }

    public boolean usesSummaryFields() {
        boolean bl2 = this.a((ReferencedObject)this, 0);
        boolean bl3 = this.a(this, 0);
        return bl2 && bl3;
    }

    private boolean a(ReferenceHolder referenceHolder, int n2) {
        if (n2 > 10) {
            return false;
        }
        ReferencedObject[] referencedObjectArray = referenceHolder.getReferencedObjects();
        if (referencedObjectArray != null && referencedObjectArray.length > 0) {
            for (ReferencedObject referencedObject : referencedObjectArray) {
                if (referencedObject == this) {
                    return false;
                }
                if (referencedObject instanceof SummaryField) {
                    return true;
                }
                if (!(referencedObject instanceof ReferenceHolder) || !this.a((ReferenceHolder)((Object)referencedObject), ++n2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(ReferencedObject referencedObject, int n2) {
        if (n2 > 10) {
            return false;
        }
        ReferenceHolder[] referenceHolderArray = referencedObject.getReferenceHolders();
        if (referenceHolderArray != null && referenceHolderArray.length > 0) {
            for (ReferenceHolder referenceHolder : referenceHolderArray) {
                if (referenceHolder == this) {
                    return false;
                }
                if (referenceHolder instanceof SummaryField) {
                    return true;
                }
                if (!(referenceHolder instanceof ReferencedObject) || !this.a((ReferencedObject)((Object)referenceHolder), ++n2)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getTranslationKeys() {
        final ArrayList arrayList = new ArrayList();
        e e2 = new e(this.bB.getFormula()){

            @Override
            public Evaluable a(e.b b2, Evaluable[] evaluableArray, Token token) throws ReportException {
                if (b2.rX() == e.a.aoJ && b2.bW() == 1333 && evaluableArray != null && evaluableArray.length > 0) {
                    arrayList.add(evaluableArray[0]);
                }
                return super.a(b2, evaluableArray, token);
            }
        };
        c c2 = this.bB.getFormula().a(e2, this.getDefaultAttribute(), this.getCurrentField());
        try {
            c2.a(this);
            this.setFormulaTree(null);
            c2.pn();
            HashSet<String> hashSet = new HashSet<String>(arrayList.size());
            for (Evaluable evaluable : arrayList) {
                try {
                    Object object = evaluable.eval(c2);
                    if (object == null) continue;
                    hashSet.add(object.toString());
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) continue;
                    BaseUtils.debug("Failed to get translation key for " + String.valueOf(evaluable));
                    BaseUtils.warning(reportException);
                }
            }
            if (hashSet.size() > 0) {
                return hashSet;
            }
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Failed to get translation keys for the formula '" + this.getName() + "'");
                BaseUtils.warning(reportException);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validity validate() {
        if (this.rS != null) {
            return this.rS;
        }
        d d2 = this.bB.getFormula();
        g g2 = null;
        try {
            this.valueType = -1;
            if (this.rP == null) {
                this.rP = new ThreadLocal();
            }
            if (this.rP.get() == Boolean.TRUE) {
                FormulaException formulaException = FormulaException.create(ReportErrorCode.ErrorSelfReference, null, null);
                formulaException.setFormulaField(this);
                throw formulaException;
            }
            this.rP.set(Boolean.TRUE);
            g2 = d2.b(this.rv, this.ru == 1002, this.rL, this.rx, this.rH, this.op);
            boolean bl2 = true;
            if (g2 instanceof c) {
                ReferenceHolder[] referenceHolderArray = (ReferenceHolder[])g2;
                referenceHolderArray.a(this);
                Set<Integer> set = referenceHolderArray.pH();
                referenceHolderArray.b(set);
                if (this.rD != null) {
                    bl2 = false;
                }
            }
            if (bl2) {
                g2.pn();
            }
            this.valueType = g2.aG(true);
            g2.aF(true);
            g2.checkContext();
            g2.aG(true);
            g2.aF(false);
            g2.checkContext();
            g2.po();
            if (this.valueType > 0 && (this.valueType & 0x100) > 0) {
                for (ReferenceHolder referenceHolder : this.getReferenceHolders()) {
                    if (!(referenceHolder instanceof FieldElement) && !(referenceHolder instanceof FieldPart)) continue;
                    Validity validity = new Validity(Validity.States.WARNING, ReportExceptionFactory.createReportException(ReportErrorCode.WarningPrintedArray, this.getName()));
                    return validity;
                }
            }
            this.dd();
            this.ry = this.u(true);
            this.rS = new Validity(Validity.States.VALID, null);
        }
        catch (ReportException reportException) {
            this.rS = this.a(reportException, g2 != null && g2.pk());
        }
        finally {
            this.rP.set(Boolean.FALSE);
        }
        return this.rS;
    }

    private Validity a(ReportException reportException, boolean bl2) {
        if (reportException instanceof FormulaException) {
            FormulaException formulaException = (FormulaException)reportException;
            if (formulaException.getCausingFormulaName() == null || this.getName().equals(formulaException.getCausingFormulaName())) {
                formulaException.setFormulaField(this);
                if (bl2) {
                    return new Validity(Validity.States.WARNING, formulaException);
                }
                return new Validity(Validity.States.ERROR, formulaException);
            }
            if (bl2) {
                return new Validity(Validity.States.VALID, null);
            }
            return new Validity(Validity.States.DEPENDING_ERROR, formulaException);
        }
        if (reportException == null) {
            return new Validity(Validity.States.VALID, null);
        }
        if (bl2) {
            return new Validity(Validity.States.WARNING, reportException);
        }
        return new Validity(Validity.States.ERROR, reportException);
    }

    @Override
    public q getLocalVariables() {
        if (this.rw == null) {
            this.rw = new q();
        }
        return this.rw;
    }

    @Override
    public void clearLocalVariables() {
        this.rw = null;
    }

    void d(Object object) {
        this.rH = object;
    }

    Object getDefaultAttribute() {
        return this.rH;
    }

    public void setCurrentField(Field currentField) {
        this.op = currentField;
    }

    public Field getCurrentField() {
        return this.op;
    }

    @Override
    public void setFormulaTree(Evaluable tree) {
        this.rD = tree;
    }

    @Override
    public Evaluable getFormulaTree() {
        return this.rD;
    }

    void dg() {
        this.rG = null;
        this.rJ = this;
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.getDataProvider();
        if (reportDataHandler.getReturnSQLvalues()) {
            String string = FormulaField.c(this);
            if (string != null && string.trim().length() > 0) {
                ToSQLResult toSQLResult;
                g g2 = this.bB.getFormula().a(string, this.getSyntax() == 1002, 0, null, null);
                g2.S(!this.bB.isMain());
                g2.po();
                DataFactory dataFactory = this.bB.getDbTables().getDatasource(0).getDataFactory();
                if (DatabaseUtils.useJdbcDriver(dataFactory) && (toSQLResult = g2.a((Database)dataFactory, false, false, null)) != null) {
                    if (toSQLResult.hasNonDBPart()) {
                        throw toSQLResult.getPartExceptions().get(0);
                    }
                    return toSQLResult.getSqlResult();
                }
            }
            return null;
        }
        return this.bB.a(this, null);
    }

    void aa(int n2) {
        this.rI = n2;
    }

    int dh() {
        switch (this.rL) {
            case 1: 
            case 2: {
                return 8;
            }
            case 0: {
                return -1;
            }
        }
        int n2 = PropertyConstants.toToken(this.name);
        if (n2 >= 0) {
            return PropertyConstants.getValueTypeForToken(n2);
        }
        return this.rI;
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a rZ = new a();
        public static final /* enum */ a sa = new a();
        public static final /* enum */ a sb = new a();
        public static final /* enum */ a sc = new a();
        public static final /* enum */ a sd = new a();
        public static final /* enum */ a se = new a();
        private static final /* synthetic */ a[] sf;

        public static a[] values() {
            return (a[])sf.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] di() {
            return new a[]{rZ, sa, sb, sc, sd, se};
        }

        static {
            sf = a.di();
        }
    }
}

