/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.HasErrorCode;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.bx;
import com.inet.report.cache.Cache;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.b;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@PublicApi
public class EngineRenderData
implements RenderData {
    private final Properties ho = new Properties();
    private Properties hr;
    private final Hashtable oJ = new Hashtable();
    private String url = null;
    private boolean hv;
    protected boolean isRefresh = true;
    private String hs;
    private int hu = 1;
    private PropertiesChecker oK;
    private ZipOutputStream oL;
    private a oM;

    public EngineRenderData(String props) {
        bx.jB();
        this.setReportLocation(props);
        this.oK = new PropertiesChecker(){

            @Override
            public void checkProperties(Properties prop, Object req) throws ReportException {
            }

            @Override
            public void checkProperties(Engine engine, Properties prop, Object req) throws ReportException {
            }
        };
    }

    @Override
    public void setReportLocation(String location) {
        this.ho.clear();
        this.ho.put("export_fmt", "java");
        bx.b(location, this.ho, false);
        try {
            ReportKeyFactory.decodeProps(this.ho);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = location;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    public void clearEngineCache() {
        this.oJ.clear();
    }

    protected Engine createEngine(Properties props) throws ReportException {
        Engine engine = new Engine(props.getProperty("export_fmt"));
        this.setEngineParams(engine, props);
        return engine;
    }

    protected String getKey(Properties props) throws ReportException {
        if (this.isRefresh && this.isPromptOnRefresh()) {
            this.isRefresh = false;
            props.put("promptonrefresh", "1");
        } else {
            props.put("promptonrefresh", "0");
        }
        this.oK.checkProperties(props, null);
        return ReportKeyFactory.a(props).toString();
    }

    protected Engine getEngine(String key) {
        return (Engine)this.oJ.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine checkEngine(Properties props) throws ReportException {
        Hashtable hashtable = this.oJ;
        synchronized (hashtable) {
            boolean bl2 = this.isRefresh;
            String string = this.getKey(props);
            Engine engine = (Engine)this.oJ.get(string);
            if (engine != null) {
                return engine;
            }
            BaseUtils.info("new engine: " + string);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("props: " + String.valueOf(props));
            }
            engine = this.createEngine(props);
            if (bl2) {
                bx.h(engine).getDataProvider().deleteCacheReportKey();
            }
            engine.execute();
            this.oJ.put(string, engine);
            return engine;
        }
    }

    protected Engine setEngineParams(Engine engine, Properties props) {
        return this.setEngineParams(engine, props, false);
    }

    protected Engine setEngineParams(Engine engine, Properties props, boolean rdc) {
        try {
            props = (Properties)props.clone();
            bx.a(null, engine, props, this.oK, null, rdc);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ReportException && ((ReportException)throwable).getErrorCode() == ReportErrorCode.FeatureForbidden.getErrorCodeNumber()) {
                throw this.a(throwable, props);
            }
            BaseUtils.printStackTrace(throwable);
            try {
                if (engine.getArea(0) == null) {
                    throw this.a(throwable, props);
                }
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
            Properties properties = new Properties();
            for (String string : props.keySet()) {
                if (string.startsWith("prompt") && !string.equalsIgnoreCase("promptonrefresh")) continue;
                properties.put(string, props.get(string));
            }
            try {
                engine.getArea(0);
                bx.a(null, engine, properties, this.oK, null, true);
            }
            catch (Throwable throwable2) {
                BaseUtils.printStackTrace(throwable2);
                throw this.a("Could not set engine properties, please check URL.\n" + throwable2.getMessage(), throwable2, props);
            }
        }
        return engine;
    }

    public void setPropertiesChecker(PropertiesChecker propChecker) {
        if (propChecker == null) {
            throw new IllegalArgumentException();
        }
        this.oK = propChecker;
    }

    public PropertiesChecker getPropertiesChecker() {
        return this.oK;
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.ho);
            return engine.getPageData(page);
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.ho);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.ho);
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.ho);
        }
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        try {
            Engine engine = this.getEngine(this.getKey(this.ho));
            return engine != null && engine.isPageLimitExceeded();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.ho);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string;
            Engine engine = this.checkEngine(this.hr);
            switch (string = this.hr.getProperty("export_fmt")) {
                case "svg": {
                    if (this.hu == 0) {
                        ++this.hu;
                        String string2 = this.hr.getProperty("file");
                        string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                        int n2 = SVGUtils.getAutoRefresh(this.hr);
                        return SVGUtils.getSvgViewerPackage(engine.nO.getPageCount(), true, string2, n2);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    RenderDataUtils.writeFileData(byteArrayOutputStream, this.hu + ".svg", engine.getPageData(this.hu++));
                    return byteArrayOutputStream.toByteArray();
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    if (this.oM == null) break;
                    int n3 = engine.getPageCount();
                    while (this.oM.cC() == 0 && this.hu <= n3) {
                        ZipEntry zipEntry = new ZipEntry(this.hu + "." + string);
                        this.oL.putNextEntry(zipEntry);
                        this.oL.write(engine.getPageData(this.hu++));
                        this.oL.closeEntry();
                    }
                    if (this.hu > n3 && this.oL != null) {
                        this.oL.close();
                        this.oL = null;
                    }
                    return this.oM.cD();
                }
            }
            if (this.hu > 0) {
                return engine.getPageData(this.hu++);
            }
            if (this.hu == 0) {
                ++this.hu;
                return engine.getGroupTree();
            }
            ++this.hu;
            if (string.startsWith("htm")) {
                String string3 = this.hr.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hr);
        }
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        try {
            this.hr = bx.a(this.ho, expProps);
            Engine engine = this.checkEngine(this.hr);
            String string = expProps.getProperty("export_fmt");
            Objects.requireNonNull(string);
            switch (string) {
                case "svg": {
                    this.hu = 0;
                    return engine.getPageCount() + 1;
                }
                case "htm": 
                case "htm.zip": 
                case "html": {
                    this.hu = -1;
                    return engine.getPageCount() + 2;
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    int n2 = engine.getPageCount();
                    if (n2 > 1) {
                        this.hu = 1;
                        this.oM = new a();
                        this.oL = new ZipOutputStream(new BufferedOutputStream(this.oM, 4096));
                        return 0;
                    }
                    this.oM = null;
                }
            }
            this.hu = 1;
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hr);
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.ho);
            return engine.getGroupTree();
        }
        catch (Exception exception) {
            throw this.a(exception, this.ho);
        }
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        this.isRefresh = true;
        this.oJ.clear();
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.ho.remove(key);
        } else {
            this.ho.setProperty(key, value);
        }
    }

    @Override
    public final String getReportProperty(String key) {
        return this.ho.getProperty(key);
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hv = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hv;
    }

    private ViewerException a(Throwable throwable, Properties properties) {
        return this.a(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable), throwable, properties);
    }

    private ViewerException a(String string, Throwable throwable, Properties properties) {
        int n2;
        if (throwable instanceof PromptRequestWarning) {
            Prompt[] promptArray = ((PromptRequestWarning)throwable).getPrompts();
            PromptData[] promptDataArray = new PromptData[promptArray.length];
            for (int i2 = 0; i2 < promptArray.length; ++i2) {
                Prompt prompt = promptArray[i2];
                promptDataArray[i2] = promptArray[i2].isNotUsed() ? new PromptData(true) : new PromptData(prompt.getName(), prompt.getDisplayName(), prompt.getSubreportName(), prompt.getPromptText(), prompt.getDefaultValues(), prompt.getDescs(), prompt.getValueTypeNewProt(), prompt.isDiscrete(), prompt.isRange(), prompt.isMulti(), prompt.isEditable(), prompt.isOnlyDescs(), prompt.isInformixPrompt(), prompt.getEditMask(), prompt.getMinValue(), prompt.getMaxValue());
                promptDataArray[i2].setCascadingParent(prompt.getCascadingParent());
            }
            return new ViewerException(promptDataArray);
        }
        if (throwable instanceof ViewerException) {
            return (ViewerException)throwable;
        }
        int n3 = 0;
        Cache cache = Cache.getCache();
        int n4 = n2 = cache != null ? cache.getType() : -1;
        if (throwable instanceof HasErrorCode) {
            n3 = ((HasErrorCode)throwable).getErrorCode();
        }
        return new ViewerException(n3, string, properties.getProperty("export_fmt"), Engine.getVersion(), System.getProperty("java.version", "") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"), System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""), n2, "2.1", throwable, b.getSupportEmail());
    }

    @Override
    public void setReportTitle(String title) {
        this.hs = title;
    }

    @Override
    public String getReportTitle() {
        return this.hs;
    }

    @Override
    public RenderData getCopy() {
        EngineRenderData engineRenderData = new EngineRenderData(this.url);
        engineRenderData.getProperties().putAll((Map<?, ?>)this.getProperties());
        engineRenderData.isRefresh = this.isRefresh;
        return engineRenderData;
    }

    @Override
    public Properties getProperties() {
        return this.ho;
    }

    @Override
    public void stop() {
        Enumeration enumeration = this.oJ.elements();
        while (enumeration.hasMoreElements()) {
            Engine engine = (Engine)enumeration.nextElement();
            if (engine == null) continue;
            engine.stop("API call EngineRenderData.stop()");
        }
        this.oJ.clear();
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.ho);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            Engine engine = this.checkEngine(this.ho);
            return engine.getFontData(fontID);
        }
        catch (ReportException reportException) {
            return e.getErrorData(reportException, this.ho);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        throw new ViewerException("resetting does not work for EngineRenderData. You should not see this error.");
    }

    private static class a
    extends OutputStream {
        private final ArrayList<byte[]> oO = new ArrayList();

        private a() {
        }

        @Override
        public void write(int b2) throws IOException {
            this.oO.add(new byte[]{(byte)b2});
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            byte[] byArray = new byte[len];
            System.arraycopy(b2, off, byArray, 0, len);
            this.oO.add(byArray);
        }

        int cC() {
            return this.oO.size();
        }

        byte[] cD() {
            if (this.oO.size() > 0) {
                return this.oO.remove(0);
            }
            return null;
        }
    }
}

