/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.ReferenceHolder;
import com.inet.report.RendererBase;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.as;
import com.inet.report.database.DataFactory;
import com.inet.report.i18n.ReportErrorCode;
import java.io.PrintWriter;
import java.util.StringTokenizer;

@PublicApi
public class DatabaseField
extends Field {
    int kT;
    Field kU;
    TableSource kV = null;
    private String kW = "";
    String kX;

    DatabaseField(RendererBase ren) {
        this.type = 14;
        this.bB = ren;
    }

    @Override
    public void setName(String fullname) throws ReportException {
        Object object;
        Object object2;
        if (fullname == null || fullname.length() == 0) {
            throw new IllegalArgumentException("The name of a database field cannot be empty.");
        }
        try {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(fullname, "\".", true);
            object2 = stringTokenizer.nextToken();
            if (((String)object2).equals("\"")) {
                do {
                    string = stringTokenizer.nextToken();
                    object2 = (String)object2 + string;
                } while (!string.equals("\""));
            }
            stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                object = (String)object + string;
            }
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.missingAliasOrTableName, fullname);
        }
        this.kV = this.bB.getDbTables().getTablesource((String)object2);
        int n2 = this.kV.ar((String)object);
        if (n2 == -1) {
            return;
        }
        this.name = fullname;
        this.kX = object;
        this.valueType = n2;
        Fields.a(this.bB, this, 2);
    }

    public void setColumnLabel(String columnLabel) {
        if (columnLabel == null) {
            columnLabel = "";
        }
        this.kW = columnLabel;
        Fields.a(this.bB, this, 2);
    }

    public String getColumnLabel() {
        return this.hasColumnLabel() ? this.kW : this.getShortName();
    }

    public boolean hasColumnLabel() {
        return !this.kW.isBlank();
    }

    public String getShortName() {
        return this.kX;
    }

    @Override
    public void rename(String newName) throws ReportException {
        if (this.bB.getDbFields().contains(newName)) {
            DatabaseField databaseField = this.bB.getDbFields().get(newName);
            this.bB.getDbFields().removeElement(databaseField);
            DatabaseField databaseField2 = this;
            TableSource tableSource = databaseField.kV;
            databaseField2.getTableSource().e(databaseField2);
            tableSource.a(databaseField2);
            tableSource.e(databaseField);
            ReferenceHolder[] referenceHolderArray = databaseField.getReferenceHolders();
            int n2 = referenceHolderArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ReferenceHolder referenceHolder;
                ReferenceHolder referenceHolder2 = referenceHolder = referenceHolderArray[i2];
                databaseField2.addReferenceHolder(referenceHolder2);
            }
        }
        int n3 = newName.indexOf(".");
        this.kX = newName.substring(n3 + 1);
        super.rename(newName);
    }

    @Override
    Field[] D(int n2) {
        return new DatabaseField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
    }

    @Override
    void a(int n2, String string, as as2) {
        switch (n2) {
            case 174: {
                this.kX = string;
                break;
            }
            default: {
                super.a(n2, string, as2);
            }
        }
    }

    public TableSource getTableSource() {
        return this.kV;
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.getDataProvider();
        if (reportDataHandler.getRowSource() == null) {
            Datasource datasource = this.kV != null ? this.kV.getDatasource() : this.bB.getDbTables().getDatasource(0);
            DataFactory dataFactory = datasource.getDataFactory();
            if (dataFactory instanceof Database) {
                return ((Database)dataFactory).convertIdentifier(datasource, this.name);
            }
            return this.name;
        }
        int n2 = this.cV();
        if (n2 < 0) {
            this.U(reportDataHandler.getColumnIdx(this));
            n2 = this.cV();
        }
        return reportDataHandler.getObject(n2);
    }

    public String toString() {
        return super.toString() + "_" + this.kW + "_" + this.kX + "_" + this.kT;
    }
}

