/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axK;
    private static Hashtable<String, Object> bsW;
    private static long bsX;
    private static long bsY;
    private static int bsZ;
    private static int bta;
    private static int btb;
    private static volatile int btc;
    private static volatile int btd;
    private static Set<Integer> bte;
    private static Set<String> btf;
    private static Set<String> btg;
    private static double bth;
    private static int bti;
    private static int btj;
    private static double btk;
    private static double btl;
    private static int btm;
    private static int btn;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.Mi();
        ++bsZ;
    }

    public static void incReportRequest() {
        ++bta;
    }

    public static void incRenderedReports() {
        ++btb;
        btd = Math.max(btd, ++btc);
    }

    public static void decRenderedReports() {
        --btc;
    }

    public static int getCurrentRenderingReports() {
        return btc;
    }

    public static int getMaxRenderingReports() {
        return btd;
    }

    public static void countReportTemplates(URL reportUrl) {
        bte.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        btf.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        btg.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        bth += (double)pages;
        ++bti;
        btj = Math.max(btj, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        btk += (double)fetchedRecord;
        btl += (double)discardedRecords;
        btm = Math.max(btm, fetchedRecord);
        btn = Math.max(btn, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = bsW.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void Mi() {
        long l2 = System.currentTimeMillis();
        if (l2 > bsX) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= bsX) return;
                Accumulator.a(bsW, "");
                Accumulator.save();
                bsZ = 0;
                bta = 0;
                btb = 0;
                bth = 0.0;
                btj = 0;
                bti = 0;
                btk = 0.0;
                btm = 0;
                btl = 0.0;
                btn = 0;
                bte.clear();
                btf.clear();
                btg.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bsY) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bsY) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axK == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        bsW.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(bsZ, hashtable, "Total Requests" + string);
        Accumulator.a(bta, hashtable, "Report Requests" + string);
        Accumulator.a(btb, hashtable, "Rendered Reports" + string);
        Accumulator.a(bth, hashtable, "Total Page Count" + string);
        Accumulator.a(btj, hashtable, "Maximal Page Count" + string);
        Accumulator.a(btk, hashtable, "Total fetched Records" + string);
        Accumulator.a(btm, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(btl, hashtable, "Total discarded Records" + string);
        Accumulator.a(btn, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(bte.size(), hashtable, "Report Templates");
            Accumulator.a(btf.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", btf);
            Accumulator.a(btg.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", btg);
            Accumulator.a(bth / (double)bti, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, bte);
            hashtable.put("Client Languages" + string, btf);
            hashtable.put("Report Formats" + string, btg);
            hashtable.put("Average Page Count" + string, bti);
        }
        hashtable.put("Next Day", bsX);
    }

    private static Hashtable<String, Object> Mj() {
        Hashtable<String, Object> hashtable = bsW = new Hashtable<String, Object>();
        try {
            axK = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axK));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    bsW = hashtable;
                } else {
                    hashtable = bsW;
                }
                bsZ = (int)Accumulator.dB("Total Requests");
                bta = (int)Accumulator.dB("Report Requests");
                btb = (int)Accumulator.dB("Rendered Reports");
                bth = Accumulator.dB("Total Page Count");
                btj = (int)Accumulator.dB("Maximal Page Count");
                bti = (int)Accumulator.dB("Average Page Count");
                btk = Accumulator.dB("Total fetched Records");
                btm = (int)Accumulator.dB("Maximal fetched Records");
                btl = Accumulator.dB("Total discarded Records");
                btn = (int)Accumulator.dB("Maximal discarded Records");
                bte = Accumulator.dC("Report Templates");
                btf = Accumulator.dC("Client Languages");
                btg = Accumulator.dC("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.Mk();
                    bsX = l2;
                    Accumulator.Mi();
                }
            }
            catch (Throwable throwable) {
                bsW = hashtable;
                bte = Collections.synchronizedSet(new HashSet());
                btf = Collections.synchronizedSet(new HashSet());
                btg = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.Mk();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            bte = Collections.synchronizedSet(new HashSet());
            btf = Collections.synchronizedSet(new HashSet());
            btg = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void Mk() {
        Date date = new Date();
        bsY = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        bsX = date.getTime();
    }

    private static synchronized void save() {
        if (axK == null) {
            return;
        }
        Accumulator.Mk();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axK));
            objectOutputStream.writeObject(bsW);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dB(String string) {
        Number number = (Number)bsW.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dC(String string) {
        Set set = (Set)bsW.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        bsW = Accumulator.Mj();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

