/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.drive;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;

@InternalApi
public class DriveReportPermissionChecker
implements PluginPermissionChecker {
    private static final ConfigValue<Boolean> awI = new ConfigValue(ConfigKey.REPOLOCATION_ENABLED);
    private static final ConfigValue<Boolean> awJ = new ConfigValue(ConfigKey.SYSTEMPERMISSION_ENABLED);
    public static final DrivePermissionType EXECUTE = new DrivePermissionType("reporting", "execute", () -> ReportingServerPlugin.MSG.getMsg("permission.execute", new Object[0]));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkExecutePermission(URL url) throws AccessDeniedException {
        if (url == null) return false;
        if (!DriveReportPermissionChecker.isDriveProtocol(url)) {
            return false;
        }
        String string = url.getPath();
        string = EncodingFunctions.decodeUrlPath((String)string);
        try {
            UserAccountScope userAccountScope;
            Drive drive = Drive.getInstance();
            if (((Boolean)awJ.get()).booleanValue() && SystemPermissionChecker.checkAccess((Permission)PermissionChecker.PERMISSION_EXECUTE_ALL_REPORTS)) {
                return true;
            }
            DriveEntry driveEntry = null;
            if (UserManager.getInstance().getCurrentUserAccountID() != null) {
                driveEntry = drive.resolve(string);
            }
            if (driveEntry == null) {
                userAccountScope = UserAccountScope.createPrivileged();
                try {
                    driveEntry = drive.resolve(string);
                    if (driveEntry == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                finally {
                    if (userAccountScope != null) {
                        userAccountScope.close();
                    }
                }
            }
            if ((userAccountScope = (GUID)driveEntry.getMetaData(MetaData.HOMEFOLDER)) != null && !userAccountScope.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                throw new AccessDeniedException("Access denied for '" + string + "'. File is located in foreign home folder.");
            }
            if ((Boolean)awJ.get() == false) return true;
            if (drive.getPermissionChecker().hasPermission(driveEntry.getID(), false, new String[]{EXECUTE.getPermissionTypeName()})) return true;
            throw new AccessDeniedException("Access denied for '" + string + "'. Execute right not set.");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessDeniedException.setUrl(url);
            throw accessDeniedException;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] getReportData(URL url) throws AccessDeniedException, IOException {
        if (url == null || !DriveReportPermissionChecker.isDriveProtocol(url)) {
            return null;
        }
        Object object = url.getPath();
        object = EncodingFunctions.decodeUrlPath((String)object);
        if ("repo".equals(url.getProtocol().toLowerCase()) && ((String)object).startsWith("~/")) {
            object = "/Home/" + ((String)object).substring(2);
        }
        try {
            MountDescription mountDescription;
            UserAccountScope userAccountScope;
            DriveEntry driveEntry;
            Drive drive;
            block28: {
                drive = Drive.getInstance();
                driveEntry = drive.resolve((String)object);
                if (driveEntry == null) {
                    userAccountScope = UserAccountScope.createPrivileged();
                    try {
                        driveEntry = drive.resolve((String)object);
                        if (driveEntry == null || !driveEntry.hasFeature(Content.class)) {
                            byte[] byArray = null;
                            return byArray;
                        }
                        break block28;
                    }
                    finally {
                        if (userAccountScope != null) {
                            userAccountScope.close();
                        }
                    }
                }
                if (!driveEntry.hasFeature(Content.class)) {
                    return null;
                }
            }
            if ((userAccountScope = (GUID)driveEntry.getMetaData(MetaData.HOMEFOLDER)) != null && !userAccountScope.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                return null;
            }
            String string = driveEntry.getID();
            String string2 = DriveIDUtils.getMountRootID((String)string);
            if (!(string2 == null || (mountDescription = MountManager.getInstance().getMountDescription(GUID.valueOf((String)string2))) != null && UserManager.getInstance().getCurrentUserAccountID().equals((Object)mountDescription.getUserID()))) {
                throw new FileNotFoundException(url.toString());
            }
            if (((Boolean)awJ.get()).booleanValue() && !SystemPermissionChecker.checkAccess((Permission)PermissionChecker.PERMISSION_EXECUTE_ALL_REPORTS) && !drive.getPermissionChecker().hasPermission(driveEntry.getID(), false, new String[]{EXECUTE.getPermissionTypeName()})) {
                return null;
            }
            mountDescription = UserAccountScope.createPrivileged();
            try {
                byte[] byArray;
                block29: {
                    InputStream inputStream = ((Content)driveEntry.getFeature(Content.class)).getInputStream();
                    try {
                        byArray = IOFunctions.readBytes((InputStream)inputStream);
                        if (inputStream == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return byArray;
            }
            finally {
                if (mountDescription != null) {
                    mountDescription.close();
                }
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            accessDeniedException.setUrl(url);
            throw accessDeniedException;
        }
    }

    public static boolean isDriveProtocol(@Nonnull URL url) {
        String string = url.getProtocol();
        return "drive".equals(string) || "repo".equals(string);
    }

    public boolean checkReportLocation(URL url) throws AccessDeniedException {
        return DriveReportPermissionChecker.isDriveProtocol(url) && (Boolean)awI.get() != false;
    }
}

