/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.debug;

import com.inet.annotations.InternalApi;
import com.inet.report.Engine;
import com.inet.report.FormulaField;
import com.inet.report.bg;
import com.inet.report.bx;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.d;
import com.inet.report.formula.k;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class ReferenceFinder {
    private d Io;
    private Engine anl;

    public ReferenceFinder(@Nonnull Engine e2) {
        this.anl = e2;
        this.Io = bg.getFormula(e2);
    }

    @Nonnull
    public List<VariableReference> getVariables(@Nonnull FormulaField field) {
        k k2 = this.Io.pi();
        HashSet<VariableReference> hashSet = new HashSet<VariableReference>();
        for (y y2 : k2.qa().values()) {
            if (!y2.rA().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.global, y2));
        }
        for (y y2 : k2.qb().values()) {
            if (!y2.rA().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.shared, y2));
        }
        for (y y2 : k2.qc().values()) {
            if (!y2.rA().contains(field)) continue;
            hashSet.add(new VariableReference(SCOPE.store, y2));
        }
        return new ArrayList<VariableReference>(hashSet);
    }

    public Set<FormulaField> getReferences(String variable, SCOPE scope) {
        k k2 = this.Io.pi();
        HashSet<FormulaField> hashSet = new HashSet<FormulaField>();
        y y2 = null;
        if ((scope == SCOPE.global || scope == null) && (y2 = (y)k2.qa().get(variable)) != null) {
            hashSet.addAll(y2.rA());
        }
        if ((scope == SCOPE.shared || scope == null) && (y2 = (y)k2.qb().get(variable)) != null) {
            for (FormulaField formulaField : y2.rA()) {
                if (bx.getEngineForField(formulaField) != this.anl) continue;
                hashSet.add(formulaField);
            }
        }
        if ((scope == SCOPE.store || scope == null) && (y2 = (y)k2.qc().get(variable)) != null) {
            for (FormulaField formulaField : y2.rA()) {
                if (bx.getEngineForField(formulaField) != this.anl) continue;
                hashSet.add(formulaField);
            }
        }
        return hashSet;
    }

    public static class VariableReference {
        private SCOPE anU;
        private int valueType;
        private String name;

        private VariableReference(@Nonnull SCOPE scope, @Nonnull y var) {
            this.anU = scope;
            this.valueType = var.getValueType(null);
            this.name = var.getName();
        }

        @Nonnull
        public SCOPE getScope() {
            return this.anU;
        }

        public int getValueType() {
            return this.valueType;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + "#" + this.valueType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VariableReference)) {
                return false;
            }
            VariableReference variableReference = (VariableReference)obj;
            return this.anU == variableReference.anU && this.valueType == variableReference.valueType && this.name.equals(variableReference.name);
        }

        public int hashCode() {
            return this.name.hashCode() * (this.anU.ordinal() + 1);
        }
    }

    public static final class SCOPE
    extends Enum<SCOPE> {
        public static final /* enum */ SCOPE local = new SCOPE();
        public static final /* enum */ SCOPE global = new SCOPE();
        public static final /* enum */ SCOPE shared = new SCOPE();
        public static final /* enum */ SCOPE store = new SCOPE();
        private static final /* synthetic */ SCOPE[] anT;

        public static SCOPE[] values() {
            return (SCOPE[])anT.clone();
        }

        public static SCOPE valueOf(String name) {
            return Enum.valueOf(SCOPE.class, name);
        }

        private static /* synthetic */ SCOPE[] rI() {
            return new SCOPE[]{local, global, shared, store};
        }

        static {
            anT = SCOPE.rI();
        }
    }
}

