/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.InternalApi;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.pool.PoolConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLWarning;

@InternalApi
public class DataSourceValidator {
    public static SQLWarning validate(DataSourceConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ReportException {
        try {
            Serializable serializable = null;
            Engine engine = RDC.createEmptyEngine("java");
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.getDatasource(0);
            datasource.setDataSourceConfiguration(configuration);
            try (Connection connection = datasource.getConnection();){
                Serializable serializable2;
                if (connection != null && (serializable2 = connection.getWarnings()) != null) {
                    serializable = serializable2;
                }
                serializable2 = datasource.getDataFactory();
                if (connection == null) {
                    serializable2.getTableSourceInfos(datasource, null);
                }
                if (connection != null) {
                    ((PoolConnection)connection).closeNativeConnection();
                }
            }
            return serializable;
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }
}

