/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource.widget;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.a;
import com.inet.report.config.datasource.b;
import com.inet.report.config.datasource.c;
import com.inet.report.config.datasource.widget.DriverPropertyImpl;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetImpl;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DriverStyleSheetFactory {
    public static final int PROPERTY_TYPE_STRING = 1;
    public static final int PROPERTY_TYPE_INTEGER = 2;
    public static final int PROPERTY_TYPE_BOOLEAN = 3;
    public static final int PROPERTY_TYPE_FILE = 4;
    public static final int PROPERTY_TYPE_SEARCH_CATALOG = 6;
    public static final int PROPERTY_TYPE_PASSWORD = 7;
    public static final int PROPERTY_TYPE_FOLDER = 8;
    public static final int PROPERTY_TYPE_HIDDEN = 9;
    private DriverStyleSheet[] aaM = null;
    private final String aaN;
    private static Map<String, DriverStyleSheetFactory> aaO = new HashMap<String, DriverStyleSheetFactory>();

    private DriverStyleSheetFactory(Locale locale) {
        String string = locale.getLanguage();
        if (string.contains("_")) {
            string = string.substring(0, string.indexOf(95));
        }
        this.aaN = string;
        this.mr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DriverStyleSheetFactory getInstance(Locale locale) {
        Map<String, DriverStyleSheetFactory> map = aaO;
        synchronized (map) {
            DriverStyleSheetFactory driverStyleSheetFactory = aaO.get(locale.getLanguage());
            if (driverStyleSheetFactory == null) {
                driverStyleSheetFactory = new DriverStyleSheetFactory(locale);
                aaO.put(locale.getLanguage(), driverStyleSheetFactory);
            }
            return driverStyleSheetFactory;
        }
    }

    public DriverStyleSheet[] getDriverStyleSheets() {
        if (this.aaM == null) {
            this.mr();
        }
        return this.aaM;
    }

    public DriverStyleSheet getDriverStylesheetByDataSourceConfiguration(DataSourceConfiguration dsc) {
        if (this.aaM == null) {
            this.mr();
        }
        DriverStyleSheet driverStyleSheet = null;
        int n2 = -1;
        for (int i2 = 0; i2 < this.aaM.length; ++i2) {
            int n3;
            DriverStyleSheet driverStyleSheet2 = this.aaM[i2];
            if (!driverStyleSheet2.getDriverClassName().equals(dsc.getDriverClassname()) || !driverStyleSheet2.getUrl().equals(dsc.getUrl()) || (n3 = this.a(driverStyleSheet2, dsc)) <= n2) continue;
            driverStyleSheet = driverStyleSheet2;
        }
        return driverStyleSheet;
    }

    private int a(DriverStyleSheet driverStyleSheet, DataSourceConfiguration dataSourceConfiguration) {
        int n2;
        String string;
        String[] stringArray;
        String string2 = null;
        for (int i2 = 0; i2 < driverStyleSheet.getPropertyCount(); ++i2) {
            stringArray = driverStyleSheet.getDriverProperty(i2);
            if (!stringArray.getName().equals("databaseClassName")) continue;
            string2 = stringArray.getDefaultValue();
            break;
        }
        if (string2 != null && string2.trim().length() != 0 && !string2.equals(string = dataSourceConfiguration.getDatabaseClassname())) {
            return -1;
        }
        int n3 = 0;
        String[] stringArray2 = dataSourceConfiguration.getDriverSpecificProperties();
        stringArray = new String[driverStyleSheet.getPropertyCount()];
        for (n2 = 0; n2 < driverStyleSheet.getPropertyCount(); ++n2) {
            stringArray[n2] = driverStyleSheet.getDriverProperty(n2).getName();
        }
        block2: for (n2 = 0; n2 < stringArray2.length; ++n2) {
            String string3 = stringArray2[n2];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!string3.equals(stringArray[i3])) continue;
                ++n3;
                continue block2;
            }
        }
        return n3 * 100 / stringArray2.length;
    }

    public DriverStyleSheet getDriverStylesheet(String driverStyleSheetName) {
        if (this.aaM == null) {
            this.mr();
        }
        for (int i2 = 0; i2 < this.aaM.length; ++i2) {
            if (!this.aaM[i2].getDisplayName().equals(driverStyleSheetName)) continue;
            return this.aaM[i2];
        }
        return null;
    }

    private void a(a a2, DriverStyleSheet driverStyleSheet) {
        String string = a2.aM("name");
        b b2 = a2.mp();
        String string2 = null;
        Iterator<a> iterator = b2.iterator();
        while (iterator.hasNext()) {
            a a3 = iterator.next();
            if (!a3.getName().equals("displayname")) continue;
            string2 = this.b(a3);
            break;
        }
        for (int i2 = 0; i2 < b2.mq(); ++i2) {
            a a4 = b2.cx(i2);
            if (!a4.getName().equals("param")) continue;
            String string3 = a4.aM("name");
            String string4 = a4.aM("type");
            String string5 = a4.aM("default");
            DriverPropertyImpl driverPropertyImpl = (DriverPropertyImpl)driverStyleSheet.x(string, string3);
            if (driverPropertyImpl == null) {
                driverPropertyImpl = new DriverPropertyImpl(string3, string, string2, string4, string5);
                driverStyleSheet.a(driverPropertyImpl);
            } else {
                driverPropertyImpl.aN(string5);
                if ("Hidden".equals(string4)) {
                    driverPropertyImpl.bL(9);
                }
            }
            b b3 = a4.mp();
            for (int i3 = 0; i3 < b3.mq(); ++i3) {
                a a5 = b3.cx(i3);
                if (a5.getName().equals("displayname")) {
                    driverPropertyImpl.setDisplayName(this.b(a5));
                    continue;
                }
                if (a5.getName().equals("value")) {
                    String string6 = a5.aM("key");
                    b b4 = a5.mp();
                    for (int i4 = 0; i4 < b4.mq(); ++i4) {
                        a a6 = b4.cx(i4);
                        if (!a6.getName().equals("displayname")) continue;
                        driverPropertyImpl.w(string6, this.b(a6));
                    }
                    continue;
                }
                if (!a5.getName().equals("help")) continue;
                driverPropertyImpl.aP(this.b(a5));
            }
        }
    }

    private String b(a a2) {
        String string = null;
        b b2 = a2.mp();
        for (int i2 = 0; i2 < b2.mq(); ++i2) {
            a a3 = b2.cx(i2);
            if (!a3.getName().equals(this.aaN)) continue;
            string = a3.getValue();
        }
        if (string == null) {
            string = a2.getValue();
        }
        return string != null ? string : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="only resource files are read")
    private void mr() {
        ArrayList<DriverStyleSheet> arrayList = new ArrayList<DriverStyleSheet>();
        try {
            Enumeration enumeration = LoaderUtils.getResources((String)"com/inet/report/config/datasource/widget/StyleSheetIndex.txt", (Object)this);
            if (!enumeration.hasMoreElements()) {
                if (BaseUtils.isWarning()) {
                    BaseUtils.warning("Can't find 'StyleSheetIndex.txt'");
                }
                return;
            }
            Exception exception = null;
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        this.a(string, arrayList);
                    }
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    BaseUtils.error(String.valueOf(uRL) + " - " + String.valueOf(exception2));
                }
            }
            if (exception != null) {
                BaseUtils.error(exception);
            }
            arrayList.addAll(ServerPluginManager.getInstance().get(DriverStyleSheet.class));
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
        }
        finally {
            this.aaM = new DriverStyleSheet[arrayList.size()];
            arrayList.toArray(this.aaM);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "URLCONNECTION_SSRF_FD"}, justification="only resource files are read")
    private void a(String string, List<DriverStyleSheet> list) {
        try {
            Object object;
            Object object2;
            Object object3;
            if (!string.endsWith(".xml")) {
                return;
            }
            URL uRL = LoaderUtils.getResource((String)("com/inet/report/config/datasource/stylesheets/" + string), (Object)this);
            if (uRL == null) {
                if (BaseUtils.isWarning()) {
                    BaseUtils.warning("Can't find " + string);
                }
                return;
            }
            c c2 = new c();
            a a2 = c2.a(uRL.openStream());
            if (!a2.toString().startsWith("<Driver ")) {
                return;
            }
            String string2 = a2.aM("name");
            String string3 = a2.aM("class");
            String string4 = a2.aM("url");
            String string5 = a2.aM("company");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                object3 = list.get(i2);
                if (!((DriverStyleSheet)object3).getDisplayName().equals(string2)) continue;
                return;
            }
            DriverStyleSheetImpl driverStyleSheetImpl = new DriverStyleSheetImpl(string2, string3, string5, string4);
            list.add(driverStyleSheetImpl);
            object3 = a2.aM("help");
            if (object3 != null && ((String)object3).length() > 0) {
                String string6;
                object2 = null;
                object = Locale.getDefault().getLanguage();
                object2 = this.aQ(this.a((String)object3, ".", "_" + (String)object + "_" + (string6 = Locale.getDefault().getCountry()) + "."));
                if (object2 == null) {
                    object2 = this.aQ(this.a((String)object3, ".", "_" + (String)object + "."));
                }
                if (object2 == null) {
                    object2 = this.aQ((String)object3);
                }
                if (object2 != null) {
                    driverStyleSheetImpl.aR(IOFunctions.readAsciiString((InputStream)object2));
                }
            }
            if ((object2 = LoaderUtils.getResource((String)"com/inet/report/config/datasource/stylesheets/inetproperties.xml", (Object)this)) == null) {
                if (BaseUtils.isWarning()) {
                    BaseUtils.warning("Can't find inetproperties.xml");
                }
            } else {
                object = c2.a(((URL)object2).openStream());
                if (((a)object).getName().equals("paramgroup")) {
                    this.a((a)object, driverStyleSheetImpl);
                }
            }
            object = a2.mp();
            for (int i3 = 0; i3 < ((b)object).mq(); ++i3) {
                a a3 = ((b)object).cx(i3);
                if (a3.getName().equals("description")) {
                    driverStyleSheetImpl.setDescription(this.b(a3));
                }
                if (!a3.getName().equals("paramgroup")) continue;
                this.a(a3, driverStyleSheetImpl);
            }
        }
        catch (Exception exception) {
            BaseUtils.error("Error Loading Driver Style:" + string);
            BaseUtils.error(exception);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only resources are loaded")
    private final InputStream aQ(String string) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResource(string).openStream();
        }
        catch (Throwable throwable) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return inputStream;
    }

    private final String a(String string, String string2, String string3) {
        int n2 = string.toUpperCase().lastIndexOf(string2.toUpperCase(), string.toUpperCase().length());
        if (n2 != -1) {
            string = string.substring(0, n2).concat(string3).concat(string.substring(n2 + string2.length(), string.length()));
        }
        return string;
    }

    public DriverStyleSheet getDefaultDriverStyleSheet() {
        if (this.aaM == null) {
            this.mr();
        }
        for (int i2 = 0; i2 < this.aaM.length; ++i2) {
            if (!this.aaM[i2].getDisplayName().equals("DefaultDriver")) continue;
            return this.aaM[i2];
        }
        throw new RuntimeException("No default stylesheets loaded. " + this.aaM.length);
    }
}

