/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DateRange
implements Serializable {
    private Date Xi;
    private Date Xj;
    private FormulaField Xk;
    private FormulaField Xl;
    private boolean vw;

    public DateRange() {
        this.vw = true;
    }

    public DateRange(Date lower, Date upper) {
        if (lower == null) {
            throw i.d("lower");
        }
        if (upper == null) {
            throw i.d("upper");
        }
        if (lower.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.vw = false;
        this.Xi = (Date)lower.clone();
        this.Xj = (Date)upper.clone();
    }

    public boolean isAutoRange() {
        return this.vw;
    }

    public void setAutoRange(boolean autoRange) {
        this.vw = autoRange;
    }

    public Date getLowerBound() {
        if (this.Xi != null) {
            return (Date)this.Xi.clone();
        }
        return null;
    }

    public void setLowerBound(Date lower) {
        if (this.Xj != null && this.Xj.before(lower)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.Xi = lower != null ? (Date)lower.clone() : null;
    }

    public FormulaField getLowerBoundFormula() {
        return this.Xk;
    }

    public void setLowerBoundFormula(FormulaField lowerBoundFormula) {
        this.Xk = lowerBoundFormula;
    }

    public Date getUpperBound() {
        if (this.Xj != null) {
            return (Date)this.Xj.clone();
        }
        return null;
    }

    public void setUpperBound(Date upper) {
        if (this.Xi != null && this.Xi.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.Xj = upper != null ? (Date)upper.clone() : null;
    }

    public FormulaField getUpperBoundFormula() {
        return this.Xl;
    }

    public void setUpperBoundFormula(FormulaField upperBoundFormula) {
        this.Xl = upperBoundFormula;
    }

    boolean lT() {
        return !(this.getUpperBound() == null && this.getUpperBoundFormula() == null || this.getLowerBound() == null && this.getLowerBoundFormula() == null);
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange() && this.lT()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeDate");
            buffer.append(' ');
            if (this.Xi != null) {
                f.b(buffer, "lowerBound", Long.toString(this.Xi.getTime()));
            }
            if (this.Xj != null) {
                f.b(buffer, "upperBound", Long.toString(this.Xj.getTime()));
            }
            buffer.append(">\n");
            if (this.Xk != null) {
                j.a(buffer, depth, this.Xk, "chartAxisMinDateFormula");
            }
            if (this.Xl != null) {
                j.a(buffer, depth, this.Xl, "chartAxisMaxDateFormula");
            }
            buffer.append("<");
            buffer.append("/");
            buffer.append("RangeDate");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element, Chart2 chart) {
        NodeList nodeList;
        FormulaField formulaField;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            long l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((formulaField = j.a(nodeList = element.getChildNodes(), chart, "chartAxisMinDateFormula")) != null) {
            this.setLowerBoundFormula(formulaField);
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            long l3 = Long.valueOf(string);
            this.setUpperBound(new Date(l3));
        }
        if ((formulaField = j.a(nodeList, chart, "chartAxisMaxDateFormula")) != null) {
            this.setUpperBoundFormula(formulaField);
        }
    }
}

