/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;

@PublicApi
public class SummaryInfo
implements Serializable {
    private String hs;
    private String Po;
    private String Pp;
    private String Pq;
    private String Pr;
    private String Ps;
    private Date Pt;
    private Date Pu;
    private transient BufferedImage Pv;
    private byte[] Pw;

    SummaryInfo() {
    }

    public String getAuthor() {
        return this.Po;
    }

    public void setAuthor(String author) {
        this.Po = author;
    }

    public String getKeywords() {
        return this.Pp;
    }

    public void setKeywords(String keywords) {
        this.Pp = keywords;
    }

    public String getComments() {
        return this.Ps;
    }

    public void setComments(String comments) {
        this.Ps = comments;
    }

    public String getReportTitle() {
        return this.hs;
    }

    public void setReportTitle(String title) {
        this.hs = title;
    }

    public String getSubject() {
        return this.Pq;
    }

    public void setSubject(String subject) {
        this.Pq = subject;
    }

    public String getTemplate() {
        return this.Pr;
    }

    public void setTemplate(String template) {
        this.Pr = template;
    }

    public Date getCreated() {
        return this.Pu;
    }

    public void setCreated(Date createTime) {
        this.Pu = createTime;
    }

    public Date getLastSaved() {
        return this.Pt;
    }

    public void setLastSaved(Date lastSave) {
        this.Pt = lastSave;
    }

    public void setThumbnail(Image img) {
        this.Pw = null;
        if (img == null) {
            this.Pv = null;
            return;
        }
        int n2 = img.getWidth(null);
        int n3 = img.getHeight(null);
        int n4 = n2;
        int n5 = n3;
        if (n2 > n3) {
            var6_6 = (double)n2 / 256.0;
            n4 = 256;
            n5 = (int)((double)n5 / var6_6);
        } else {
            var6_6 = (double)n3 / 256.0;
            n5 = 256;
            n4 = (int)((double)n4 / var6_6);
        }
        img = img.getScaledInstance(n4, n5, 4);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(img, 0, 0, Color.WHITE, null);
        graphics.dispose();
        this.Pv = bufferedImage;
        this.getThumbnailData();
    }

    public Image getThumbnail() {
        if (this.Pv == null && this.Pw != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.Pw);
                this.Pv = ImageIO.read(byteArrayInputStream);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
                this.Pw = null;
            }
        }
        return this.Pv;
    }

    public void setThumbnailData(byte[] data) {
        this.Pv = null;
        this.Pw = data;
    }

    public byte[] getThumbnailData() {
        if (this.Pw == null && this.Pv != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.Pv, "png", byteArrayOutputStream);
                this.Pw = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.Pw;
    }
}

