/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.config.ConfigurationManager;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.ReportException;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.d;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class StandaloneConfiguration
extends RecoveryLauncher {
    public static void main(String[] args) throws Exception {
        new StandaloneConfiguration().mainLoop(args);
    }

    protected int consumeArgs(String[] args, int idx) throws Exception {
        String string;
        int n2 = idx;
        switch (string = args[n2++].toLowerCase()) {
            case "-importdatasource": 
            case "-forceimportdatasource": {
                String string2 = null;
                String string3 = null;
                if (args.length >= n2 + 2) {
                    string2 = args[n2++];
                    string3 = args[n2++];
                }
                StandaloneConfiguration.a(string2, string3, string.equals("-forceimportdatasource"));
                break;
            }
            default: {
                return super.consumeArgs(args, idx);
            }
        }
        return n2;
    }

    protected void printHelp() {
        System.out.println("--------------------------------------------------------------------------");
        System.out.println("-importDatasource <scope> <file> | Imports data source from XML as export-");
        System.out.println("                                 | -ed by the data source manager. If a   ");
        System.out.println("                                 | data source under the same name already");
        System.out.println("                                 | exists, an additional one will be creat");
        System.out.println("                                 | ed with a unique name.                 ");
        System.out.println("--------------------------------------------------------------------------");
        System.out.println("-forceImportDatasource           | Imports data source from XML as        ");
        System.out.println(" <scope> <file>                  | exported by the data source manager.   ");
        System.out.println("                                 | If a data source under the same name   ");
        System.out.println("                                 | already exists, it will be replaced.   ");
    }

    private static boolean d(File file) {
        if (!file.exists()) {
            System.err.println("A file with the name \"" + file.getName() + "\" does not exist.");
            return false;
        }
        if (!file.isFile()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not a file.");
            return false;
        }
        if (!file.canRead()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not readable.");
            return false;
        }
        return true;
    }

    private static boolean bz(int n2) {
        if (n2 == -1) {
            System.err.println("Only the import to scope 'Application', 'User' or 'System' is possible.");
            return false;
        }
        if (n2 == 7) {
            return true;
        }
        if (!ConfigurationManager.isWriteable((int)n2)) {
            System.err.println("You have no writing rights to scope \"" + ConfigurationManager.getScopeName((int)n2) + "\".");
            return false;
        }
        return true;
    }

    private static int ao(@Nonnull String string) {
        switch (string.toLowerCase()) {
            case "user": {
                return 2;
            }
            case "system": {
                return 1;
            }
            case "application": {
                return 7;
            }
        }
        return -1;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="admin set it")
    private static void a(String string, String string2, boolean bl2) {
        if (string == null || string2 == null) {
            System.err.println("The scope as well as the datasource file you wish to import must be specified.");
            if (bl2) {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -forceImportDatasource <scope> <file>");
            } else {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -importDatasource <scope> <file>");
            }
            return;
        }
        int n2 = StandaloneConfiguration.ao(string);
        if (!StandaloneConfiguration.bz(n2)) {
            return;
        }
        File file = new File(string2);
        if (!StandaloneConfiguration.d(file)) {
            return;
        }
        try {
            ConfigurationManager.setRecoveryMode((boolean)true);
            ServerPluginManager.getInstance().setPluginFilter(serverPluginDescription -> "reporting".equals(serverPluginDescription.getId()));
            if (bl2) {
                DataSourceConfigurationManager.forceImportDataSourceConfigurations(n2, file);
            } else {
                DataSourceConfigurationManager.importDataSourceConfigurations(n2, file);
            }
        }
        catch (ReportException reportException) {
            System.err.println("Error encountered while importing datasource:");
            reportException.printStackTrace(System.err);
        }
    }

    protected void start() throws Exception {
        d.aj();
        super.start();
    }
}

