/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.font.layout.FontContext;
import com.inet.report.AbstractFontElement;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldPart;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.ParagraphProperties;
import com.inet.report.PromptField;
import com.inet.report.ReportComponent;
import com.inet.report.Text;
import com.inet.report.TextPart;
import com.inet.report.am;
import com.inet.report.k;
import com.inet.report.list.a;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.renderer.c;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

@PublicApi
public class Paragraph
extends Element
implements ParagraphProperties {
    AbstractFontElement[] vW;
    Text vX;
    private ArrayList uf;
    private int qI;
    private int qJ;
    private int qK;
    private int qL = Integer.MIN_VALUE;
    private double qM = 1.0;
    private FormulaField qD;
    private FormulaField qB;
    private FormulaField qE;
    private FormulaField qF;
    private FormulaField qC;
    private static final a vY = new a();

    Paragraph(Text parent) {
        super(58, parent.bB);
        this.vX = parent;
    }

    public Text getText() {
        return this.vX;
    }

    @Nonnull
    public TextPart addTextPart(String newText) {
        return this.insertTextPart(this.getPartCount(), newText);
    }

    @Nonnull
    public TextPart insertTextPart(int pos, String newtext) {
        TextPart textPart = new TextPart(this, this.bB);
        if (newtext == null) {
            newtext = "";
        }
        textPart.mp = newtext;
        this.a(pos, textPart);
        return textPart;
    }

    @Nonnull
    public FieldPart addFieldPart(Field newField) {
        return this.insertFieldPart(this.getPartCount(), newField);
    }

    @Nonnull
    public FieldPart insertFieldPart(int pos, Field newfield) {
        FieldPart fieldPart = new FieldPart(this, this.bB);
        fieldPart.setField(newfield);
        this.mm = true;
        this.vX.mm = true;
        this.a(pos, fieldPart);
        Fields.a(this.bB, newfield, 2);
        return fieldPart;
    }

    private final void a(int n2, AbstractFontElement abstractFontElement) {
        AbstractFontElement[] abstractFontElementArray = this.vW;
        if (abstractFontElementArray == null || abstractFontElementArray.length < 1) {
            this.vW = new AbstractFontElement[]{abstractFontElement};
        } else {
            AbstractFontElement[] abstractFontElementArray2 = new AbstractFontElement[abstractFontElementArray.length + 1];
            System.arraycopy(abstractFontElementArray, 0, abstractFontElementArray2, 0, n2);
            System.arraycopy(abstractFontElementArray, n2, abstractFontElementArray2, n2 + 1, abstractFontElementArray.length - n2);
            abstractFontElementArray2[n2] = abstractFontElement;
            this.vW = abstractFontElementArray2;
        }
    }

    public Element getPart(int idx) {
        return this.vW[idx];
    }

    public int getPartCount() {
        if (this.vW == null) {
            return 0;
        }
        return this.vW.length;
    }

    public void removePart(int idx) {
        AbstractFontElement[] abstractFontElementArray;
        if (this.vW == null || idx < 0 || idx >= this.vW.length) {
            throw new IndexOutOfBoundsException(String.valueOf(idx));
        }
        AbstractFontElement abstractFontElement = this.vW[idx];
        if (abstractFontElement instanceof FieldPart) {
            abstractFontElementArray = (AbstractFontElement[])abstractFontElement;
            abstractFontElementArray.resetReferences();
        }
        abstractFontElementArray = new AbstractFontElement[this.vW.length - 1];
        System.arraycopy(this.vW, 0, abstractFontElementArray, 0, idx);
        System.arraycopy(this.vW, idx + 1, abstractFontElementArray, idx, abstractFontElementArray.length - idx);
        this.vW = abstractFontElementArray;
        if (abstractFontElement instanceof FieldPart) {
            Fields.a(this.bB, ((FieldPart)abstractFontElement).getField(), 2);
        }
    }

    public void moveParts(int srcPos, Paragraph dest, int destPos, int length) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (length == 0 || srcPos == this.vW.length) {
            return;
        }
        if (this.bB != dest.bB) {
            throw new IllegalArgumentException("Paragraphs come from different Engines.");
        }
        if (srcPos < 0 || srcPos > this.vW.length) {
            throw new IndexOutOfBoundsException(String.valueOf(srcPos));
        }
        if (srcPos + length > this.vW.length || length < 0) {
            throw new IndexOutOfBoundsException("length: " + length);
        }
        if (dest == this) {
            if (destPos < srcPos || srcPos + length < destPos) {
                AbstractFontElement[] abstractFontElementArray = new AbstractFontElement[length];
                System.arraycopy(this.vW, srcPos, abstractFontElementArray, 0, length);
                if (destPos > srcPos) {
                    System.arraycopy(this.vW, srcPos + length, this.vW, srcPos, destPos - srcPos);
                    System.arraycopy(abstractFontElementArray, 0, this.vW, destPos - length, length);
                } else {
                    System.arraycopy(this.vW, destPos, this.vW, destPos + length, srcPos - destPos);
                    System.arraycopy(abstractFontElementArray, 0, this.vW, destPos, length);
                }
            }
            return;
        }
        int n2 = dest.vW != null ? dest.vW.length : 0;
        AbstractFontElement[] abstractFontElementArray = new AbstractFontElement[this.vW.length - length];
        AbstractFontElement[] abstractFontElementArray2 = new AbstractFontElement[n2 + length];
        System.arraycopy(this.vW, 0, abstractFontElementArray, 0, srcPos);
        System.arraycopy(this.vW, srcPos + length, abstractFontElementArray, srcPos, abstractFontElementArray.length - srcPos);
        System.arraycopy(this.vW, srcPos, abstractFontElementArray2, destPos, length);
        if (n2 > 0) {
            System.arraycopy(dest.vW, 0, abstractFontElementArray2, 0, destPos);
            System.arraycopy(dest.vW, destPos, abstractFontElementArray2, destPos + length, n2 - destPos);
        }
        boolean bl2 = dest.indexOf() >= 0;
        boolean bl3 = this.indexOf() >= 0;
        this.vW = abstractFontElementArray;
        dest.vW = abstractFontElementArray2;
        for (AbstractFontElement abstractFontElement : abstractFontElementArray2) {
            AbstractFontElement abstractFontElement2;
            if (abstractFontElement instanceof TextPart) {
                abstractFontElement2 = (TextPart)abstractFontElement;
                ((TextPart)abstractFontElement2).qR = dest;
                ((TextPart)abstractFontElement2).jC = dest.jC;
                continue;
            }
            abstractFontElement2 = (FieldPart)abstractFontElement;
            ((FieldPart)abstractFontElement2).qR = dest;
            ((FieldPart)abstractFontElement2).jC = dest.jC;
            if (!bl3 && bl2) {
                abstractFontElement2.setReferences();
            }
            if (!bl3 || bl2) continue;
            ((FieldPart)abstractFontElement2).resetReferences();
        }
    }

    @Override
    public String paramString() {
        return super.paramString() + "\n@ index " + String.valueOf(this.indexOf()) + " of " + this.vX.paramString();
    }

    @Override
    public int indexOf() {
        if (this.vX == null) {
            return -1;
        }
        if (this.vX.PF == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.vX.PF.length; ++i2) {
            if (this.vX.PF[i2] != this) continue;
            return i2;
        }
        return -1;
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", this.getTypeAsString()) + k.l("count", this.vW == null ? k.z(0) : k.z(this.vW.length)) + ">\n");
        this.b(printWriter, ++n2, Element.lY);
        this.q(printWriter, n2);
        if (this.mp != null) {
            printWriter.print(string + k.h(this.mp) + "\n");
        }
        if (this.vW != null) {
            for (int i2 = 0; i2 < this.vW.length; ++i2) {
                if (this.vW[i2] instanceof TextPart) {
                    ((TextPart)this.vW[i2]).k(printWriter, n2);
                    continue;
                }
                if (!(this.vW[i2] instanceof FieldPart)) continue;
                ((FieldPart)this.vW[i2]).k(printWriter, n2);
            }
        }
        printWriter.print(string + "</Element>\n");
    }

    @Override
    void e(StringBuilder stringBuilder, int n2) {
        am.a((ParagraphProperties)this, stringBuilder, n2);
    }

    @Override
    public void setReferences() {
        super.setReferences();
        if (this.vW != null && this.vW.length > 0) {
            for (int i2 = 0; i2 < this.vW.length; ++i2) {
                this.vW[i2].setReferences();
            }
        }
    }

    @Override
    public void resetReferences() {
        super.resetReferences();
        if (this.vW != null && this.vW.length > 0) {
            for (int i2 = 0; i2 < this.vW.length; ++i2) {
                this.vW[i2].resetReferences();
            }
        }
    }

    void d(ArrayList arrayList) {
        this.uf = arrayList;
    }

    final ArrayList eP() {
        return this.uf;
    }

    @Override
    public int getFirstLineIndent() {
        return this.qJ;
    }

    @Override
    public void setFirstLineIndent(int newValue) {
        am.az(newValue);
        this.qJ = newValue;
    }

    @Override
    public int getLeftIndent() {
        return this.qI;
    }

    @Override
    public void setLeftIndent(int newLeftIndent) {
        am.aA(newLeftIndent);
        this.qI = newLeftIndent;
    }

    @Override
    public int getRightIndent() {
        return this.qK;
    }

    @Override
    public void setRightIndent(int newRightIndent) {
        am.aB(newRightIndent);
        this.qK = newRightIndent;
    }

    @Override
    public void setLineSpacingAbsolute(int lineSpacingAbsolute) {
        am.aC(lineSpacingAbsolute);
        this.qL = lineSpacingAbsolute;
        this.qM = lineSpacingAbsolute == Integer.MIN_VALUE ? 1.0 : -1.7976931348623157E308;
    }

    @Override
    public int getLineSpacingAbsolute() {
        return this.qL;
    }

    @Override
    public void setLineSpacingRelative(double lineSpacingRelative) {
        am.j(lineSpacingRelative);
        this.qM = Math.abs(lineSpacingRelative - -1.7976931348623157E308) < 0.001 ? 1.0 : lineSpacingRelative;
        this.qL = Integer.MIN_VALUE;
    }

    @Override
    public double getLineSpacingRelative() {
        return this.qM;
    }

    public void normalize(boolean replacePrompts) {
        if (replacePrompts) {
            this.eQ();
        }
        int n2 = 0;
        while (n2 < this.getPartCount()) {
            if (this.getPart(n2).getType() == 59) {
                TextPart textPart;
                TextPart textPart2;
                String string = ((TextPart)this.getPart(n2)).getText();
                if (this.getPartCount() > 1 && (string == null || string.equals(""))) {
                    this.removePart(n2);
                    continue;
                }
                if (n2 < this.getPartCount() - 1 && this.getPart(n2 + 1).getType() == 59 && c.a(textPart2 = (TextPart)this.getPart(n2), textPart = (TextPart)this.getPart(n2 + 1)) && textPart.getText() != null) {
                    textPart2.setText(textPart2.getText() + textPart.getText());
                    this.removePart(n2 + 1);
                    continue;
                }
            }
            ++n2;
        }
    }

    private void eQ() {
        for (int i2 = 0; i2 < this.getPartCount(); ++i2) {
            FieldPart fieldPart;
            Field field;
            if (this.getPart(i2).getType() != 60 || !((field = (fieldPart = (FieldPart)this.getPart(i2)).getField()) instanceof PromptField)) continue;
            String string = fieldPart.a(this.bB, ((PromptField)field).getValue());
            this.removePart(i2);
            TextPart textPart = this.insertTextPart(i2, string);
            FontContext fontContext = fieldPart.getFontContext();
            if (fontContext != null) {
                textPart.a(fontContext);
                continue;
            }
            textPart.setBold(fieldPart.isBold());
            textPart.setFontColor(fieldPart.getFontColor());
            textPart.setFontColorFormula(fieldPart.getFontColorFormula());
            textPart.setFontName(fieldPart.getFontName());
            textPart.setFontNameFormula(fieldPart.getFontNameFormula());
            textPart.setFontSizeFormula(fieldPart.getFontSizeFormula());
            textPart.setFontSizeTwips(fieldPart.getFontSizeTwips());
            textPart.setFontStyle(fieldPart.getFontStyle());
            textPart.setFontStyleFormula(fieldPart.getFontStyleFormula());
            textPart.setItalic(fieldPart.isItalic());
            textPart.setStrikeout(fieldPart.isStrikeout());
            textPart.setStrikeoutFormula(fieldPart.getStrikeoutFormula());
            textPart.setUnderline(fieldPart.isUnderline());
            textPart.setUnderlineFormula(fieldPart.getUnderlineFormula());
        }
    }

    @Override
    void r(int n2, String string) {
        switch (n2) {
            case 1062: {
                this.setFirstLineIndent(Integer.parseInt(string));
                break;
            }
            case 1063: {
                this.setLeftIndent(Integer.parseInt(string));
                break;
            }
            case 1064: {
                this.setRightIndent(Integer.parseInt(string));
                break;
            }
            case 121212: {
                this.setLineSpacingRelative(Double.parseDouble(string));
                break;
            }
            case 121213: {
                this.setLineSpacingAbsolute(Integer.parseInt(string));
            }
        }
        super.r(n2, string);
    }

    @Override
    void a(FormulaField formulaField) {
        switch (formulaField.rM) {
            case 1062: {
                this.setFirstLineIndentFormula(formulaField);
                break;
            }
            case 1063: {
                this.setLeftIndentFormula(formulaField);
                break;
            }
            case 1064: {
                this.setRightIndentFormula(formulaField);
                break;
            }
            case 121213: {
                this.setLineSpacingAbsoluteFormula(formulaField);
                break;
            }
            case 121212: {
                this.setLineSpacingRelativeFormula(formulaField);
                break;
            }
            default: {
                super.a(formulaField);
            }
        }
    }

    @Override
    public FormulaField getFirstLineIndentFormula() {
        return this.qD;
    }

    @Override
    public FormulaField getLeftIndentFormula() {
        return this.qB;
    }

    @Override
    public FormulaField getLineSpacingAbsoluteFormula() {
        return this.qE;
    }

    @Override
    public FormulaField getLineSpacingRelativeFormula() {
        return this.qF;
    }

    @Override
    public FormulaField getRightIndentFormula() {
        return this.qC;
    }

    @Override
    public void setFirstLineIndentFormula(FormulaField formula) {
        this.qD = formula;
    }

    @Override
    public void setLeftIndentFormula(FormulaField formula) {
        this.qB = formula;
    }

    @Override
    public void setLineSpacingAbsoluteFormula(FormulaField formula) {
        this.qE = formula;
    }

    @Override
    public void setLineSpacingRelativeFormula(FormulaField formula) {
        this.qF = formula;
    }

    @Override
    public void setRightIndentFormula(FormulaField formula) {
        this.qC = formula;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        String string;
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    return super.parseElement(group, tag, atts, parserMap);
                }
                case StringProperties: {
                    am.a((ParagraphProperties)this, tag, atts.getValue("value"));
                    return null;
                }
            }
        }
        if (tag.equals("Element") && (string = atts.getValue("type")) != null) {
            if (string.equals("TextPart")) {
                TextPart textPart = new TextPart(this, this.bB);
                textPart.setText("");
                this.a(this.getPartCount(), textPart);
                return textPart;
            }
            if (string.equals("FieldPart")) {
                FieldPart fieldPart = new FieldPart(this, this.bB);
                fieldPart.S();
                this.a(this.getPartCount(), fieldPart);
                return fieldPart;
            }
        }
        return null;
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return Arrays.asList(this.vW);
    }

    static {
        vY.put(1003, 0);
    }
}

