/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.AbstractValueElement;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.HyperlinkProperties;
import com.inet.report.ParagraphProperties;
import com.inet.report.PropertyConstants;
import com.inet.report.ReferenceHolder;
import com.inet.report.RendererBase;
import com.inet.report.ReportComponent;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.TextInterpretationProperties;
import com.inet.report.TextProperties;
import com.inet.report.am;
import com.inet.report.bt;
import com.inet.report.bu;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.layout.d;
import com.inet.report.o;
import com.inet.report.p;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.y;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class FieldElement
extends AbstractValueElement
implements BorderProperties,
HyperlinkProperties,
ParagraphProperties,
ReferenceHolder,
TextInterpretationProperties,
TextProperties {
    private int qx = 0;
    private int qy;
    private FormulaField qz = null;
    private FormulaField qA = null;
    private FormulaField qB = null;
    private FormulaField qC = null;
    private FormulaField qD = null;
    private FormulaField qE = null;
    private FormulaField qF = null;
    private FormulaField qG = null;
    private String qH = null;
    private int qI;
    private int qJ;
    private int qK;
    private int qL = Integer.MIN_VALUE;
    private double qM = 1.0;
    private transient d qN = null;
    private transient boolean qO;
    private transient FormulaField qP;

    FieldElement(RendererBase<?> renderer, Section parentSection) {
        super(36, renderer, parentSection);
    }

    @Override
    public synchronized Object copy() throws ReportException {
        try {
            this.qO = true;
            Object object = super.copy();
            return object;
        }
        finally {
            this.qO = false;
        }
    }

    @Override
    public int getFirstLineIndent() {
        return this.qJ;
    }

    @Override
    public void setFirstLineIndent(int newValue) {
        this.qJ = newValue;
    }

    @Override
    public int getLeftIndent() {
        return this.qI;
    }

    @Override
    public void setLeftIndent(int newLeftIndent) {
        if (newLeftIndent < 0) {
            throw y.a("leftIndent", newLeftIndent, null);
        }
        this.qI = newLeftIndent;
    }

    @Override
    public int getRightIndent() {
        return this.qK;
    }

    @Override
    public void setRightIndent(int newRightIndent) {
        if (newRightIndent < 0) {
            throw y.a("rightIndent", newRightIndent, null);
        }
        this.qK = newRightIndent;
    }

    @Override
    public void setLineSpacingAbsolute(int lineSpacingAbsolute) {
        if (lineSpacingAbsolute < 0 && lineSpacingAbsolute != Integer.MIN_VALUE) {
            throw y.a("lineSpacingAbsolute", lineSpacingAbsolute, null);
        }
        this.qL = lineSpacingAbsolute;
        this.qM = lineSpacingAbsolute == Integer.MIN_VALUE ? 1.0 : -1.7976931348623157E308;
    }

    @Override
    public int getLineSpacingAbsolute() {
        return this.qL;
    }

    @Override
    public void setLineSpacingRelative(double lineSpacingRelative) {
        if (lineSpacingRelative < 0.0 && Math.abs(lineSpacingRelative - -1.7976931348623157E308) > 0.001) {
            throw y.a((Object)Double.toString(lineSpacingRelative), "lineSpacingRelative", null);
        }
        this.qM = Math.abs(lineSpacingRelative - -1.7976931348623157E308) < 0.001 ? 1.0 : lineSpacingRelative;
        this.qL = Integer.MIN_VALUE;
    }

    @Override
    public double getLineSpacingRelative() {
        return this.qM;
    }

    @Override
    public int getTextInterpretation() {
        return this.mj;
    }

    @Override
    public void setTextInterpretation(int interpretation) {
        this.mj = interpretation;
    }

    @Override
    public FormulaField getTextInterpretationFormula() {
        return PropertyConstants.setPropertyDefault(this.mi, this.getTextInterpretation());
    }

    @Override
    public void setTextInterpretationFormula(FormulaField newFormula) {
        FormulaField.d(this.mi);
        this.mi = this.a(newFormula, 1061, "text interpretation");
    }

    @Override
    public String getBaseUrl() {
        return this.qH;
    }

    @Override
    public FormulaField getBaseUrlFormula() {
        return PropertyConstants.setPropertyDefault(this.qG, this.getBaseUrl());
    }

    @Override
    public void setBaseUrl(String base) {
        this.qH = base;
    }

    @Override
    public void setBaseUrlFormula(FormulaField newFormula) {
        FormulaField.d(this.qG);
        this.qG = this.a(newFormula, 121214, "base url");
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.paramString());
        stringBuilder.append("\n\t");
        if (this.lI != null) {
            stringBuilder.append(Msg.getMsg("withField", this.lI.paramString()));
        } else {
            stringBuilder.append(Msg.getMsg("withField", String.valueOf(this.lI)));
        }
        return stringBuilder.toString();
    }

    d cX() {
        return this.qN;
    }

    void a(d d2) {
        this.qN = d2;
    }

    @Override
    public List<FormulaField> getPropertyFormulas() {
        List<FormulaField> list = super.getPropertyFormulas();
        list.add(this.getBaseUrlFormula());
        list.add(this.getFirstLineIndentFormula());
        list.add(this.getGlyphOrientationFormula());
        list.add(this.getLeftIndentFormula());
        list.add(this.getLineSpacingAbsoluteFormula());
        list.add(this.getLineSpacingRelativeFormula());
        list.add(this.getRightIndentFormula());
        list.add(this.getTextInterpretationFormula());
        list.add(this.getTextRotationFormula());
        return list;
    }

    @Override
    public void resetReferences() {
        super.resetReferences();
        if (this.getField() != null) {
            this.bB.getFields().a(this.getField(), 2);
        } else {
            BaseUtils.warning("Warning! " + String.valueOf(this) + " at " + this.getX() + ", " + this.getY() + " has a null field!");
        }
    }

    @Override
    void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        if (this.lI instanceof SQLField && oldAlias.length() == 0) {
            String string = newAlias + "." + this.lI.getName();
            DatabaseField databaseField = this.bB.getEngine().getFields().getDatabaseField(string);
            if (databaseField == null) {
                Object[] objectArray = new Object[]{this.lI.getName(), newAlias};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.FieldReferenced, objectArray);
            }
            this.setField(databaseField);
        }
        super.changeAllAliases(oldAlias, newAlias, dc);
    }

    @Override
    public int getGlyphOrientation() {
        return this.qx;
    }

    @Override
    public void setGlyphOrientation(int orientation) {
        bu.bF(orientation);
        this.qx = orientation;
    }

    @Override
    public void setGlyphOrientationFormula(FormulaField formula) {
        FormulaField.d(this.qz);
        this.qz = this.a(formula, 1110, "glyph orientation");
    }

    @Override
    public FormulaField getGlyphOrientationFormula() {
        return PropertyConstants.setPropertyDefault(this.qz, this.getGlyphOrientation());
    }

    @Override
    public void setTextRotation(int rotation) {
        bu.bG(rotation);
        this.qy = rotation;
    }

    @Override
    public int getTextRotation() {
        return this.qy;
    }

    @Override
    public FormulaField getTextRotationFormula() {
        return PropertyConstants.setPropertyDefault(this.qA, this.getTextRotation());
    }

    @Override
    public void setTextRotationFormula(FormulaField formula) {
        FormulaField.d(this.qA);
        this.qA = this.a(formula, 1009, "text rotation");
    }

    @Override
    public void setCanGrow(boolean canGrow) {
        super.setCanGrow(canGrow);
        int n2 = this.getField().valueType;
        if (n2 == 6 || n2 == 7) {
            this.setCanGrowCount(1);
        }
    }

    @Override
    public void setCanGrowCount(int limit) {
        int n2 = this.getField().valueType;
        if (!(n2 != 6 && n2 != 7 || limit <= 1 && limit >= 0)) {
            throw new IllegalArgumentException("Number or Currency Fields can only have a 'can grow' limit of 0 or 1");
        }
        super.setCanGrowCount(limit);
    }

    @Override
    void r(int n2, String string) {
        switch (n2) {
            case 1062: {
                this.setFirstLineIndent(Integer.parseInt(string));
                break;
            }
            case 1063: {
                this.setLeftIndent(Integer.parseInt(string));
                break;
            }
            case 1064: {
                this.setRightIndent(Integer.parseInt(string));
                break;
            }
            case 121212: {
                this.setLineSpacingRelative(Double.parseDouble(string));
                break;
            }
            case 121213: {
                this.setLineSpacingAbsolute(Integer.parseInt(string));
                break;
            }
            case 1061: {
                this.setTextInterpretation(Integer.parseInt(string));
                break;
            }
            case 121214: {
                this.setBaseUrl(string);
            }
        }
        super.r(n2, string);
    }

    @Override
    void q(String string, String string2) {
        Element.e e2 = Element.e.nG;
        try {
            e2 = Element.e.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (e2) {
            case nH: {
                this.setTextInterpretation(Integer.parseInt(string2));
                break;
            }
            case nI: {
                this.setBaseUrl(string2);
            }
        }
    }

    @Override
    void e(StringBuilder stringBuilder, int n2) {
        am.a((ParagraphProperties)this, stringBuilder, n2);
        bt.a(this, stringBuilder, n2);
    }

    @Override
    void a(FormulaField formulaField) {
        switch (formulaField.rM) {
            case 1110: {
                this.setGlyphOrientationFormula(formulaField);
                break;
            }
            case 1009: {
                this.setTextRotationFormula(formulaField);
                break;
            }
            case 1062: {
                this.setFirstLineIndentFormula(formulaField);
                break;
            }
            case 1063: {
                this.setLeftIndentFormula(formulaField);
                break;
            }
            case 1064: {
                this.setRightIndentFormula(formulaField);
                break;
            }
            case 121213: {
                this.setLineSpacingAbsoluteFormula(formulaField);
                break;
            }
            case 121212: {
                this.setLineSpacingRelativeFormula(formulaField);
                break;
            }
            case 1061: {
                this.setTextInterpretationFormula(formulaField);
                break;
            }
            case 121214: {
                this.setBaseUrlFormula(formulaField);
                break;
            }
            default: {
                super.a(formulaField);
            }
        }
    }

    @Override
    public FormulaField getFirstLineIndentFormula() {
        return PropertyConstants.setPropertyDefault(this.qD, this.getFirstLineIndent());
    }

    @Override
    public FormulaField getLeftIndentFormula() {
        return PropertyConstants.setPropertyDefault(this.qB, this.getLeftIndent());
    }

    @Override
    public FormulaField getLineSpacingAbsoluteFormula() {
        return PropertyConstants.setPropertyDefault(this.qE, this.getLineSpacingAbsolute());
    }

    @Override
    public FormulaField getLineSpacingRelativeFormula() {
        return PropertyConstants.setPropertyDefault(this.qF, this.getLineSpacingRelative());
    }

    @Override
    public FormulaField getRightIndentFormula() {
        return PropertyConstants.setPropertyDefault(this.qC, this.getRightIndent());
    }

    @Override
    public void setFirstLineIndentFormula(FormulaField formula) {
        FormulaField.d(this.qD);
        this.qD = this.a(formula, 1062, "indent first line");
    }

    @Override
    public void setLeftIndentFormula(FormulaField formula) {
        FormulaField.d(this.qB);
        this.qB = this.a(formula, 1063, "left indent");
    }

    @Override
    public void setLineSpacingAbsoluteFormula(FormulaField formula) {
        FormulaField.d(this.qE);
        this.qE = this.a(formula, 121213, "line spacing absolute");
    }

    @Override
    public void setLineSpacingRelativeFormula(FormulaField formula) {
        FormulaField.d(this.qF);
        this.qF = this.a(formula, 121212, "line spacing relative");
    }

    @Override
    public void setRightIndentFormula(FormulaField formula) {
        FormulaField.d(this.qC);
        this.qC = this.a(formula, 1064, "right indent");
        this.qC = formula;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: 
                case FontProperties: 
                case NumberProperties: 
                case DateProperties: 
                case TimeProperties: 
                case DateTimeProperties: 
                case BooleanProperties: {
                    NodeParser nodeParser = super.parseElement(group, tag, atts, parserMap);
                    return nodeParser;
                }
                case TextProperties: {
                    if (tag.equals(XMLTag.PropertyFormula.name())) {
                        return super.parseElement(group, tag, atts, parserMap);
                    }
                    bu.a((TextProperties)this, tag, atts);
                    return null;
                }
                case StringProperties: {
                    if (tag.equals(XMLTag.PropertyFormula.name())) {
                        return super.parseElement(group, tag, atts, parserMap);
                    }
                    String string = atts.getValue("value");
                    if (string == null) {
                        return null;
                    }
                    am.a((ParagraphProperties)this, tag, string);
                    return null;
                }
            }
        }
        XMLTag xMLTag = XMLTag.getValueOf(tag);
        switch (xMLTag) {
            case Field: {
                String string = atts.getValue("type");
                if (string == null) break;
                String string2 = atts.getValue("valueType");
                int n2 = -1;
                if (string2 != null) {
                    n2 = Integer.valueOf(string2);
                }
                switch (string) {
                    case "GroupNameField": {
                        if (!this.lL) break;
                        this.lI.lL = true;
                        this.lI.setValueType(n2);
                        if (this.lM instanceof o) {
                            this.lI.qo = 1;
                        } else if (this.lM instanceof p) {
                            this.lI.qo = 2;
                        }
                        return this.lI.getGroup();
                    }
                    case "FormulaField": {
                        this.qP = new FormulaField(this.bB);
                        return this.qP;
                    }
                }
                break;
            }
            case Reference: {
                if (this.lL) break;
                Field field = Fields.b(atts, this.bB);
                if (this.qP != null) {
                    if (field instanceof Fields.a) {
                        this.bB.Ir = (FormulaField[])Fields.a((Field[])this.bB.Ir, this.qP);
                        this.bB.getFields().a(this.qP, 0);
                        field = this.qP;
                    }
                    this.qP = null;
                }
                if (this.lI != null) {
                    this.lI.removeReferenceHolder(this);
                }
                this.lI = field;
                if (this.lI == null) break;
                this.lI.addReferenceHolder(this);
                break;
            }
            case PropertyFormula: {
                try {
                    FormulaField formulaField = new FormulaField(this.bB);
                    formulaField.setFormulaType(3);
                    formulaField.G("0");
                    this.a(formulaField, 3, "");
                    formulaField.G("");
                    return formulaField;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        if (this.lI == null) {
            this.lI = new Fields.a();
        }
        super.parseEndElement(group, tag, parserMap);
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        ++n2;
        printWriter.print(string + "<Element" + k.l("type", this.getTypeAsString()) + this.ca() + ">\n");
        if (this.lI != null && this.lL) {
            this.lI.lL = true;
        }
        if (this.qO && this.lI instanceof FormulaField) {
            this.lI.k(printWriter, n2);
        }
        this.b(printWriter, n2, lY);
        this.a(printWriter, n2, lY);
        this.a(printWriter, n2);
        this.d(printWriter, n2);
        this.r(printWriter, n2);
        bu.a((TextProperties)this, printWriter, n2);
        if (this.lI != null && !this.lI.lL) {
            StringBuilder stringBuilder = new StringBuilder();
            k.a(stringBuilder, n2, this.lI, "field");
            printWriter.print(stringBuilder);
        }
        if (this.lI != null && this.lI.lL) {
            this.lI.k(printWriter, n2);
        }
        printWriter.print(string + "</Element>\n");
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return null;
    }
}

