/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.Database;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nonnull;

public class DatabasePostgreSql
extends Database {
    public DatabasePostgreSql() {
        this.getConfiguration().setAliasToken("AS", false);
    }

    @Override
    public boolean isCursor(int sqlType) {
        return sqlType == 2012;
    }

    @Override
    @Nonnull
    protected String patchSQL(@Nonnull String sql) {
        if (sql.startsWith("{") && sql.endsWith("}")) {
            return sql.substring(1, sql.length() - 1);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ColumnInfo> getColumns(TableSource ts) throws ReportException {
        try (Connection connection = ts.getDatasource().getConnection();){
            List<ColumnInfo> list;
            try {
                int n2 = ts.getType();
                switch (n2) {
                    case 2: {
                        connection.setAutoCommit(false);
                    }
                }
                list = super.getColumns(ts);
            }
            catch (Throwable throwable) {
                connection.setAutoCommit(true);
                throw throwable;
            }
            connection.setAutoCommit(true);
            return list;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    @Override
    @Nonnull
    public TableData getTableSourceData(TableSource ts) throws ReportException {
        int n2 = ts.getType();
        switch (n2) {
            default: {
                return super.getTableSourceData(ts);
            }
            case 2: 
        }
        final Connection connection = ts.getDatasource().getConnection();
        try {
            connection.setAutoCommit(false);
            return new TableData(ts.getResultSet()){

                @Override
                public void close() {
                    super.close();
                    try {
                        connection.setAutoCommit(true);
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    @Override
    public int getMaxAliasNameLength() {
        return 200;
    }

    @Override
    public String getAddOp() {
        return "||";
    }

    @Override
    public String sqlConcat(Object leftOperant, Object rightOperant) {
        if (leftOperant instanceof String || rightOperant instanceof String) {
            return String.valueOf(leftOperant) + "||" + String.valueOf(rightOperant);
        }
        return super.sqlConcat(leftOperant, rightOperant);
    }

    @Override
    public String convertToDate(String year, String month, String day) {
        return "date '" + year + "||'/'||" + month + "||'/'||" + day + "' ";
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) {
        return "time '" + hour + "||':'||" + minute + "||':'||" + sec + "' ";
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) {
        return "to_timestamp(" + year + "||'/'||" + month + "||'/'||" + day + "|| ' ' || " + hour + "||'/'||" + minute + "||'/'||" + sec + ",'YYYY/mm/dd HH24/MI/SS')";
    }

    @Override
    public String convertToString(String parameter) throws ReportException {
        return "convert(" + parameter + " using iso_8859_1_to_utf_8)";
    }

    @Override
    public String convertToInt(String parameter) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToDouble(String parameter) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToBoolean(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    public String convertToBoolean(String fieldReference, boolean invert) {
        return invert ? "NOT (" + fieldReference + ")" : fieldReference;
    }
}

