/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.rules;

import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.i18n.Msg;
import com.inet.problemfinder.rules.AbstractRuleElement;
import com.inet.report.AbstractLineElement;
import com.inet.report.BaseUtils;
import com.inet.report.CrossTab;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Picture;
import com.inet.report.ReportException;
import com.inet.report.ReportProperties;
import com.inet.report.Section;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RuleElementOutOfSection
extends AbstractRuleElement {
    @Override
    protected ProblemFinderWarning check(Engine engine, Element element) {
        block5: {
            int n2 = 0;
            Section section = (Section)element.getParent();
            try {
                ReportProperties reportProperties = engine.getReportProperties();
                n2 = engine.isSubEngine() && !engine.getSubReportElement().isOnDemand() ? engine.getSubReportElement().getWidth() : reportProperties.getPaperWidth() - reportProperties.getMarginLeft() - reportProperties.getMarginRight();
                if (reportProperties.isFormatWithMultipleColumns() && section.getType() == 2) {
                    n2 = reportProperties.getLabelWidth();
                }
                if (element.getX() + element.getWidth() > n2 && !(element instanceof CrossTab) && !element.isInCrossTab()) {
                    a a2 = new a(element, n2);
                    ProblemFinderWarning.Type type = ProblemFinderWarning.Type.WARNING;
                    if (section.isSuppress()) {
                        type = ProblemFinderWarning.Type.INFO;
                    }
                    String string = Msg.getElementDisplayName(element);
                    String string2 = Msg.getMsg("ProblemFinder.Rule.ElementOutOfSection.warn", string);
                    return new ProblemFinderWarningImpl(element, type, this, string2, string, a2);
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block5;
                BaseUtils.debug(reportException);
            }
        }
        return null;
    }

    @Override
    public String getRuleLabel() {
        return Msg.getMsg("ProblemFinder.Rule.ElementOutOfSection.label");
    }

    class a
    extends AbstractAction {
        private Element bh;
        private int bi;

        public a(Element element, int n2) {
            super(Msg.getMsg("ProblemFinder.Rule.ElementOutOfSection.AutofixDetail"));
            this.bh = element;
            this.bi = n2;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (this.bi - this.bh.getWidth() < 0) {
                if (this.bh instanceof Picture) {
                    Picture picture = (Picture)this.bh;
                    double d2 = (double)this.bi / (double)this.bh.getWidth();
                    picture.setHeight((int)Math.floor((double)picture.getHeight() * d2));
                }
                if (this.bh instanceof AbstractLineElement) {
                    int n2 = ((AbstractLineElement)this.bh).getX2();
                    ((AbstractLineElement)this.bh).setX2(n2 - (this.bh.getWidth() - this.bi));
                } else {
                    this.bh.setWidth(this.bi);
                }
            }
            this.bh.setX(this.bi - this.bh.getWidth());
            if (this.bh instanceof AbstractLineElement) {
                ((AbstractLineElement)this.bh).setX2(this.bi);
            }
        }
    }
}

