/*
 * Decompiled with CFR 0.152.
 */
package com.inet.chart3d.geom;

import com.inet.chart3d.geom.h;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ViewParams
implements Serializable {
    public static final String TOKEN_VIEW_PARAM = "ViewParam";
    public static final int MIN_VIEW = 0;
    public static final int MAX_VIEW = 100;
    public static final int DEFAULT_H_VIEW = 70;
    public static final int DEFAULT_V_VIEW = 30;
    private int aK = 70;
    private int aL = 30;

    public ViewParams() {
    }

    public ViewParams(int angle, int height) {
        this.setHView(angle);
        this.setVView(height);
    }

    public static ViewParams createDefault() {
        return new ViewParams();
    }

    public void setViewParams(ViewParams viewParams) {
        this.setHView(viewParams.getHView());
        this.setVView(viewParams.getVView());
    }

    public int getHView() {
        return this.aK;
    }

    public void setHView(int hView) {
        if (hView >= 0 && hView <= 100) {
            this.aK = hView;
        }
    }

    public int getVView() {
        return this.aL;
    }

    public void setVView(int vView) {
        if (vView >= 0 && vView <= 100) {
            this.aL = vView;
        }
    }

    public h getU() {
        return h.d(0.0, 1.0, 0.0);
    }

    public h getN() {
        double d2 = -10.0 + 1.1 * (double)this.getHView();
        double d3 = Math.cos(Math.toRadians(d2));
        double d4 = Math.sin(Math.toRadians(d2));
        return h.d(d3, 0.0, d4);
    }

    public h getV() {
        double d2 = -10.0 + 1.1 * (double)this.getHView();
        double d3 = Math.sin(Math.toRadians(d2));
        double d4 = -Math.cos(Math.toRadians(d2));
        return h.d(d3, 0.0, d4);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof ViewParams) {
            ViewParams viewParams = (ViewParams)o2;
            return this.getHView() == viewParams.getHView() && this.getVView() == viewParams.getVView();
        }
        return false;
    }

    public int hashCode() {
        return this.getHView() + this.getVView();
    }

    public void saveProperties(StringBuilder buffer, int depth) {
        String string = BaseUtils.getIndent(depth);
        ++depth;
        buffer.append(string);
        buffer.append("<");
        buffer.append(TOKEN_VIEW_PARAM);
        buffer.append(">\n");
        f.b(buffer, depth, "HView", String.valueOf(this.getHView()));
        f.b(buffer, depth, "VView", String.valueOf(this.getVView()));
        buffer.append(string);
        buffer.append("<");
        buffer.append("/");
        buffer.append(TOKEN_VIEW_PARAM);
        buffer.append(">\n");
    }

    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            String string = element2.getNodeName();
            try {
                String string2;
                if (string.equals("HView")) {
                    string2 = element2.getAttribute("value");
                    this.setHView(Integer.parseInt(string2));
                    continue;
                }
                if (!string.equals("VView")) continue;
                string2 = element2.getAttribute("value");
                this.setVView(Integer.parseInt(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

