/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.ibm.icu.text.BreakIterator;
import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.IOFunctions;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.TextSelectionUtil;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.persistence.Persistence;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.FileSearchIndexPersistence;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@InternalApi
public class TextSearchHandler {
    private static final SearchTag nZ = new SearchTag("title", (SearchTokenizer)new TextSearchTokenizer(){

        protected boolean isDelimiter(char ch) {
            return Character.isWhitespace(ch);
        }
    }, 1, () -> PDFCCorePlugin.MSG.getMsg("search.tag.text", new Object[0])){};
    private IndexSearchEngine<TextID> nK;
    private b oa = new b();
    private ComparePersistence ob;
    private static final Object oc = new Object();
    private File od;

    public TextSearchHandler(ComparePersistence source, @Nullable File storePath) {
        this(source);
        this.od = storePath;
    }

    public TextSearchHandler(ComparePersistence source) {
        this.ob = source;
        PersistenceObserver persistenceObserver = new PersistenceObserver(){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public <T> void changed(PersistenceObserver.EventType<T> type, T eventData, boolean isPassive) {
                if (type == PersistenceObserver.EventType.COMPARISON_RESET) {
                    TextSearchHandler.this.clear();
                }
            }
        };
        source.addObserver(persistenceObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initIndex() {
        if (this.nK != null) {
            if (this.nK.isReindexRunning()) {
                Object object = oc;
                synchronized (object) {
                    if (!this.nK.isReindexRunning()) {
                        return;
                    }
                    try {
                        oc.wait(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            return;
        }
        State state = this.ob.getCompareState().getState();
        if (state != State.FINISHED) {
            return;
        }
        Object object = oc;
        synchronized (object) {
            if (this.nK != null) {
                return;
            }
            if (this.od != null) {
                if (!this.od.isDirectory() && !this.od.mkdirs()) {
                    PDFCCore.LOGGER_CORE.error((Object)("Failed to create text search index folder: " + String.valueOf(this.od)));
                }
                this.nK = new IndexSearchEngine(new FileSearchIndexPersistence(this.od), null, TextID.class);
            } else {
                this.nK = new IndexSearchEngine(this.cb(), null, false, TextID.class);
            }
            try {
                this.nK.addTag(nZ);
                this.nK.setData((SearchDataCache)this.oa);
            }
            catch (IOException | IllegalStateException exception) {
                PDFCCore.LOGGER_CORE.error((Throwable)exception);
            }
            oc.notifyAll();
        }
    }

    private String cb() {
        return "comparison-" + this.ob.getGUID().toString();
    }

    public void clear() {
        if (this.nK == null) {
            return;
        }
        SearchIndexPersistence searchIndexPersistence = Persistence.getInstance().getSearchIndexPersistence(this.cb());
        if (searchIndexPersistence != null) {
            searchIndexPersistence.delete();
        }
        if (this.od != null) {
            IOFunctions.deleteDir((File)this.od);
        }
        this.nK = null;
        this.oa = new b();
    }

    public List<SuggestedValue> getSuggestedValues(String phrase) {
        this.initIndex();
        State state = this.ob.getCompareState().getState();
        if (state != State.FINISHED || this.nK == null) {
            return new ArrayList<SuggestedValue>();
        }
        List<SuggestedValue> list = this.nK.getSuggestedValues(phrase, 15, null);
        list = list.stream().filter(suggestedValue -> suggestedValue.getType() != SuggestedValue.SuggestedValueType.FIELD).collect(Collectors.toList());
        return list;
    }

    public List<List<TextID>> search(String searchString) {
        Object object;
        Object object2;
        int n;
        if (searchString == null || searchString.isBlank()) {
            return new ArrayList<List<TextID>>();
        }
        this.initIndex();
        BreakIterator breakIterator = BreakIterator.getWordInstance((Locale)ClientLocale.getThreadLocale());
        breakIterator.setText(searchString);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = null;
        int n2 = n = breakIterator.first();
        while ((n2 = breakIterator.next()) != -1) {
            object2 = searchString.substring(n, n2);
            if (!((String)object2).isBlank()) {
                arrayList.add(object2);
            }
            n = n2;
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Object object4;
            SearchResultEntry searchResultEntry2;
            object = (String)object2.next();
            AndSearchExpression andSearchExpression = new AndSearchExpression();
            SearchCondition.SearchTermOperator searchTermOperator = object2.hasNext() ? SearchCondition.SearchTermOperator.Equals : SearchCondition.SearchTermOperator.StartsWith;
            andSearchExpression.add((SearchExpression)new SearchCondition(nZ.getTag(), searchTermOperator, object, true));
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{andSearchExpression});
            SearchResult searchResult = this.nK.search(searchCommand);
            if (object3 == null) {
                object3 = new HashMap();
                for (SearchResultEntry searchResultEntry2 : searchResult.getEntries()) {
                    object4 = new ArrayList(arrayList.size());
                    object4.add((TextID)searchResultEntry2.getId());
                    object3.put((TextID)searchResultEntry2.getId(), object4);
                }
                continue;
            }
            HashMap hashMap = new HashMap();
            searchResultEntry2 = searchResult.getEntries().iterator();
            while (searchResultEntry2.hasNext()) {
                object4 = (SearchResultEntry)searchResultEntry2.next();
                TextID textID = (TextID)object4.getId();
                TextID textID2 = new TextID(textID.getPageIndex(), textID.getWordIndex() - 1, textID.isFirst());
                List list3 = (List)object3.get(textID2);
                if (list3 == null) continue;
                list3.add(textID);
                hashMap.put(textID, list3);
            }
            object3 = hashMap;
        }
        object = new ArrayList(object3.values());
        Collections.sort(object, (list, list2) -> ((TextID)list.get(0)).compareTo((TextID)list2.get(0)));
        return object;
    }

    private class b
    extends AbstractSearchDataCache<TextID> {
        private int nd = -1;
        private boolean oh = true;
        private List<TextInfo> oi = null;

        private b() {
        }

        public Map<String, Object> a(TextID textID) {
            Serializable serializable;
            Serializable serializable2;
            if (this.oi == null || this.oh != textID.isFirst() || this.nd != textID.getPageIndex()) {
                serializable2 = this.getResult();
                if (serializable2 == null) {
                    return null;
                }
                serializable = ((ResultModel)serializable2).getPage(textID.getPageIndex(), textID.isFirst());
                if (serializable == null) {
                    return null;
                }
                this.oi = TextSelectionUtil.getTextInfos((ResultPage)serializable);
                this.nd = ((ResultPage)serializable).getPageIndex();
                this.oh = ((ResultPage)serializable).isLeft();
            }
            if (textID.getWordIndex() < 0 || textID.getWordIndex() >= this.oi.size()) {
                return null;
            }
            serializable2 = this.oi.get(textID.getWordIndex());
            serializable = new HashMap(1);
            serializable.put(nZ.getTag(), serializable2.getText());
            return serializable;
        }

        private ResultModel getResult() {
            if (TextSearchHandler.this.ob.getCompareState().getState() != State.FINISHED) {
                return null;
            }
            ResultModel resultModel = null;
            try {
                resultModel = TextSearchHandler.this.ob.getResult();
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
            }
            return resultModel;
        }

        public Iterator<TextID> iterator() {
            return new a(this.getResult());
        }

        public /* synthetic */ Map getCacheEntry(Object object) {
            return this.a((TextID)object);
        }
    }

    @JsonData
    @InternalApi
    public static class TextID
    implements Comparable<TextID> {
        private int pageIndex;
        private int wordIndex;
        private boolean first;

        public TextID() {
        }

        public TextID(int pageIndex, int wordIndex, boolean first) {
            this.pageIndex = pageIndex;
            this.wordIndex = wordIndex;
            this.first = first;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public int getWordIndex() {
            return this.wordIndex;
        }

        public boolean isFirst() {
            return this.first;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.pageIndex, this.wordIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TextID)) {
                return false;
            }
            TextID textID = (TextID)obj;
            return this.first == textID.first && this.pageIndex == textID.pageIndex && this.wordIndex == textID.wordIndex;
        }

        public String toString() {
            return this.first + "_" + this.pageIndex + "_" + this.wordIndex;
        }

        @Override
        public int compareTo(TextID o) {
            int n = Integer.compare(this.pageIndex, o.pageIndex);
            if (n != 0) {
                return n;
            }
            if (this.first != o.first) {
                return this.first ? -1 : 1;
            }
            return Integer.compare(this.wordIndex, o.wordIndex);
        }
    }

    private static class a
    implements Iterator<TextID> {
        private ResultModel of;
        private int nd = 0;
        private int og = 0;
        private boolean oh = true;
        private List<TextInfo> oi = null;

        public a(ResultModel resultModel) {
            this.of = resultModel;
            ResultPage resultPage = resultModel.getPage(this.nd, this.oh);
            if (resultPage != null) {
                this.oi = TextSelectionUtil.getTextInfos(resultPage);
            }
        }

        @Override
        public boolean hasNext() {
            ResultPage resultPage;
            if (this.oi == null) {
                return false;
            }
            if (this.og < this.oi.size()) {
                return true;
            }
            int n = this.nd;
            boolean bl = this.oh;
            do {
                if (!bl) {
                    ++n;
                }
                if ((resultPage = this.of.getPage(n, bl = !bl)) != null) continue;
                return false;
            } while (TextSelectionUtil.getTextInfos(resultPage).size() <= 0);
            return true;
        }

        public TextID cd() {
            block3: {
                ResultPage resultPage;
                List<TextInfo> list;
                if (this.oi == null) {
                    return null;
                }
                if (this.og < this.oi.size()) break block3;
                int n = this.nd;
                boolean bl = this.oh;
                do {
                    if (!bl) {
                        ++n;
                    }
                    if ((resultPage = this.of.getPage(n, bl = !bl)) != null) continue;
                    return null;
                } while ((list = TextSelectionUtil.getTextInfos(resultPage)).size() <= 0);
                this.oi = list;
                this.og = 0;
                this.nd = n;
                this.oh = bl;
            }
            return new TextID(this.nd, this.og++, this.oh);
        }

        @Override
        public /* synthetic */ Object next() {
            return this.cd();
        }
    }
}

