/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.a;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.NamedExtension;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@InternalApi
public interface PersistenceFactory
extends NamedExtension {
    public ComparePersistence getPersistence(GUID var1) throws AccessDeniedException, IOException;

    public ComparePersistence getPersistenceSystemAccess(GUID var1) throws IOException;

    public void forEachGUID(Consumer<GUID> var1) throws IOException;

    public boolean hasComparison(GUID var1);

    public GUID getOwner(GUID var1);

    public void remove(GUID var1, boolean var2) throws AccessDeniedException, IOException;

    default public ComparePersistence createPersistence(GUID compareID, UserSession user, String creator) throws AccessDeniedException, IllegalArgumentException, IOException, QuotaExceededException {
        return this.createPersistence(compareID, user, creator, true);
    }

    public ComparePersistence createPersistence(GUID var1, UserSession var2, String var3, boolean var4) throws AccessDeniedException, IllegalArgumentException, IOException, QuotaExceededException;

    public void closeAllSessions();

    public IndexSearchEngine<GUID> getSearchIndex();

    public void addGlobalObserver(GlobalPersistenceObsever var1);

    public void removeGlobalObserver(GlobalPersistenceObsever var1);

    @InternalApi
    public static interface GlobalPersistenceObsever {
        public <T> void changed(GUID var1, PersistenceObserver.EventType<T> var2, T var3, boolean var4);
    }

    @InternalApi
    public static final class TAG
    extends Enum<TAG> {
        public static final /* enum */ TAG GUID = new TAG(new a("id", SearchDataType.ID, false, 11, "search.tag.guid", false));
        public static final /* enum */ TAG SIZE = new TAG(new a("size", SearchDataType.Long, false, 5, "search.tag.size", true));
        public static final /* enum */ TAG OWNER = new TAG(new a("owner.id", SearchDataType.ID, false, 10, "search.tag.ownerid", false));
        public static final /* enum */ TAG NAME = new TAG(new a("title", SearchDataType.String, true, 1, "search.tag.name", true));
        public static final /* enum */ TAG MODIFIED = new TAG(new a("modified", SearchDataType.Date, false, 6, "search.tag.modified", true));
        public static final /* enum */ TAG CREATED = new TAG(new a("created", SearchDataType.Date, false, 7, "search.tag.created", true));
        public static final /* enum */ TAG PUBLIC = new TAG(new a("share.mode", SearchDataType.Integer, false, 8, "search.tag.public", false));
        public static final /* enum */ TAG PUBLIC_GROUPS = new TAG(new a("share.groups", SearchDataType.ID, true, 9, "search.tag.public.groups", false){

            public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
                for (String string : (Collection)val) {
                    if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                    return true;
                }
                return false;
            }
        });
        public static final /* enum */ TAG PUBLIC_USERS = new TAG(new a("share.users", SearchDataType.ID, true, 12, "search.tag.public.users", false){

            public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
                for (String string : (Collection)val) {
                    if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                    return true;
                }
                return false;
            }
        });
        public static final /* enum */ TAG DIFFERENCES = new TAG(new a("differences.count", SearchDataType.Integer, false, 4, "search.tag.differences", true));
        public static final /* enum */ TAG DOCUMENT_1 = new TAG(new a("first.name", SearchDataType.String, false, 2, "search.tag.document1", true));
        public static final /* enum */ TAG DOCUMENT_2 = new TAG(new a("second.name", SearchDataType.String, false, 3, "search.tag.document2", true));
        private SearchTag ny;
        private static Map<String, TAG> nz;
        private static final /* synthetic */ TAG[] nA;

        public static TAG[] values() {
            return (TAG[])nA.clone();
        }

        public static TAG valueOf(String name) {
            return Enum.valueOf(TAG.class, name);
        }

        private TAG(SearchTag tag) {
            this.ny = tag;
        }

        public SearchTag getTag() {
            return this.ny;
        }

        public static TAG getTag(String key) {
            if (nz == null) {
                HashMap<String, TAG> hashMap = new HashMap<String, TAG>();
                for (TAG tAG : TAG.values()) {
                    hashMap.put(tAG.getTag().getTag(), tAG);
                }
                nz = hashMap;
            }
            return nz.get(key);
        }

        private static /* synthetic */ TAG[] bX() {
            return new TAG[]{GUID, SIZE, OWNER, NAME, MODIFIED, CREATED, PUBLIC, PUBLIC_GROUPS, PUBLIC_USERS, DIFFERENCES, DOCUMENT_1, DOCUMENT_2};
        }

        static {
            nA = TAG.bX();
        }
    }
}

