/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.persistence.RandomAccessRead;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

@InternalApi
public class DocumentReader
implements DocumentFactory {
    private static final DocumentReader mi = new DocumentReader();

    public static DocumentReader getInstance() {
        return mi;
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DocumentFactory documentFactory : this.getReaderFactories()) {
            Set<String> set = documentFactory.getSupportedFileExtensions();
            if (set == null) continue;
            treeSet.addAll(set);
        }
        return treeSet;
    }

    @Override
    public String getDocumentTypeName(Locale locale) {
        return PDFCCorePlugin.MSG.getMsg(locale, "documentreader.type.allsupported", new Object[0]);
    }

    public boolean canRead(PdfSource document) {
        boolean bl;
        block8: {
            RandomAccessRead randomAccessRead = document.getContent();
            try {
                bl = this.canRead(document.getName(), randomAccessRead);
                if (randomAccessRead == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessRead != null) {
                        try {
                            randomAccessRead.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            randomAccessRead.close();
        }
        return bl;
    }

    @Override
    public boolean canRead(String name, byte[] content) {
        for (DocumentFactory documentFactory : this.getReaderFactories()) {
            if (!documentFactory.canRead(name, content)) continue;
            return true;
        }
        return false;
    }

    protected List<DocumentFactory> getReaderFactories() {
        return PluginManager.get(DocumentFactory.class);
    }

    @Override
    public boolean canRead(String fileName, File document) {
        for (DocumentFactory documentFactory : this.getReaderFactories()) {
            if (!documentFactory.canRead(fileName, document)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canRead(String fileName, RandomAccessRead document) {
        for (DocumentFactory documentFactory : this.getReaderFactories()) {
            if (!documentFactory.canRead(fileName, document)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Document readDocumentReduced(String fileName, RandomAccessRead document, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        List<DocumentFactory> list = this.getReaderFactories();
        for (DocumentFactory documentFactory : list) {
            try {
                document.seek(0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (!documentFactory.canRead(fileName, document)) continue;
                document.seek(0L);
                return documentFactory.readDocumentReduced(fileName, document, password, requiredFeatures);
            }
            catch (Throwable throwable) {
            }
        }
        try {
            document.seek(0L);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.debug((Object)iOException);
        }
        DocumentFactory documentFactory = this.B(fileName);
        if (documentFactory != null) {
            try {
                return documentFactory.readDocumentReduced(fileName, document, password, requiredFeatures);
            }
            catch (PdfcException | Error | RuntimeException object) {
                try {
                    document.close();
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.debug((Object)iOException);
                }
                throw object;
            }
        }
        try {
            document.close();
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.debug((Object)iOException);
        }
        this.a(fileName, list.size());
        return null;
    }

    @Override
    public Document readDocumentReduced(String userFileName, File file, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        List<DocumentFactory> list = this.getReaderFactories();
        for (DocumentFactory documentFactory : list) {
            try {
                if (!documentFactory.canRead(userFileName, file)) continue;
                return documentFactory.readDocumentReduced(userFileName, file, password, requiredFeatures);
            }
            catch (Throwable throwable) {
            }
        }
        DocumentFactory documentFactory = this.B(file.getName());
        if (documentFactory != null) {
            return documentFactory.readDocumentReduced(userFileName, file, password, requiredFeatures);
        }
        this.a(file.getName(), list.size());
        return null;
    }

    @Override
    public Document readDocumentReduced(byte[] data, String userFileName, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        List<DocumentFactory> list = this.getReaderFactories();
        for (DocumentFactory documentFactory : list) {
            try {
                if (!documentFactory.canRead(userFileName, data)) continue;
                return documentFactory.readDocumentReduced(data, userFileName, password, requiredFeatures);
            }
            catch (Throwable throwable) {
            }
        }
        DocumentFactory documentFactory = this.B(userFileName);
        if (documentFactory != null) {
            return documentFactory.readDocumentReduced(data, userFileName, password, requiredFeatures);
        }
        this.a(userFileName, list.size());
        return null;
    }

    public Document readDocument(PdfSource document) throws PdfcException {
        return this.readDocumentReduced(document, (DocumentFactory.FEATURE[])null);
    }

    @Override
    public Document readDocument(byte[] data, String userFileName, String password) throws DocumentFactory.PasswordException, PdfcException {
        return this.readDocumentReduced(data, userFileName, password, (DocumentFactory.FEATURE[])null);
    }

    @Override
    public Document readDocument(String userFileName, File file, String password) throws DocumentFactory.PasswordException, PdfcException {
        return this.readDocumentReduced(userFileName, file, password, (DocumentFactory.FEATURE[])null);
    }

    public Document readDocumentReduced(PdfSource document, DocumentFactory.FEATURE ... requiredFeatures) throws PdfcException {
        try {
            return this.readDocumentReduced(document.getName(), document.getContent(), document.getPassword(), requiredFeatures);
        }
        catch (IOException iOException) {
            throw PdfcException.create(iOException);
        }
    }

    private DocumentFactory B(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0 || n >= string.length() - 2) {
            return null;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        List<DocumentFactory> list = this.getReaderFactories();
        for (DocumentFactory documentFactory : list) {
            if (!documentFactory.getSupportedFileExtensions().contains(string2)) continue;
            return documentFactory;
        }
        return null;
    }

    private void a(String string, int n) throws PdfcException {
        PdfcErrorCode pdfcErrorCode = n == 0 ? PdfcErrorCode.noParserAtAll : PdfcErrorCode.noParserForFile;
        throw PdfcException.create((ErrorCode)pdfcErrorCode, string);
    }
}

