/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.ObjectSetting;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.SettingsControl;
import com.inet.pdfc.config.UserSettings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.filter.SortFilterVisualization;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class UserSettingsImpl
implements UserSettings {
    public static final UserField<String> SETTINGS = new UserField<String>("pdfc.setting"){

        public boolean isValueChangeLoggable() {
            return false;
        }
    };
    private GUID userID;
    private DefaultSetting settings;
    private DefaultSetting defaults = new DefaultSetting();

    private UserSettingsImpl() {
        List list = ServerPluginManager.getInstance().get(SortFilterVisualization.class);
        for (SortFilterVisualization sortFilterVisualization : list) {
            this.defaults.setColor(sortFilterVisualization.getDefaultHighlightColor(), sortFilterVisualization.getSettingsKey());
        }
    }

    public UserSettingsImpl(GUID userID) {
        Object object;
        List list = ServerPluginManager.getInstance().get(SortFilterVisualization.class);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SortFilterVisualization)object2.next();
            this.defaults.setColor(((SortFilterVisualization)object).getDefaultHighlightColor(), ((SortFilterVisualization)object).getSettingsKey());
        }
        this.userID = userID;
        try {
            list = UserManager.getInstance().getUserAccount(userID);
            if (list != null && (object2 = (String)list.getValue(SETTINGS)) != null) {
                object = (DefaultSetting)new Json().fromJson((String)object2, DefaultSetting.class);
                this.migration((DefaultSetting)object);
                this.migrationTo25((DefaultSetting)object);
                this.settings = object;
            }
        }
        catch (JsonException jsonException) {
            PDFCCore.LOGGER_CORE.error((Object)Msg.getMsg("Error.Usersetting.load", String.valueOf(userID)));
        }
        if (this.settings == null) {
            try {
                this.reset();
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Object)Msg.getMsg("Error.Usersetting.save", String.valueOf(userID)));
            }
        }
    }

    private void migration(DefaultSetting userSettings) {
        Object object;
        Properties properties = SettingsControl.getRawSettings(userSettings);
        String string = ".marker.";
        String string2 = ".visible.";
        String string3 = ".color.";
        for (VisibilitySetting visibilitySetting : SettingUtil.getAvailableVisibilitySetting()) {
            String string4 = ".visible." + visibilitySetting.getTyp() + visibilitySetting.name();
            if (properties.getProperty(string4) == null) continue;
            boolean bl = properties.getProperty(string4, "" + !visibilitySetting.getTyp().equals("OPTION")).equalsIgnoreCase("true");
            userSettings.setEnabled(bl, visibilitySetting);
            properties.remove(string4);
        }
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.values()) {
            object = ".color..marker." + groupType.getTyp() + groupType.name();
            if (properties.getProperty((String)object) == null) continue;
            Color color = new Color(Integer.parseInt(properties.getProperty((String)object, "0")), true);
            userSettings.setMarkerColor(color, groupType);
            properties.remove(object);
        }
        for (ColorSetting colorSetting : SettingUtil.getAvailableColorSetting()) {
            String string5 = ".color." + colorSetting.getTyp() + colorSetting.name();
            if (properties.getProperty(string5) == null) continue;
            int n = Integer.parseInt(properties.getProperty(string5, "-1"));
            if (n != -1) {
                object = new Color(n, true);
                userSettings.setColor((Color)object, colorSetting);
            }
            properties.remove(string5);
        }
    }

    private void migrationTo25(DefaultSetting userSettings) {
        Properties properties = SettingsControl.getRawSettings(userSettings);
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.values()) {
            boolean bl;
            String string;
            if (SettingsControl.hasSetting(groupType, SettingsControl.PURPOSE.visibility, userSettings) && properties.getProperty(string = SettingsControl.getKey(groupType, SettingsControl.PURPOSE.visibility)) != null) {
                bl = properties.getProperty(string, Boolean.FALSE.toString()).equalsIgnoreCase("true");
                for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                    userSettings.setEnabled(bl, modificationType);
                }
                properties.remove(string);
            }
            if (SettingsControl.hasSetting(groupType, SettingsControl.PURPOSE.color, userSettings)) {
                string = SettingsControl.getKey(groupType, SettingsControl.PURPOSE.color);
                bl = Integer.parseInt(properties.getProperty(string, "-1"));
                Color color = new Color(bl ? 1 : 0, true);
                for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                    userSettings.setColor(color, modificationType);
                }
                properties.remove(string);
            }
            if (SettingsControl.hasSetting(groupType, SettingsControl.PURPOSE.marker, userSettings)) {
                string = SettingsControl.getKey(groupType, SettingsControl.PURPOSE.marker);
                bl = Integer.parseInt(properties.getProperty(string, "-1"));
                Color color = new Color(bl ? 1 : 0, true);
                for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                    userSettings.setMarkerColor(color, modificationType);
                }
                properties.remove(string);
            }
            if (!SettingsControl.hasSetting(groupType, SettingsControl.PURPOSE.outline, userSettings)) continue;
            string = SettingsControl.getKey(groupType, SettingsControl.PURPOSE.outline);
            bl = Integer.parseInt(properties.getProperty(string, "-1"));
            Color color = new Color(bl ? 1 : 0, true);
            for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                userSettings.setMarkerColor(color, modificationType);
            }
            properties.remove(string);
        }
    }

    @Override
    public void reset() throws IOException {
        this.settings = new DefaultSetting();
        this.save();
    }

    @Override
    public void save() throws IOException {
        try {
            MutableUserData mutableUserData = new MutableUserData();
            mutableUserData.put(SETTINGS, (Object)new Json().toJson((Object)this.settings));
            UserManager.getInstance().updateUserData(this.userID, mutableUserData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PDFCCore.LOGGER_CORE.debug((Object)Msg.getMsg("Error.Usersetting.store", String.valueOf(this.userID), illegalArgumentException.getMessage()));
        }
    }

    @Override
    public List<ObjectSetting<?>> getAllObjectSettingNames() {
        return this.settings.getAllObjectSettingNames();
    }

    @Override
    public void setMarkerColor(Color color, DiffGroup.GroupType content) {
        for (Modification.ModificationType modificationType : DiffConstants.getModificationType(content)) {
            this.settings.setMarkerColor(color, modificationType);
        }
    }

    @Override
    public void setColor(Color color, ColorSetting setting) {
        this.settings.setColor(color, setting);
    }

    @Override
    public void setEnabled(boolean isVisible, VisibilitySetting ... visibles) {
        this.settings.setEnabled(isVisible, visibles);
    }

    @Override
    public boolean isEnabled(VisibilitySetting content) {
        return this.settings.isEnabled(content);
    }

    public String toString() {
        return String.valueOf(this.userID) + ":" + this.settings.toString();
    }

    @Override
    @Nonnull
    public Color getMarkerColor(DiffGroup.GroupType content) {
        int n = 0;
        Modification.ModificationType[] modificationTypeArray = DiffConstants.getModificationType(content);
        int n2 = modificationTypeArray.length;
        if (n < n2) {
            Modification.ModificationType modificationType = modificationTypeArray[n];
            return this.settings.getMarkerColor(modificationType);
        }
        return this.defaults.getMarkerColor(content);
    }

    @Override
    public void setMarkerColor(Color color, Modification.ModificationType modificationType) {
        this.settings.setMarkerColor(color, modificationType);
    }

    @Override
    @Nonnull
    public Color getMarkerColor(Modification.ModificationType modificationType) {
        if (SettingsControl.hasSetting(modificationType, SettingsControl.PURPOSE.marker, this.settings)) {
            return this.settings.getMarkerColor(modificationType);
        }
        return this.defaults.getMarkerColor(modificationType);
    }

    @Override
    @Nonnull
    public Color getOutlineColor(Modification.ModificationType modificationType) {
        if (SettingsControl.hasSetting(modificationType, SettingsControl.PURPOSE.outline, this.settings)) {
            return this.settings.getOutlineColor(modificationType);
        }
        return this.defaults.getOutlineColor(modificationType);
    }

    @Override
    @Nonnull
    public Color getColor(ColorSetting colorSetting) {
        DiffGroup.GroupType groupType;
        Modification.ModificationType[] modificationTypeArray;
        int n;
        int n2;
        if (colorSetting instanceof DiffGroup.GroupType && (n2 = 0) < (n = (modificationTypeArray = DiffConstants.getModificationType(groupType = (DiffGroup.GroupType)colorSetting)).length)) {
            Modification.ModificationType modificationType = modificationTypeArray[n2];
            return this.settings.getColor(modificationType);
        }
        if (SettingsControl.hasSetting(colorSetting, SettingsControl.PURPOSE.color, this.settings)) {
            return this.settings.getColor(colorSetting);
        }
        return this.defaults.getColor(colorSetting);
    }

    @Override
    public void setSetting(@Nullable Object value, String setting) throws IllegalArgumentException {
        this.settings.setSetting(value, setting);
    }

    @Override
    @Nullable
    public Object getSetting(String setting) {
        return this.settings.getSetting(setting);
    }

    public DefaultSetting getSettingsOverride() {
        return this.settings;
    }

    @Override
    @Nonnull
    public Settings copy() {
        return this.settings.copy();
    }

    @Override
    @Nonnull
    @Deprecated
    public Color getOutlineColor(DiffGroup.GroupType content) {
        int n = 0;
        Modification.ModificationType[] modificationTypeArray = DiffConstants.getModificationType(content);
        int n2 = modificationTypeArray.length;
        if (n < n2) {
            Modification.ModificationType modificationType = modificationTypeArray[n];
            return this.settings.getOutlineColor(modificationType);
        }
        return this.defaults.getOutlineColor(content);
    }

    public static void setAllOutlineMarker(Color color, Settings settings, ColorSetting colorSetting) {
        if (colorSetting == Settings.METAOPTION.ALLOUTLINEMARKER) {
            for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), DiffConstants.getMarkerColor(modificationType).getAlpha());
                settings.setMarkerColor(color2, modificationType);
            }
        }
    }
}

