/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.strict.filter;

import com.inet.annotations.JsonData;
import com.inet.logging.Logger;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.diff.PageMarginDiff;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.util.CollectionUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarginDetector
implements com.inet.pdfc.generator.strict.compare.a,
Serializable {
    private static final Logger LOGGER = PDFCCore.LOGGER_COMPARE;
    private com.inet.pdfc.generator.strict.filter.a iW = new com.inet.pdfc.generator.strict.filter.a();
    private Map<Integer, a> iX = new HashMap<Integer, a>();
    private int iY;

    public MarginDetector(IProfile profile) {
        this.iY = profile.getInt(PDFCProperty.TOLERANCE_PAGE_LEFTCORNER);
    }

    @Override
    public List<CompareDiffGroup> a(Page page, Page page2, int n, int n2) {
        Point point = this.iW.t(page.getElementList().getListOfVisibleElements());
        Point point2 = this.iW.t(page2.getElementList().getListOfVisibleElements());
        a a2 = new a(point, point2);
        int n3 = page.getPageIndex();
        this.iX.put(n3, a2);
        this.iW.a(page.getElementList().getList(), point);
        this.iW.a(page2.getElementList().getList(), point2);
        if (LOGGER.isDebug() && !point.equals(point2)) {
            LOGGER.debug((Object)("Detected margin difference: " + (point2.x - point.x) + ", " + (point2.y - point.y) + " from old to new page."));
        }
        if (Math.abs(point.x - point2.x) > this.iY || Math.abs(point.y - point2.y) > this.iY) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(new PageMarginDiff(point, point2));
            PageImpostor pageImpostor = new PageImpostor(new Rectangle(0, 0, point.x, point.y), n3);
            PageImpostor pageImpostor2 = new PageImpostor(new Rectangle(0, 0, point2.x, point2.y), n3);
            Modification modification = new Modification(DiffGroup.GroupType.MetadataChanged, pageImpostor, pageImpostor2, arrayList);
            return CollectionUtils.toList(new CompareDiffGroup(modification, DiffGroup.GroupType.MetadataChanged));
        }
        return null;
    }

    public void d(int n, List<CompareDiffGroup> list) {
        a a2 = this.iX.get(n);
        this.iW.a(n, true, list, a2.iZ);
        this.iW.a(n, false, list, a2.ja);
    }

    private static class a
    implements Serializable {
        private Point iZ;
        private Point ja;

        public a(Point point, Point point2) {
            this.iZ = point;
            this.ja = point2;
        }
    }

    @JsonData
    private static class PageImpostor
    extends DrawableElement {
        private final int pageIndex;
        private Rectangle outline;

        public PageImpostor(Rectangle outline, int pageIndex) {
            super(pageIndex, new ElementID(false, pageIndex, outline.x, outline.y, outline.width, outline.height));
            this.outline = outline;
            this.pageIndex = pageIndex;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.outline;
        }

        @Override
        public String getLabel() {
            return com.inet.pdfc.model.i18n.a.a("ElementType." + String.valueOf(this.getType()), (Object)Integer.toString(this.pageIndex + 1));
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public ElementType getType() {
            return ElementType.Page;
        }

        @Override
        public void setX(double x) {
        }

        @Override
        public void setY(double y) {
        }

        @Override
        public double getX() {
            return this.getBounds().getX();
        }

        @Override
        public double getY() {
            return this.getBounds().getY();
        }

        @Override
        public int getCompareHash() {
            return -1;
        }
    }
}

