/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphics;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.OCRGraphicsFilter;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Objects;

@InternalApi
public class FilteredGraphics
extends Graphics2D {
    private final int width = 0;
    private final int height = 0;
    private final int tR = 10;
    private Graphics2D tS;
    private boolean tT = true;
    private boolean tU = true;
    private boolean tV = false;

    public static GraphicsFilter getGraphicsFilterForName(FILTERTYPES filtertypes) {
        if (filtertypes == null) {
            return null;
        }
        switch (filtertypes) {
            case NO_TEXTELEMENTS: {
                return new OCRGraphicsFilter().blockText();
            }
            case CMAP: {
                return (bufferedGraphicsCommand, graphics2D) -> {
                    switch (bufferedGraphicsCommand.getName()) {
                        case FILL_ARC: 
                        case FILL_OVAL: 
                        case FILL_RECT: 
                        case FILL_ROUND_RECT: 
                        case FILL: 
                        case FILL_POLYGON: {
                            return false;
                        }
                    }
                    return true;
                };
            }
        }
        return null;
    }

    public static void usageFilter(Page page, boolean first, GraphicsFilter filter, Graphics2D targetGraphics) throws IOException {
        PdfcRenderCache pdfcRenderCache = PdfcSession.getSession().getStoreMap();
        RenderCacheBufferedGraphics renderCacheBufferedGraphics = pdfcRenderCache.getPageGraphics(page.getPageIndex(), first);
        if (renderCacheBufferedGraphics == null) {
            pdfcRenderCache.putPage(page, first);
            renderCacheBufferedGraphics = pdfcRenderCache.getPageGraphics(page.getPageIndex(), first);
        }
        renderCacheBufferedGraphics.drawTo(targetGraphics, filter);
    }

    public void setAllowedFilledRectangle(boolean allowedFilledRectangle) {
        this.tT = allowedFilledRectangle;
    }

    public void setAllowedImage(boolean allowedImage) {
        this.tU = allowedImage;
    }

    public void setAllowedBackgroundPageImage(boolean allowedBackgroundPageImage) {
        this.tV = allowedBackgroundPageImage;
    }

    @Override
    public void draw(Shape s) {
        this.tS.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (this.c(img)) {
            return this.tS.drawImage(img, xform, obs);
        }
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (this.c(img)) {
            this.tS.drawImage(img, op, x, y);
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.tS.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.tS.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.tS.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.tS.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.tS.drawString(iterator, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.c(img) && this.tS.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean c(Image image) {
        if (!this.tU) return false;
        if (this.tV) return true;
        int n = image.getWidth(null) + 10;
        Objects.requireNonNull(this);
        if (n >= 0) return false;
        int n2 = image.getHeight(null) + 10;
        Objects.requireNonNull(this);
        if (n2 >= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean f(int n, int n2) {
        if (!this.tT) return false;
        if (this.tV) return true;
        Objects.requireNonNull(this);
        if (n + 10 >= 0) return false;
        Objects.requireNonNull(this);
        if (n2 + 10 >= 0) return false;
        return true;
    }

    @Override
    public void dispose() {
        this.tS.dispose();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.tS.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        this.tS.drawGlyphVector(g2, x, y);
    }

    @Override
    public void fill(Shape s) {
        if (this.f(s.getBounds().width, s.getBounds().height)) {
            this.tS.fill(s);
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.tS.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.tS.getDeviceConfiguration();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.tS.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.tS.getRenderingHint(hintKey);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.tS.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.tS.getRenderingHints();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.tS.setRenderingHints(hints);
    }

    @Override
    public Graphics create() {
        return this.tS.create();
    }

    @Override
    public void translate(int x, int y) {
        this.tS.translate(x, y);
    }

    @Override
    public Color getColor() {
        return this.tS.getColor();
    }

    @Override
    public void setColor(Color c2) {
    }

    @Override
    public void setPaintMode() {
        this.tS.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.tS.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.tS.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.tS.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f2) {
        return this.tS.getFontMetrics(f2);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.tS.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.tS.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.tS.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.tS.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.tS.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.tS.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.f(width, height)) {
            this.tS.fillRect(x, y, width, height);
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.tS.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.tS.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.f(width, height)) {
            this.tS.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.tS.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.f(width, height)) {
            this.tS.fillOval(x, y, width, height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.tS.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.f(width, height)) {
            this.tS.fillArc(x, y, width, height, startAngle, arcAngle);
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.tS.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.tS.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i = 0; i < nPoints; ++i) {
            int n5 = xPoints[i];
            int n6 = yPoints[i];
            n = Math.min(n, n5);
            n2 = Math.max(n2, n5);
            n3 = Math.min(n3, n6);
            n4 = Math.max(n4, n6);
        }
        if (this.tT && this.f(n2 - n, n4 - n3)) {
            this.tS.fillPolygon(xPoints, yPoints, nPoints);
        }
    }

    @Override
    public void translate(double tx, double ty) {
        this.tS.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.tS.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.tS.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.tS.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.tS.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.tS.transform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.tS.getTransform();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.tS.setTransform(Tx);
    }

    @Override
    public Paint getPaint() {
        return this.tS.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public Composite getComposite() {
        return this.tS.getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        this.tS.setComposite(comp);
    }

    @Override
    public Color getBackground() {
        return this.tS.getBackground();
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Stroke getStroke() {
        return this.tS.getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
    }

    @Override
    public void clip(Shape s) {
        this.tS.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.tS.getFontRenderContext();
    }

    @InternalApi
    public static final class FILTERTYPES
    extends Enum<FILTERTYPES> {
        public static final /* enum */ FILTERTYPES NO_TEXTELEMENTS = new FILTERTYPES();
        public static final /* enum */ FILTERTYPES CMAP = new FILTERTYPES();
        private static final /* synthetic */ FILTERTYPES[] tX;

        public static FILTERTYPES[] values() {
            return (FILTERTYPES[])tX.clone();
        }

        public static FILTERTYPES valueOf(String name) {
            return Enum.valueOf(FILTERTYPES.class, name);
        }

        private static /* synthetic */ FILTERTYPES[] dq() {
            return new FILTERTYPES[]{NO_TEXTELEMENTS, CMAP};
        }

        static {
            tX = FILTERTYPES.dq();
        }
    }
}

