/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.logging.Logger;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.util.Pair;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class BatchSummaryCreator {
    private Map<Pair<String>, Integer> tj = new LinkedHashMap<Pair<String>, Integer>();
    private Logger ma = BasePresenter.LOGGER;
    private int width;

    public BatchSummaryCreator(int width) {
        this.width = width;
    }

    public synchronized void storeResultForSummary(String nameFirst, String nameSecond, int result) {
        this.tj.put(new Pair<String>(nameFirst, nameSecond), result);
    }

    public synchronized void storeRemoved(@Nonnull String nameFirst) {
        this.tj.put(new Pair<Object>(nameFirst, null), 0);
    }

    public synchronized void storeAdded(@Nonnull String nameSecond) {
        this.tj.put(new Pair<String>(null, nameSecond), 0);
    }

    public void setLogger(@Nonnull Logger logger) {
        this.ma = logger;
    }

    public void setMaximumNameColumnWidth(int width) {
        this.width = width;
    }

    public synchronized void printResultAndClear() {
        Object object;
        String string = Msg.getMsg("Status.ResultSummaryH1");
        String string2 = Msg.getMsg("Status.ResultSummaryH2");
        int n = string.length() + 1;
        for (Pair<String> object2 : this.tj.keySet()) {
            String string3 = object2.get(true);
            object = object2.get(false);
            if (string3 == null) {
                n = Math.max(n, ((String)object).length());
                continue;
            }
            if (object == null) {
                n = Math.max(n, string3.length());
                continue;
            }
            if (string3.equals(object)) {
                n = Math.max(n, string3.length());
                continue;
            }
            n = Math.max(n, string3.length() + ((String)object).length() + 3);
        }
        n = Math.min(this.width, n) + 1;
        int n2 = n + 2 + string2.length();
        this.ma.info((Object)this.a('-', n2));
        this.ma.info((Object)Msg.getMsg("Status.ResultSummary"));
        this.ma.info((Object)this.a('-', n2));
        this.ma.info((Object)(string + this.a(' ', n - string.length()) + "| " + string2));
        this.ma.info((Object)this.a('-', n2));
        for (Map.Entry<Pair<String>, Integer> entry : this.tj.entrySet()) {
            int n3;
            Object object2;
            object = entry.getKey();
            String string4 = entry.getValue().toString();
            if (((Pair)object).get(true) == null) {
                object2 = this.b((String)((Pair)object).get(false), this.width);
                string4 = Msg.getMsg("Status.ResultSummaryAdded");
            } else if (((Pair)object).get(false) == null) {
                object2 = this.b((String)((Pair)object).get(true), this.width);
                string4 = Msg.getMsg("Status.ResultSummaryRemoved");
            } else {
                if (((String)((Pair)object).get(true)).equals(((Pair)object).get(false))) {
                    object2 = this.b((String)((Pair)object).get(true), this.width);
                } else {
                    n3 = (this.width - 4) / 2;
                    object2 = this.b((String)((Pair)object).get(true), n3) + " - " + this.b((String)((Pair)object).get(false), n3);
                }
                string4 = entry.getValue().toString();
            }
            n3 = n - ((String)object2).length();
            char[] cArray = new char[n3];
            Arrays.fill(cArray, ' ');
            this.ma.info((Object)((String)object2 + this.a(' ', n3) + "| " + string4));
        }
        this.tj.clear();
    }

    private String b(@Nullable String object, int n) {
        if (object != null && ((String)object).length() > n) {
            int n2 = (n - 4) / 2 + 0;
            int n3 = Math.max(((String)object).lastIndexOf(" ", n2), n2);
            int n4 = Math.max(((String)object).indexOf(" ", Math.max(((String)object).length() - n2, n3)) + 1, ((String)object).length() - n2);
            object = ((String)object).substring(0, n3) + " ... " + ((String)object).substring(n4);
        }
        return object;
    }

    @Nonnull
    private String a(char c2, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c2);
        return new String(cArray);
    }
}

