/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultObjectSetting;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.ObjectSetting;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageDataImpl;
import com.inet.pdfc.generator.message.PageFilterDone;
import com.inet.pdfc.generator.message.PartialDiffs;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.util.EnumParser;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ResultModelUpdater
implements DataGeneratorListener {
    public static ObjectSetting<Integer> DIFF_LIMIT = new DefaultObjectSetting<Integer>("DIFF_LIMIT"){

        public Integer j(String string) {
            return string == null ? null : Integer.valueOf(string);
        }

        public String a(Integer n) {
            return n != null ? n.toString() : "-1";
        }

        @Override
        public /* synthetic */ String getAsString(Object object) {
            return this.a((Integer)object);
        }

        @Override
        public /* synthetic */ Object getObject(String string) {
            return this.j(string);
        }
    };
    private ResultModel model;
    private ExceptionData rM = null;

    public ResultModelUpdater(@Nonnull ResultModel model) {
        if (model == null) {
            throw new NullPointerException("Model must not be null");
        }
        this.model = model;
    }

    public void setImageCache(PageImageCache cache) {
        this.model.getModelData().setPageImageCache(cache);
        this.model.getModelData().setModel(this.model);
    }

    public void setComparisonID(@Nullable GUID comparisonID) {
        this.model.getModelData().setComparisonID(comparisonID);
    }

    @Override
    public void addData(Chunk chunk) {
        if (chunk == null) {
            return;
        }
        ResultModelData resultModelData = this.model.getModelData();
        switch (chunk.getType()) {
            case info: {
                Painter.HighlightColorSetting highlightColorSetting;
                Settings settings;
                InfoData infoData = (InfoData)chunk;
                this.model.a(infoData);
                IProfile iProfile = infoData.getProfile();
                if (iProfile == null || !EnumParser.isInList(CompareType.ANNOTATION.name(), iProfile.getString(PDFCProperty.COMPARE_TYPES)) || (settings = this.model.getSettings()).isEnabled(highlightColorSetting = new Painter.HighlightColorSetting("ANNOTATION"))) break;
                settings.setEnabled(true, highlightColorSetting);
                this.model.setSetting(settings);
                break;
            }
            case textInfoUpdate: 
            case pageParsed: {
                this.a((PageDataImpl)chunk);
                break;
            }
            case pageAnalyzed: {
                break;
            }
            case pageFiltered: {
                this.a(new ResultModel.ChangeInfo(ResultModel.STATE_CHANGE_TYPE.HIGHLIGHT_UPDATE, this.model, (PageFilterDone)chunk, resultModelData.getProgress()));
                break;
            }
            case partialDiffs: {
                this.a((PartialDiffs)chunk);
                break;
            }
            case highlight: {
                HighlightData highlightData = (HighlightData)chunk;
                resultModelData.addHighlight(highlightData.getFilterKey(), highlightData);
                break;
            }
            case progress: {
                resultModelData.setProgress((ProgressState)chunk);
                this.a(new ResultModel.ChangeInfo(this.model, resultModelData.getProgress()));
                break;
            }
            case error: {
                ErrorData errorData = (ErrorData)chunk;
                if (this.rM == errorData.getError()) {
                    return;
                }
                this.rM = errorData.getError();
                List<ResultModel.ResultModelChangeListener> list = this.model.cZ();
                if (list.size() <= 0) break;
                boolean bl = false;
                for (ResultModel.ResultModelChangeListener resultModelChangeListener : list) {
                    bl |= resultModelChangeListener.errorOcurred(errorData.getError(), errorData.isInterrupt(), BasePresenter.ERROR_SOURCE.values()[errorData.getSource()]);
                }
                if (!bl) break;
                errorData.setLogged();
                break;
            }
            default: {
                PDFCCore.LOGGER_CORE.warn((Object)("Unknown data type '" + String.valueOf((Object)chunk.getType()) + "'"));
            }
        }
    }

    void a(ResultModel.ChangeInfo changeInfo) {
        List<ResultModel.ResultModelChangeListener> list = this.model.cZ();
        for (int i = list.size() - 1; i >= 0; --i) {
            ResultModel.ResultModelChangeListener resultModelChangeListener = list.get(i);
            resultModelChangeListener.modelChanged(changeInfo);
        }
    }

    private void a(PageDataImpl pageDataImpl) {
        this.model.getModelData().addPage(new ResultPage(pageDataImpl, this.model.getPageImageCache(), this.model), pageDataImpl.isFirst());
    }

    private void a(PartialDiffs partialDiffs) {
        List<? extends MutableDiffGroup> list = partialDiffs.getList();
        ResultModelData resultModelData = this.model.getModelData();
        List<? extends MutableDiffGroup> list2 = resultModelData.addDiffs(list);
        List<ResultFilter> list3 = this.model.getResultFilters();
        if (list3.size() > 0 && list2 != null && list2.size() > 0) {
            for (ResultFilter resultFilter : list3) {
                resultFilter.filterDifferencesImpl(list2);
            }
        }
        if (list2 != list && list2 != null) {
            partialDiffs.getList().clear();
            partialDiffs.getList().addAll(list2);
        }
        this.model.getModelData().finish();
        this.a(new ResultModel.ChangeInfo(ResultModel.STATE_CHANGE_TYPE.INCREMENTAL, list, this.model, resultModelData.getProgress()));
    }

    public ResultModelData getModelData() {
        return this.model.getModelData();
    }

    public void addResultFilter(ResultFilter filter) {
        this.model.addResultFilter(filter);
    }

    public void removeResultFilter(ResultFilter filter) {
        this.model.removeResultFilter(filter);
    }

    public List<ResultFilter> getResultFilters() {
        return this.model.getResultFilters();
    }
}

