/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class ElementID
implements Serializable,
Comparable<ElementID> {
    @Nonnull
    public static final ElementID DUMMY = new ElementID();
    private int @Nonnull [] idLevels;

    private ElementID() {
        this.idLevels = new int[0];
    }

    public ElementID(int id) {
        this.idLevels = new int[]{id};
    }

    public ElementID(int ... idLevels) {
        this(true, idLevels);
    }

    public ElementID(boolean copy, int ... idLevels) {
        if (copy) {
            this.idLevels = new int[idLevels.length];
            System.arraycopy(idLevels, 0, this.idLevels, 0, idLevels.length);
        } else {
            this.idLevels = idLevels;
        }
    }

    public int @Nonnull [] getRaw() {
        return this.idLevels;
    }

    @Nonnull
    public ElementID getNext() {
        int[] nArray = Arrays.copyOf(this.idLevels, this.idLevels.length);
        int n = nArray.length - 1;
        nArray[n] = nArray[n] + 1;
        ElementID elementID = new ElementID(false, nArray);
        return elementID;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ElementID)) {
            return false;
        }
        return Arrays.equals(this.idLevels, ((ElementID)obj).idLevels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.idLevels);
    }

    @Override
    public int compareTo(@Nonnull ElementID o) {
        int n = Math.min(this.idLevels.length, o.idLevels.length);
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.compare(this.idLevels[i], o.idLevels[i]);
            if (n2 == 0) continue;
            return n2;
        }
        if (this.idLevels.length == o.idLevels.length) {
            return 0;
        }
        return o.idLevels.length - this.idLevels.length;
    }

    @Nonnull
    public ElementID getDescendant() {
        return this.getDescendant(0);
    }

    @Nonnull
    public ElementID getDescendant(int descendantID) {
        int[] nArray = Arrays.copyOf(this.idLevels, this.idLevels.length + 1);
        nArray[nArray.length - 1] = descendantID;
        return new ElementID(false, nArray);
    }

    @Nonnull
    public String toString() {
        if (this.idLevels.length == 1) {
            return Integer.toString(this.idLevels[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.idLevels) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public static ElementID valueOf(String value) {
        @Nonnull String @Nonnull [] stringArray = value.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return new ElementID(false, nArray);
    }

    static {
        ElementID.DUMMY.idLevels = new int[]{0};
    }
}

