/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.DrawableElement;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@InternalApi
public class Clip
implements Serializable {
    private final Rectangle2D bounds;
    private final List<DrawableElement> fo;

    public Clip(Rectangle2D bounds, List<DrawableElement> elements) {
        this.bounds = bounds;
        this.fo = elements == null ? new ArrayList<DrawableElement>() : elements;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public List<DrawableElement> getElements() {
        return this.fo;
    }

    public void addElement(DrawableElement element) {
        this.fo.add(element);
    }

    public int getElementCount() {
        return this.fo.size();
    }

    public void addAll(Collection<? extends DrawableElement> elements) {
        for (DrawableElement drawableElement : elements) {
            if (this.fo.contains(drawableElement)) continue;
            this.addElement(drawableElement);
        }
    }

    public String toString() {
        return "PFFClip@" + String.valueOf(this.bounds);
    }
}

