/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.JsonData;
import com.inet.cache.InetSerializable;
import com.inet.cache.MemorySize;
import com.inet.pdfc.generator.rendercache.TextSelectionSerializer;
import com.inet.pdfc.textselection.TextInfoImpl;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class TextSelectionData
implements InetSerializable<TextSelectionData, TextSelectionSerializer>,
MemorySize,
Serializable {
    private static final TextSelectionSerializer SERIALIZER = new TextSelectionSerializer();
    private List<TextInfoImpl> data;
    private transient int memSize;

    public TextSelectionData() {
    }

    public TextSelectionData(@Nonnull List<TextInfoImpl> data) {
        this.data = data;
    }

    @Nonnull
    public List<TextInfoImpl> getData() {
        return this.data;
    }

    public TextSelectionSerializer getSerializer() {
        return SERIALIZER;
    }

    public long getSizeInMemory() {
        if (this.memSize > 0) {
            return this.memSize;
        }
        try {
            int n = 1;
            for (TextInfoImpl textInfoImpl : this.data) {
                n += 40;
                n += textInfoImpl.getLabel().length() * 6;
                n += textInfoImpl.getAreas().size() * 32;
                n += textInfoImpl.getFontname().length() * 2;
            }
            this.memSize = n;
            return n;
        }
        catch (Exception exception) {
            return this.data.size() * 800;
        }
    }
}

