/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.text;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.generator.model.text.c;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementList;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.ocr.LanguageManager;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.Pair;
import com.inet.pdfc.util.RattleSort;
import com.inet.pdfc.util.Sample;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class TextModuleUtils {
    public static final char SUMMARIZE = '\uefff';
    public static final String PROPERTY_NO_BREAK_ITERATOR = "filter.nobreakiterator";
    public static final String USE_STRICT_Y_COMPARE_FOR_TEXT_SORT = "useStrictYCompareForTextSort";
    private static final boolean gk = "true".equalsIgnoreCase(System.getProperty("useStrictYCompareForTextSort"));
    public static final double MAXIMUM_CONCAT_RATIO = 0.8;
    public static final double MAXIMUM_NEGATIVE_CONCAT_RATIO = 0.765;
    public static final double FONT_JOIN_RATIO = 0.9;
    private static final boolean gl = Boolean.valueOf(System.getProperty("allowmissingchar", "true"));
    private static final boolean gm = Boolean.valueOf(System.getProperty("allowzerochar", "false"));
    private static final boolean gn = gm && !gl;
    public static final Comparator<DrawableElement> YX_COMPARATOR = (drawableElement, drawableElement2) -> {
        double d2 = drawableElement.getX();
        double d3 = drawableElement.getY();
        double d4 = drawableElement2.getX();
        double d5 = drawableElement2.getY();
        return Math.abs(d3 - d5) <= 5.0E-6 ? Double.compare(d2, d4) : Double.compare(d3, d5);
    };

    public static ArrayList<TextElement> getPDFTextList(Page page) {
        ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
        ElementList elementList = page.getElementList();
        if (elementList != null) {
            elementList.getListOfVisibleElements().stream().filter(drawableElement -> drawableElement instanceof TextElement).map(drawableElement -> (TextElement)drawableElement).forEach(textElement -> arrayList.add((TextElement)textElement));
        }
        return arrayList;
    }

    public static LinkedList<WordElement> splitTextElement(TextElement pdfText, String context, int contentOffset, TextStyle style, boolean useBreakIterator, String language) {
        boolean bl;
        AffineTransform affineTransform = new AffineTransform(pdfText.getTransformMatrix());
        boolean bl2 = bl = affineTransform.getScaleX() == 1.0 && affineTransform.getShearX() == 0.0 && affineTransform.getScaleY() == -1.0 && affineTransform.getShearY() == 0.0;
        if (pdfText.getClip() == null) {
            return TextModuleUtils.a(pdfText, style, context, contentOffset, affineTransform, bl, useBreakIterator, language);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<TextElement> list = TextModuleUtils.clipText(pdfText, pdfText.getClip(), arrayList);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return TextModuleUtils.a(list.get(0), style, context, contentOffset += ((Integer)arrayList.get(0)).intValue(), affineTransform, bl, useBreakIterator, language);
        }
        LinkedList<WordElement> linkedList = new LinkedList<WordElement>();
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)arrayList.get(i);
            linkedList.addAll(TextModuleUtils.a(list.get(i), style, context, contentOffset + n, affineTransform, bl, useBreakIterator, language));
        }
        return linkedList;
    }

    public static List<TextElement> clipText(TextElement text, Shape clip, List<Integer> offsetData) {
        ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
        if (clip == null) {
            TextModuleUtils.a(offsetData, 0);
            arrayList.add(text);
            return arrayList;
        }
        Rectangle2D rectangle2D = LocationUtils.getNormedBounds(text);
        if (clip.contains(rectangle2D = LocationUtils.resize(rectangle2D, -text.getStyle().getWsWidthScaled() / 4.0))) {
            TextModuleUtils.a(offsetData, 0);
            arrayList.add(text);
            return arrayList;
        }
        if (!clip.intersects(rectangle2D)) {
            return arrayList;
        }
        Area area = new Area(clip);
        double[] dArray = text.getCharacterWidths();
        double[] dArray2 = text.getKerningArray();
        AffineTransform affineTransform = new AffineTransform(text.getTransformMatrix());
        boolean bl = affineTransform.getScaleX() == 1.0 && affineTransform.getShearX() == 0.0 && affineTransform.getScaleY() == -1.0 && affineTransform.getShearY() == 0.0;
        double d2 = 0.0;
        double d3 = text.getTextHeight();
        int n = -1;
        for (int i = 0; i < dArray.length; ++i) {
            Shape shape;
            if (dArray2 != null) {
                d2 += dArray2[i];
            }
            double d4 = dArray[i] - (dArray2 != null ? dArray2[i] : 0.0);
            if (bl) {
                shape = new Rectangle2D.Double(affineTransform.getTranslateX() + d2, affineTransform.getTranslateY() - d3, d4, d3);
            } else {
                shape = new Rectangle2D.Double(d2, 0.0, d4, d3);
                shape = affineTransform.createTransformedShape(shape);
            }
            d2 += d4;
            boolean bl2 = TextModuleUtils.a(shape, clip, area);
            if (bl2) {
                if (n >= 0) continue;
                n = i;
                continue;
            }
            if (n >= 0) {
                arrayList.add(text.subText(n, i));
                TextModuleUtils.a(offsetData, n);
            }
            n = -1;
        }
        if (n == 0) {
            TextModuleUtils.a(offsetData, 0);
            arrayList.add(text);
        } else if (n > 0) {
            TextModuleUtils.a(offsetData, n);
            arrayList.add(text.subText(n, dArray.length));
        }
        return arrayList;
    }

    private static void a(List<Integer> list, int n) {
        if (list != null) {
            list.add(n);
        }
    }

    private static boolean a(Shape shape, Shape shape2, Area area) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (shape2.contains(rectangle2D)) {
            return true;
        }
        if (!shape2.intersects(rectangle2D)) {
            return false;
        }
        double d2 = LocationUtils.getSize(rectangle2D);
        Area area2 = new Area(shape);
        area2.intersect(area);
        double d3 = LocationUtils.getSize(area2.getBounds2D());
        return d3 * 2.0 > d2;
    }

    public static LinkedList<WordElement> splitTextElement(TextElement pdfText, TextStyle style, boolean useBreakIterator, String language) {
        return TextModuleUtils.splitTextElement(pdfText, pdfText.getText(), 0, style, useBreakIterator, language);
    }

    private static String q(String string) {
        return string == null ? null : string.replace('\u2019', '\'').replace('\u02bc', '\'');
    }

    private static double[] a(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, n2, dArray2, 0, dArray2.length);
        dArray = dArray2;
        return dArray;
    }

    public static List<TextElement> splitByKerning(TextElement pdfText) {
        TextElement textElement;
        if (pdfText.getText().contains(" ")) {
            return null;
        }
        double d2 = 0.0;
        String string = pdfText.getText();
        int n = string.length();
        double[] dArray = pdfText.getKerningArray();
        double[] dArray2 = pdfText.getCharacterWidths();
        if (dArray == null || dArray2.length < 2) {
            return null;
        }
        double d3 = pdfText.getStyle().getActualSpaceWidth();
        double d4 = !Double.isNaN(d3) ? d3 : pdfText.getStyle().getWsWidth();
        ArrayList<TextElement> arrayList = null;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            TextElement textElement2;
            d2 = dArray[i];
            if (!(d2 > d4)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TextElement>(2);
            }
            if (!(textElement2 = pdfText.subText(n2, i)).getText().trim().isEmpty()) {
                arrayList.add(textElement2);
            }
            n2 = i;
        }
        if (arrayList != null && !(textElement = pdfText.subText(n2, n)).getText().trim().isEmpty()) {
            arrayList.add(textElement);
        }
        return arrayList;
    }

    private static boolean r(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).contains("chinese") || string.equalsIgnoreCase("japanese");
    }

    public static boolean isSymbolicLanguage(boolean first) {
        return TextModuleUtils.r(LanguageManager.getInstance().getLanguage(first).getCountry());
    }

    private static BreakIterator a(String string, boolean bl) {
        BreakIterator breakIterator;
        BreakIterator breakIterator2 = breakIterator = TextModuleUtils.r(string) ? new com.inet.pdfc.generator.model.text.a() : BreakIterator.getWordInstance();
        if (gn && bl) {
            breakIterator = com.inet.pdfc.generator.model.text.b.a(breakIterator);
        }
        if (gl) {
            breakIterator = new com.inet.pdfc.generator.model.text.b(breakIterator){

                @Override
                public void setText(@Nonnull String newText) {
                    String string = newText.replace('\ufffe', gj);
                    this.gi.setText(string);
                }
            };
        }
        return breakIterator;
    }

    @Nonnull
    private static LinkedList<WordElement> a(TextElement textElement, TextStyle textStyle, String string, int n, AffineTransform affineTransform, boolean bl, boolean bl2, String string2) {
        boolean bl3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        LinkedList<WordElement> linkedList = new LinkedList<WordElement>();
        double d2 = textElement.getTextHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n7 = textElement.getText().length();
        double[] dArray = textElement.getCharacterWidths();
        double[] dArray2 = textElement.getKerningArray();
        StringBuilder stringBuilder = new StringBuilder();
        a a2 = bl2 ? TextModuleUtils.a(string2, string.indexOf(0) != -1) : new a();
        double[] dArray3 = new double[6];
        affineTransform.getMatrix(dArray3);
        if (Math.abs(dArray3[0]) == Math.abs(dArray3[3]) && dArray3[1] == 0.0 && dArray3[2] != 0.0) {
            dArray3[2] = 0.0;
            affineTransform = new AffineTransform(dArray3);
        }
        int n8 = 32;
        int n9 = 32;
        double d6 = textStyle.getWsWidth();
        boolean bl4 = Double.isNaN(textStyle.getActualSpaceWidth());
        LinkedList<Integer> linkedList2 = null;
        int n10 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            int n11;
            n5 = string.charAt(n6 + n);
            if (dArray2 != null) {
                d4 = dArray2[n6];
            }
            n4 = n11 = Character.isWhitespace((char)n5) || n5 == 160 || n5 == 8199 || n5 == 8239 || n5 == 8203 ? 1 : 0;
            if (n11 == 0) {
                n3 = Character.getType((char)n8);
                n2 = Character.getType((char)n5);
                bl3 = n2 >= 1 && n2 <= 5;
                n4 = n10 == 0 && (d4 * 1.1 > d6 / 2.0 && n3 == 24 && bl3 || n2 != 6 && bl4 && d4 > d6 * 0.8) ? 1 : 0;
            }
            n10 = n11;
            n3 = n9 == 46 && n8 == 46 && n5 != 46 ? 1 : 0;
            n9 = n8;
            n8 = n5;
            if (n11 != 0 && dArray[n6] <= 0.0 && n3 == 0 || n4 == 0 && n3 == 0) continue;
            if (linkedList2 == null) {
                linkedList2 = new LinkedList<Integer>();
            }
            linkedList2.add(n6);
        }
        n6 = -1;
        n5 = n;
        n8 = 32;
        String string3 = TextModuleUtils.q(string);
        if (linkedList2 != null) {
            n6 = (Integer)linkedList2.poll();
            ((BreakIterator)a2).setText(string3.substring(0, n6 + n));
        } else {
            ((BreakIterator)a2).setText(string3);
        }
        n4 = ((BreakIterator)a2).following(n) - n;
        for (n3 = 0; n3 < n7; ++n3) {
            Object object;
            boolean bl5;
            n2 = string.charAt(n3 + n);
            if (dArray2 != null) {
                d4 = dArray2[n3];
            }
            bl3 = n3 == n4;
            boolean bl6 = bl5 = n3 == n6;
            if (bl3) {
                n4 = ((BreakIterator)a2).next() - n5;
                if (n8 == n2 && !Character.isLetterOrDigit((char)n2)) {
                    bl3 = false;
                }
            }
            if (bl5) {
                n5 = -n6;
                n6 = linkedList2 == null || linkedList2.isEmpty() ? string.length() - n : (Integer)linkedList2.poll();
                object = string3.substring(n - n5, n6 + n);
                ((BreakIterator)a2).setText((String)object);
                n4 = ((BreakIterator)a2).next() - n5;
            }
            if (bl3 || bl5) {
                if (stringBuilder.length() != 0) {
                    Point2D.Double double_;
                    if (bl) {
                        object = new Rectangle2D.Double(affineTransform.getTranslateX() + d5, affineTransform.getTranslateY(), d3, -d2);
                        double_ = new Point2D.Double(((Rectangle2D.Double)object).getX(), ((Rectangle2D.Double)object).getY());
                    } else {
                        d3 = d3 < 0.0 ? 0.0 : d3;
                        object = LocationUtils.createTransformedBounds(affineTransform, new Rectangle2D.Double(d5, 0.0, d3, d2));
                        double_ = new Point2D.Double(d5, 0.0);
                        affineTransform.transform(double_, double_);
                        if (Math.abs(affineTransform.getTranslateY() - ((Rectangle2D.Double)object).getY()) > 0.5) {
                            object = new Rectangle2D.Double(((Rectangle2D.Double)object).getX(), ((Rectangle2D.Double)object).getY() + ((Rectangle2D.Double)object).getHeight(), ((Rectangle2D.Double)object).getWidth(), -((Rectangle2D.Double)object).getHeight());
                        }
                    }
                    d5 += d3;
                    String string4 = stringBuilder.toString();
                    if (TextModuleUtils.getTrimLength(string4) > 0) {
                        WordElement wordElement = TextModuleUtils.a(textElement, n3, dArray, dArray2, affineTransform, bl, string4, (Rectangle2D.Double)object, double_, textStyle);
                        linkedList.add(wordElement);
                    }
                    stringBuilder.setLength(0);
                }
                if (!Character.isWhitespace((char)n2) && n2 != 160 && n2 != 8199 && n2 != 8239 && n2 != 8203) {
                    d3 = dArray[n3] - d4;
                    d5 += d4;
                    stringBuilder.append((char)n2);
                } else {
                    d3 = 0.0;
                    d5 += dArray[n3];
                }
            } else {
                if (n3 < dArray.length) {
                    d3 += dArray[n3];
                }
                if (stringBuilder.length() == 0) {
                    d5 += d4;
                    d3 -= d4;
                }
                stringBuilder.append((char)n2);
            }
            n8 = n2;
        }
        if (stringBuilder.length() > 0) {
            Point2D.Double double_;
            Rectangle2D.Double double_2;
            if (bl) {
                double_2 = new Rectangle2D.Double(affineTransform.getTranslateX() + d5, affineTransform.getTranslateY(), d3, -d2);
                double_ = new Point2D.Double(double_2.getX(), double_2.getY());
            } else {
                double_2 = LocationUtils.createTransformedBounds(affineTransform, new Rectangle2D.Double(d5, 0.0, d3, d2));
                double_ = new Point2D.Double(d5, 0.0);
                affineTransform.transform(double_, double_);
                if (Math.abs(affineTransform.getTranslateY() - double_2.getY()) > 0.5) {
                    double_2 = new Rectangle2D.Double(double_2.getX(), double_2.getY() + double_2.getHeight(), double_2.getWidth(), -double_2.getHeight());
                }
            }
            String string5 = stringBuilder.toString();
            if (TextModuleUtils.getTrimLength(string5) > 0) {
                WordElement wordElement = TextModuleUtils.a(textElement, n7, dArray, dArray2, affineTransform, bl, string5, double_2, double_, textStyle);
                linkedList.add(wordElement);
            }
        }
        return linkedList;
    }

    @Nonnull
    private static WordElement a(TextElement textElement, int n, double @Nonnull [] dArray, double[] dArray2, AffineTransform affineTransform, boolean bl, String string, @Nonnull @Nonnull @Nonnull Rectangle2D.Double double_, Point2D point2D, TextStyle textStyle) {
        Object object;
        double d2;
        double[] dArray3 = TextModuleUtils.a(dArray, string.length(), n - string.length());
        double d3 = d2 = dArray2 == null ? 0.0 : dArray2[n - string.length()];
        if (d2 != 0.0) {
            dArray3[0] = dArray3[0] - d2;
        }
        if (!bl) {
            int n2;
            object = new double[dArray3.length * 2];
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                object[n2 * 2] = dArray3[n2];
            }
            AffineTransform.getScaleInstance(affineTransform.getScaleX() + affineTransform.getShearX(), affineTransform.getScaleY() + affineTransform.getShearY()).transform((double[])object, 0, (double[])object, 0, dArray3.length);
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                dArray3[n2] = (double)object[n2 * 2];
            }
        }
        object = new WordElement(string, double_, dArray3, textElement.getPageIndex(), textStyle, textElement.getElementID().getDescendant(n));
        ((WordElement)object).setStartPointX(point2D);
        return object;
    }

    public static TextStyle getStyle(TextElement pdfText) {
        return new TextStyle(pdfText, 0.8);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int convertText(int pos, List<? extends DrawableElement> inputList, List<DrawableElement> output, StyleState state, String language, boolean useBreakIterator) {
        DrawableElement drawableElement;
        int n;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        LinkedList<WordElement> linkedList;
        LinkedList<WordElement> linkedList2;
        Serializable serializable;
        int n2 = pos;
        int n3 = 0;
        Object object4 = new b((TextElement)inputList.get(n2++));
        while (TextModuleUtils.m(((b)object4).gs) && n2 < inputList.size()) {
            ++n3;
            if (!((serializable = inputList.get(n2++)) instanceof TextElement)) {
                return n3;
            }
            object4 = new b((TextElement)serializable);
        }
        serializable = null;
        boolean bl2 = false;
        block1: while (n2 < inputList.size()) {
            block49: {
                block50: {
                    block52: {
                        block58: {
                            String string;
                            char c2;
                            String string2;
                            int n4;
                            double d2;
                            reference var30_48;
                            double d3;
                            Object object5;
                            double d4;
                            block56: {
                                TextElement textElement;
                                block57: {
                                    int n5;
                                    int n6;
                                    block55: {
                                        block54: {
                                            block53: {
                                                block51: {
                                                    linkedList2 = inputList.get(n2);
                                                    if (!(linkedList2 instanceof TextElement)) break block50;
                                                    linkedList = new b((TextElement)((Object)linkedList2));
                                                    if (!TextModuleUtils.a((b)object4, (b)((Object)linkedList))) {
                                                        if (serializable != null) break;
                                                        LinkedList<WordElement> linkedList3 = TextModuleUtils.splitTextElement(((b)object4).gs, ((b)object4).style, useBreakIterator, language);
                                                        if (linkedList3 != null) {
                                                            output.addAll(linkedList3);
                                                        }
                                                        if (state != null) {
                                                            state.style = ((b)object4).style;
                                                        }
                                                        return 1 + n3;
                                                    }
                                                    if (!TextModuleUtils.b((b)object4, linkedList, false)) break block51;
                                                    if (bl2 && serializable != null && TextModuleUtils.a((b)serializable.get(serializable.size() - 2), linkedList, true)) {
                                                        serializable.remove(serializable.size() - 1);
                                                        ++n3;
                                                    }
                                                    if (serializable == null) {
                                                        serializable = new ArrayList();
                                                        serializable.add(object4);
                                                    }
                                                    break block52;
                                                }
                                                if (!bl2 || serializable == null || !TextModuleUtils.a((b)serializable.get(serializable.size() - 2), linkedList, false)) break block53;
                                                serializable.remove(serializable.size() - 1);
                                                ++n3;
                                                break block52;
                                            }
                                            n6 = TextModuleUtils.getTrimLength(((b)((Object)linkedList)).gs.getText());
                                            if (n6 != 0 && !"\u00ad".equals(((b)((Object)linkedList)).gs.getText()) && !"\uefff".equals(((b)((Object)linkedList)).gs.getText())) break block54;
                                            ++n3;
                                            break block49;
                                        }
                                        n5 = TextModuleUtils.getTrimLength(((b)object4).gs.getText());
                                        if (n5 != 0 || !(((Point2D)(object3 = TextModuleUtils.c(((b)object4).gs))).distance((Point2D)(object2 = TextModuleUtils.c(((b)((Object)linkedList)).gs))) < ((b)object4).style.getWsWidthScaled() / 4.0)) break block55;
                                        if (serializable == null) {
                                            serializable = new ArrayList();
                                        } else if (serializable.size() >= 2 && !"\u00ad".equals(((b)object4).gs.getText()) && !TextModuleUtils.a((b)serializable.get(serializable.size() - 2), (b)((Object)linkedList), false)) break;
                                        if (serializable.size() > 0) {
                                            serializable.set(serializable.size() - 1, linkedList);
                                        } else {
                                            serializable.add(linkedList);
                                        }
                                        bl2 = false;
                                        object4 = linkedList;
                                        ++n3;
                                        break block49;
                                    }
                                    object3 = TextModuleUtils.a(((b)object4).gs, false);
                                    object2 = TextModuleUtils.c(((b)((Object)linkedList)).gs);
                                    d4 = Math.abs(((Point2D)object3).getY() - ((Point2D)object2).getY());
                                    if (!(((Point2D)object2).getX() < ((Point2D)object3).getX()) || !(d4 < 1.0) || n5 == ((b)object4).gs.getText().length() && n6 == ((b)((Object)linkedList)).gs.getText().length()) break block56;
                                    int n7 = ((b)object4).gs.getText().length();
                                    int n8 = ((b)((Object)linkedList)).gs.getText().length();
                                    object = ((b)object4).gs;
                                    textElement = ((b)((Object)linkedList)).gs;
                                    object5 = TextModuleUtils.b(((b)object4).gs, false);
                                    TextElement textElement2 = TextModuleUtils.b(((b)((Object)linkedList)).gs, true);
                                    ((b)object4).gs = object5;
                                    ((b)((Object)linkedList)).gs = textElement2;
                                    object3 = TextModuleUtils.a(((b)object4).gs, false);
                                    object2 = TextModuleUtils.c(((b)((Object)linkedList)).gs);
                                    boolean bl3 = bl = n7 != ((b)object4).gs.getText().length() || n8 != ((b)((Object)linkedList)).gs.getText().length();
                                    if (!bl || !TextModuleUtils.a((b)object4, (b)((Object)linkedList), bl)) break block57;
                                    if (bl2 && serializable != null && TextModuleUtils.a((b)serializable.get(serializable.size() - 2), (b)((Object)linkedList), bl)) {
                                        serializable.remove(serializable.size() - 1);
                                        ++n3;
                                    }
                                    if (serializable == null) {
                                        serializable = new ArrayList();
                                        serializable.add(object4);
                                    }
                                    bl2 = TextModuleUtils.a((b)((Object)linkedList));
                                    serializable.add(linkedList);
                                    object4 = linkedList;
                                    break block49;
                                }
                                ((b)object4).gs = object;
                                ((b)((Object)linkedList)).gs = textElement;
                            }
                            if (!(((Point2D)object2).getX() < ((Point2D)object3).getX()) || !(d4 < 1.0)) break block58;
                            double d5 = ((Point2D)object3).getX() - ((Point2D)object2).getX();
                            object = ((b)object4).gs.getCharacterWidths();
                            int n9 = ((Object)object).length - 1;
                            object5 = TextModuleUtils.a(((b)((Object)linkedList)).gs, false);
                            if (((Point2D)object5).getX() < ((Point2D)object3).getX()) {
                                double d6 = ((Point2D)object3).getX() - ((Point2D)object5).getX();
                                d5 -= d6;
                                for (n9 = ((Object)object).length - 1; n9 >= 0; d6 -= d3, --n9) {
                                    d3 = (double)object[n9];
                                    if (d6 > d3 * 0.54) {
                                        continue;
                                    }
                                    if (!(Math.abs(d6) < d3 * 0.45999999999999996)) break block1;
                                }
                            }
                            double d7 = ((b)object4).gs.getScale();
                            d3 = d5;
                            n = 0;
                            for (int i = n9; i >= 0 && d3 > (var30_48 = object[i] * d7) * 0.54; d3 -= var30_48, ++n, --i) {
                            }
                            d7 = ((b)((Object)linkedList)).gs.getScale();
                            double d8 = d5;
                            int n10 = 0;
                            double[] dArray = ((b)((Object)linkedList)).gs.getCharacterWidths();
                            for (n4 = 0; n4 < dArray.length && d8 > (d2 = dArray[n4] * d7) * 0.54; d8 -= d2, ++n10, ++n4) {
                            }
                            if (n <= 0 || n != n10 || !((b)object4).style.isSimilar(((b)((Object)linkedList)).style)) break block58;
                            n4 = ((b)object4).gs.getText().length() - n9 - 1;
                            String string3 = ((b)object4).gs.getText().substring(((b)object4).gs.getText().length() - n - n4, ((b)object4).gs.getText().length() - n4);
                            boolean bl4 = string3.equals(string2 = ((b)((Object)linkedList)).gs.getText().substring(0, n));
                            if (!bl4 && string3.length() == 1 && string2.length() == 1 && n4 == ((b)object4).gs.getText().length() - 1 && c.c(c2 = string2.charAt(0)) && (string = Normalizer.normalize(string3 + (c2 = c.d(c2)), Normalizer.Form.NFC)).length() == 1) {
                                ((b)object4).gs.setText(string + ((b)object4).gs.getText().substring(1));
                                bl4 = true;
                            }
                            if (!bl4) break block58;
                            if (n == ((b)object4).gs.getText().length()) {
                                ++n3;
                                if (serializable != null && serializable.size() > 0) {
                                    serializable.remove(serializable.size() - 1);
                                }
                                if (serializable == null) {
                                    serializable = new ArrayList();
                                }
                                serializable.add(linkedList);
                                object4 = linkedList;
                                break block49;
                            } else if (n == ((b)((Object)linkedList)).gs.getText().length()) {
                                ++n3;
                                break block49;
                            } else {
                                if (serializable == null) {
                                    serializable = new ArrayList();
                                    serializable.add(object4);
                                }
                                TextElement textElement = ((b)((Object)linkedList)).gs;
                                string = textElement.getText().substring(n, textElement.getText().length());
                                double[] dArray2 = Arrays.copyOfRange(textElement.getCharacterWidths(), n, textElement.getCharacterWidths().length);
                                double[] dArray3 = textElement.getKerningArray() == null ? null : Arrays.copyOfRange(textElement.getKerningArray(), n, textElement.getKerningArray().length);
                                AffineTransform affineTransform = new AffineTransform(textElement.getTransformMatrix());
                                affineTransform.translate(d5 - d8, 0.0);
                                dArray2[0] = dArray2[0] - d8;
                                TextElement textElement3 = TextModuleUtils.a(textElement, string, dArray2, dArray3, affineTransform);
                                linkedList = new b(textElement3);
                                bl2 = TextModuleUtils.a((b)((Object)linkedList));
                                serializable.add(linkedList);
                                object4 = linkedList;
                            }
                            break block49;
                        }
                        if (serializable != null) break;
                        LinkedList<WordElement> linkedList4 = TextModuleUtils.splitTextElement(((b)object4).gs, ((b)object4).style, useBreakIterator, language);
                        if (linkedList4 != null) {
                            output.addAll(linkedList4);
                        }
                        if (state != null) {
                            state.style = ((b)object4).style;
                        }
                        return 1 + n3;
                    }
                    bl2 = TextModuleUtils.a(linkedList);
                    serializable.add(linkedList);
                    object4 = linkedList;
                    break block49;
                }
                if (linkedList2 instanceof ShapeElement && ((ShapeElement)((Object)linkedList2)).getIsClip()) {
                    ++n3;
                } else {
                    if (serializable != null) break;
                    linkedList = TextModuleUtils.splitTextElement(((b)object4).gs, ((b)object4).style, useBreakIterator, language);
                    if (linkedList != null) {
                        output.addAll(linkedList);
                    }
                    if (state != null) {
                        state.style = ((b)object4).style;
                    }
                    return 1 + n3;
                }
            }
            ++n2;
        }
        if (serializable == null) {
            linkedList2 = TextModuleUtils.splitTextElement(((b)object4).gs, ((b)object4).style, useBreakIterator, language);
            if (linkedList2 != null) {
                output.addAll((Collection<DrawableElement>)linkedList2);
            }
            if (state != null) {
                state.style = ((b)object4).style;
            }
            return 1 + n3;
        }
        if (bl2 && serializable.size() > 1) {
            linkedList2 = (b)serializable.get(serializable.size() - 2);
            if (((b)((Object)linkedList2)).gs.getText().endsWith("-")) {
                serializable.remove(serializable.size() - 1);
                ++n3;
            }
        }
        linkedList2 = new StringBuilder();
        linkedList = serializable.iterator();
        while (linkedList.hasNext()) {
            b b2 = (b)linkedList.next();
            ((StringBuilder)((Object)linkedList2)).append(b2.gs.getText());
        }
        linkedList = null;
        if (((StringBuilder)((Object)linkedList2)).length() > 0 && ((StringBuilder)((Object)linkedList2)).charAt(((StringBuilder)((Object)linkedList2)).length() - 1) == '\uefff' && n2 < inputList.size() && (drawableElement = inputList.get(n2)) instanceof TextElement) {
            linkedList = ((b)object4).gs;
            ((StringBuilder)((Object)linkedList2)).replace(((StringBuilder)((Object)linkedList2)).length() - 1, ((StringBuilder)((Object)linkedList2)).length(), "");
            ((StringBuilder)((Object)linkedList2)).append(((TextElement)drawableElement).getText());
            serializable.remove(serializable.size() - 1);
        }
        String string = ((StringBuilder)((Object)linkedList2)).toString();
        BreakIterator breakIterator = useBreakIterator ? BreakIterator.getWordInstance() : new a();
        breakIterator.setText(TextModuleUtils.q(string));
        object3 = null;
        object2 = state != null ? state.style : null;
        int n11 = 0;
        Object object6 = serializable.iterator();
        while (object6.hasNext()) {
            LinkedList<WordElement> linkedList5;
            b b3 = (b)object6.next();
            if (object2 == null || !((TextStyle)object2).equalsWithColors(b3.style)) {
                object2 = b3.style;
            }
            if ((linkedList5 = TextModuleUtils.splitTextElement(b3.gs, string, n11, (TextStyle)object2, useBreakIterator, language)) == null || linkedList5.isEmpty()) {
                n11 += b3.gs.getText().length();
                object3 = null;
                continue;
            }
            if (object3 != null) {
                boolean bl5;
                boolean bl6;
                object = linkedList5.getFirst();
                int n12 = n11 >= 2 ? (int)string.charAt(n11 - 2) : 32;
                char c3 = string.charAt(n11 - 1);
                char c4 = string.charAt(n11);
                bl = c3 == c4 && !Character.isLetterOrDigit(c4);
                boolean bl7 = bl6 = n12 == 46 && c3 == '.' && c4 != '.';
                if (bl) {
                    bl5 = Character.isWhitespace(c4);
                    bl &= !bl5;
                    bl6 = bl5;
                }
                bl5 = !Character.isWhitespace(c3) && !Character.isWhitespace(c4);
                int n13 = n = !useBreakIterator || c4 == '\ufffe' || c3 == '\ufffe' || !breakIterator.isBoundary(n11) ? 1 : 0;
                if ((bl5 && n != 0 || bl) && !bl6) {
                    linkedList5.removeFirst();
                    ((WordElement)object3).append((WordElement)object);
                }
            }
            n11 += b3.gs.getText().length();
            if (!linkedList5.isEmpty()) {
                object3 = linkedList5.getLast();
            }
            output.addAll(linkedList5);
        }
        if (linkedList != null) {
            object6 = new WordElement(((TextElement)((Object)linkedList)).getText(), (Rectangle2D.Double)((TextElement)((Object)linkedList)).getBounds(), ((TextElement)((Object)linkedList)).getCharacterWidths(), ((DrawableElement)((Object)linkedList)).getPageIndex(), (TextStyle)object2, ((DrawableElement)((Object)linkedList)).getElementID().getDescendant());
            output.add((DrawableElement)object6);
            ++n3;
        }
        if (state != null) {
            state.style = object2;
        }
        return serializable.size() + n3;
    }

    private static TextElement a(TextElement textElement, String string, double[] dArray, double[] dArray2, AffineTransform affineTransform) {
        double d2 = Math.sqrt(affineTransform.getScaleX() * affineTransform.getScaleX() + affineTransform.getShearY() * affineTransform.getShearY());
        TextElement textElement2 = new TextElement(textElement.getFontInfo(), textElement.getFontSize() / (float)d2, affineTransform, string, textElement.getFillPaint(), textElement.getStrokePaint(), dArray, dArray2, false, textElement.getElementID());
        textElement2.setPageIndex(textElement.getPageIndex());
        return textElement2;
    }

    private static boolean a(b b2) {
        return "\u00ad".equals(b2.gs.getText()) || "\uefff".equals(b2.gs.getText()) || TextModuleUtils.getTrimLength(b2.gs.getText()) == 0;
    }

    private static void b(b b2) {
        double d2;
        int n;
        TextElement textElement = b2.gs;
        double d3 = b2.style.getWsWidth();
        if (d3 == 0.0) {
            return;
        }
        double[] dArray = textElement.getKerningArray();
        double[] dArray2 = textElement.getCharacterWidths();
        String string = textElement.getLabel();
        if (dArray == null) {
            int n2 = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (!TextModuleUtils.isWhitespace(string.charAt(i)) || !(dArray2[i] <= 0.0)) continue;
                ++n2;
            }
            if (n2 > 0) {
                double[] dArray3 = new double[dArray2.length - n2];
                StringBuilder stringBuilder = new StringBuilder(string.length() - n2);
                int n3 = 0;
                for (int i = 0; i < dArray2.length; ++i) {
                    if (TextModuleUtils.isWhitespace(string.charAt(i)) && dArray2[i] <= 0.0) continue;
                    dArray3[n3] = dArray2[i];
                    stringBuilder.append(string.charAt(i));
                    ++n3;
                }
                textElement.setCharWidths(dArray3);
                textElement.setText(stringBuilder.toString());
            }
            return;
        }
        if (dArray.length != dArray2.length) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < dArray2.length; ++n) {
            double d4;
            double d5;
            boolean bl = TextModuleUtils.isWhitespace(string.charAt(n));
            double d6 = d5 = n < dArray.length - 1 ? dArray[n + 1] : 0.0;
            if (bl && d5 < 0.0 && dArray2[n] + d5 < d3 * 0.15) {
                ++n5;
                continue;
            }
            if (n < dArray.length - 1 && d5 < 0.0 && string.charAt(n) == string.charAt(n + 1) && -d5 > (d4 = dArray2[n]) * 0.9 && -d5 < d4 * 1.1) {
                ++n5;
                continue;
            }
            if (dArray[n] * 1.1 > d3 && !bl && dArray2[n] - dArray[n] > d3 * 0.8) {
                ++n4;
                if (n != 0) continue;
                ++n5;
                continue;
            }
            if (!bl || !(dArray2[n] <= 0.0)) continue;
            if (d5 >= d3 / 2.0 && n < dArray2.length - 1) {
                int n6 = n;
                dArray2[n6] = dArray2[n6] + d5;
                int n7 = n + 1;
                dArray2[n7] = dArray2[n7] - d5;
                dArray[n + 1] = 0.0;
                continue;
            }
            ++n5;
        }
        if (n4 == 0 && n5 == 0) {
            return;
        }
        n = n4 - n5;
        double[] dArray4 = new double[dArray.length + n];
        double[] dArray5 = new double[dArray2.length + n];
        if (dArray4.length == 0 && dArray5.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + n);
        int n8 = 0;
        boolean bl = false;
        for (int i = 0; i < dArray2.length; ++i) {
            double d7;
            char c2 = string.charAt(i);
            boolean bl2 = TextModuleUtils.isWhitespace(c2);
            double d8 = dArray2[i];
            double d9 = dArray[i];
            double d10 = d7 = i < dArray.length - 1 ? dArray[i + 1] : 0.0;
            if (bl2 && d7 < 0.0 && d8 + d7 < d3 * 0.15) {
                if (n8 < dArray5.length) {
                    int n9 = n8;
                    dArray4[n9] = dArray4[n9] + (d8 + d7);
                    int n10 = n8;
                    dArray5[n10] = dArray5[n10] + d8;
                    if (i + 1 >= dArray.length) continue;
                    dArray[i + 1] = 0.0;
                    continue;
                }
                if (n8 <= 0) continue;
                int n11 = n8 - 1;
                dArray4[n11] = dArray4[n11] + (d8 + d7);
                int n12 = n8 - 1;
                dArray5[n12] = dArray5[n12] + (d8 + d7);
                if (i >= dArray.length + 1) continue;
                dArray[i + 1] = 0.0;
                continue;
            }
            if (i < dArray.length - 1 && d7 < 0.0 && c2 == string.charAt(i + 1) && -d7 > d8 * 0.9 && -d7 < d8 * 1.1) {
                dArray4[n8] = d9;
                int n13 = n8;
                dArray5[n13] = dArray5[n13] + d8;
                if (i >= dArray.length + 1) continue;
                dArray[i + 1] = 0.0;
                continue;
            }
            if (d9 * 1.1 > d3 && !bl2 && dArray2[i] - dArray[i] > d3 * 0.8) {
                if (i == 0) {
                    bl = true;
                    TextModuleUtils.offsetTextStart(textElement, d9);
                    dArray5[n8++] = d8 - d9;
                    stringBuilder.append(c2);
                    continue;
                }
                int n14 = n8++;
                dArray5[n14] = dArray5[n14] + d9;
                int n15 = n8++;
                dArray5[n15] = dArray5[n15] + (d8 - d9);
                stringBuilder.append(' ');
                stringBuilder.append(c2);
                continue;
            }
            if (d8 <= 0.0 && bl2 && d7 <= d3 / 2.0) {
                if (n8 < dArray5.length) {
                    int n16 = n8;
                    dArray4[n16] = dArray4[n16] + d8;
                    int n17 = n8;
                    dArray5[n17] = dArray5[n17] + d8;
                    continue;
                }
                if (n8 <= 0) continue;
                int n18 = n8 - 1;
                dArray4[n18] = dArray4[n18] + d8;
                int n19 = n8 - 1;
                dArray5[n19] = dArray5[n19] + d8;
                continue;
            }
            int n20 = n8;
            dArray4[n20] = dArray4[n20] + d9;
            int n21 = n8++;
            dArray5[n21] = dArray5[n21] + d8;
            stringBuilder.append(c2);
        }
        if (dArray4.length > 0 && (d2 = dArray4[0]) != 0.0) {
            dArray5[0] = dArray5[0] - d2;
            dArray4[0] = 0.0;
            TextModuleUtils.offsetTextStart(textElement, d2);
            bl = true;
        }
        textElement.setCharWidths(dArray5);
        textElement.setKerning(dArray4);
        textElement.setText(stringBuilder.toString());
        if (bl) {
            AffineTransform affineTransform = new AffineTransform(textElement.getTransformMatrix());
            textElement.calculateBounds(affineTransform, textElement.getTextWidth(), textElement.getTextHeight());
        }
    }

    protected static void offsetTextStart(TextElement text, double offset) {
        Point2D point2D = new Point2D.Double(offset, 0.0);
        double[] dArray = new double[6];
        double[] dArray2 = text.getTransformMatrix();
        System.arraycopy(dArray2, 0, dArray, 0, 4);
        AffineTransform affineTransform = new AffineTransform(dArray);
        point2D = affineTransform.transform(point2D, point2D);
        dArray2[4] = dArray2[4] + point2D.getX();
        dArray2[5] = dArray2[5] + point2D.getY();
        text.setTransformMatrix(dArray2);
    }

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' || Character.isWhitespace(c2) || c2 == '\ufeff' || c2 >= '\u200b' && c2 <= '\u200f';
    }

    private static boolean m(DrawableElement drawableElement) {
        if (!(drawableElement instanceof TextElement)) {
            return true;
        }
        String string = ((TextElement)drawableElement).getText();
        if (string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2) || c2 == '\u00ad') continue;
            return false;
        }
        return true;
    }

    private static boolean a(b b2, b b3, boolean bl) {
        return TextModuleUtils.a(b2, b3) && TextModuleUtils.b(b2, b3, bl);
    }

    private static boolean a(b b2, b b3) {
        if (b2.gs.getRotation() != b3.gs.getRotation()) {
            return false;
        }
        float f2 = b2.style.getFontSize();
        float f3 = b3.style.getFontSize();
        double d2 = 0.9;
        if (b2.style.isSubscript() || b2.style.isSuperscript() || b3.style.isSubscript() || b3.style.isSuperscript()) {
            d2 = 0.5;
        }
        if ((double)Math.min(f2 / f3, f3 / f2) < d2) {
            return false;
        }
        Point2D point2D = TextModuleUtils.a(b2.gs, false);
        Point2D point2D2 = TextModuleUtils.c(b3.gs);
        double d3 = Math.abs(point2D.getY() - point2D2.getY());
        double d4 = 1.0;
        if (d3 >= 1.0) {
            double d5 = Math.max(point2D.getY() - b2.gs.getTextHeight(), point2D2.getY() - b3.gs.getTextHeight());
            double d6 = Math.min(point2D.getY(), point2D2.getY());
            double d7 = (d6 - d5) / Math.max(b2.gs.getTextHeight(), b3.gs.getTextHeight());
            if (d7 < 0.75) {
                return false;
            }
        }
        return true;
    }

    private static boolean b(b b2, b b3, boolean bl) {
        double d2;
        double d3;
        double d4;
        double d5;
        Point2D point2D = TextModuleUtils.a(b2.gs, false);
        Point2D point2D2 = TextModuleUtils.c(b3.gs);
        double d6 = bl ? 0.54 : 1.0;
        double d7 = Math.min(b2.style.getWsWidthScaled(), b3.style.getWsWidthScaled()) * d6;
        double d8 = point2D2.getX() - point2D.getX();
        if (d8 < 0.0) {
            if (Double.isNaN(b2.style.getActualSpaceWidth()) && Double.isNaN(b3.style.getActualSpaceWidth())) {
                d7 = Math.max(Math.max(b2.style.getTextHeight(), b3.style.getTextHeight()) / 2.0 * d6, d7);
            }
            if (-d8 < d7 * 0.765) {
                String string = b2.gs.getText();
                if (string.length() > 0 && TextModuleUtils.isWhitespace(string.charAt(string.length() - 1)) && TextModuleUtils.getTrimLength(string) > 0) {
                    return false;
                }
                String string2 = b3.gs.getText();
                return string2.length() <= 0 || !TextModuleUtils.isWhitespace(string2.charAt(0)) || TextModuleUtils.getTrimLength(string2) <= 0;
            }
        }
        double d9 = b2.style.getAverageKerning();
        double d10 = b3.style.getAverageKerning();
        if (!Double.isNaN(d9) && !Double.isNaN(d10)) {
            d7 /= 0.8;
            double d11 = b2.gs.getScale();
            d5 = b3.gs.getScale();
            if (d9 * d11 < 1.0 && d10 * d5 < 1.0) {
                d9 = TextModuleUtils.b(b2.gs) * d11;
                d10 = TextModuleUtils.b(b3.gs) * d5;
                d7 = d9 < 0.0 && d10 < 0.0 || b2.style.equalsWithColors(b3.style) && (d9 < 0.0 || d10 < 0.0) ? Math.max(d7 / 3.0, (d7 + Math.min(d9, d10) * 2.0) / 2.0) : (d7 + Math.max(d9, d10)) / 2.0;
            } else {
                d7 = (d7 + Math.max(d9 * d11, d10 * d5)) / 2.0;
            }
            d4 = b2.style.getActualSpaceWidth() * d11;
            d3 = b3.style.getActualSpaceWidth() * d5;
            if (!Double.isNaN(d4) || !Double.isNaN(d3)) {
                d2 = Math.min(Double.isNaN(d4) ? Double.MAX_VALUE : d4, Double.isNaN(d3) ? Double.MAX_VALUE : d3);
                if (d2 / 2.0 > d7) {
                    d7 = d2 / 2.0;
                }
                if (d2 <= d7 && b2.style.equalsWithColors(b3.style)) {
                    d7 = Math.max(d2 * 0.8, d7 / 3.0);
                }
            }
            d7 = d7 * 0.8 * d6;
        }
        if (d8 < 0.0) {
            double[] dArray = b2.gs.getCharacterWidths();
            double[] dArray2 = b3.gs.getCharacterWidths();
            if (dArray.length > 0 && dArray2.length > 0) {
                d5 = b2.gs.getScale();
                d4 = b3.gs.getScale();
                d3 = dArray[dArray.length - 1] * d5;
                d2 = dArray2[0] * d4;
                double d12 = Math.min(d3, d2) / 2.0;
                d9 = b2.style.getAverageKerning() * d5;
                d10 = b3.style.getAverageKerning() * d4;
                if (d9 < 0.0 && d10 < 0.0) {
                    d12 -= (d9 + d10) / 2.0;
                } else if (Double.isNaN(d9) && d10 < 0.0) {
                    d12 -= d10;
                } else if (Double.isNaN(d10) && d9 < 0.0) {
                    d12 -= d9;
                }
                if (-d8 < d12) {
                    d8 = 0.0;
                }
            }
        }
        if (Math.abs(d8) > d7) {
            Point2D point2D3 = TextModuleUtils.a(b2.gs, true);
            double d13 = Math.abs(point2D.getY() - point2D2.getY());
            double d14 = 1.0;
            if (d13 >= 1.0) {
                return false;
            }
            return point2D2.getX() > point2D3.getX() && point2D2.getX() < point2D.getX();
        }
        return true;
    }

    private static double b(TextElement textElement) {
        double[] dArray = textElement.getKerningArray();
        if (dArray == null || dArray.length == 0) {
            return 0.0;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d2 = Double.MAX_VALUE;
        String string = textElement.getText();
        for (int i = 1; i < dArray.length; ++i) {
            double d3;
            int n = Character.getType(string.charAt(i));
            if (n == 8 || n == 6 || !((d3 = dArray[i]) < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static void calculateActualSpaceWidth(List<TextElement> textElements) {
        if (textElements.size() == 0) {
            return;
        }
        double d2 = Double.NaN;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        for (TextElement textElement2 : textElements) {
            String string = textElement2.getText();
            n2 += string.length();
            int n3 = textElement2.getText().indexOf(32);
            if (n3 < 0) continue;
            for (n3 = 1; n3 < string.length() - 1; ++n3) {
                double d4 = textElement2.getCharacterWidths()[n3];
                if (string.charAt(n3) == ' ') {
                    double d5;
                    if (textElement2.getKerningArray() != null && (d5 = textElement2.getKerningArray()[n3]) > d4 - d5) {
                        d4 -= d5;
                    }
                    d2 = Double.isNaN(d2) ? d4 : Math.min(d2, d4);
                    ++n;
                    continue;
                }
                if (textElement2.getKerningArray() != null) {
                    d4 -= textElement2.getKerningArray()[n3];
                }
                d3 += d4;
            }
        }
        if (n == 0 || Double.isNaN(d2)) {
            d2 = TextModuleUtils.calculateActualSpaceWidthFromCharDistances(textElements);
            if (!Double.isNaN(d2)) {
                double d6 = d2;
                textElements.forEach(textElement -> {
                    textElement.getStyle().setWsWidth(d6);
                    textElement.getStyle().setWsWidthScaled(d6 * textElement.getScale());
                });
            }
        } else {
            d2 = Math.min(d2, d3 / (double)(n2 - n) * 4.0);
        }
        double d7 = d2;
        textElements.forEach(textElement -> textElement.getStyle().setActualSpaceWidth(d7));
    }

    public static double calculateActualSpaceWidthFromCharDistances(List<TextElement> textElements) {
        Object object;
        Object object2;
        if (textElements.size() <= 1) {
            return Double.NaN;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = 0.0;
        int n = 0;
        for (TextElement textElement : textElements) {
            double d7;
            if (textElement.getRotation() != 0.0) continue;
            object2 = textElement.getKerningArray();
            object = textElement.getCharacterWidths();
            double d8 = textElement.getScale();
            double d9 = textElement.getY();
            double d10 = textElement.getX() + (object2 != null ? object2[0] * d8 : 0.0);
            if (Math.abs(d9 - d5) > 5.0E-6) {
                d5 = d9;
                d4 = Double.MIN_VALUE;
            } else if (d4 != Double.MIN_VALUE && (d7 = (d10 - d4) / d8) < d6 / (double)n * 3.0) {
                if (d7 < 0.001) {
                    arrayList.add(0.001);
                } else {
                    arrayList.add(d7);
                }
            }
            d4 = d10 + textElement.getTextWidth() * d8;
            String string = textElement.getText();
            if (object2 != null) {
                for (var20_18 = 0; var20_18 < ((Object)object).length; ++var20_18) {
                    var21_20 = Character.getType(string.charAt(var20_18));
                    if (var21_20 == 8 || var21_20 == 6) continue;
                    double d11 = object2[var20_18];
                    if (var20_18 > 0) {
                        arrayList.add(Math.abs(d11 * d8) > 0.2 ? d11 : 0.001);
                    }
                    d6 += object[var20_18] - d11;
                }
            } else {
                for (var20_18 = 0; var20_18 < ((Object)object).length; ++var20_18) {
                    var21_20 = Character.getType(string.charAt(var20_18));
                    if (var21_20 == 8 || var21_20 == 6) continue;
                    if (var20_18 > 0) {
                        arrayList.add(0.001);
                    }
                    d6 += object[var20_18];
                }
            }
            n += ((Object)object).length;
        }
        double d12 = d6 / (double)n;
        object = new RattleSort<Double>(d2 -> d2);
        object2 = arrayList.stream().filter(d3 -> d3 < d12).collect(Collectors.toCollection(() -> new ArrayList()));
        Pair pair = ((RattleSort)object).cluster2(object2, true);
        if (pair == null) {
            return Double.NaN;
        }
        Sample sample = pair.get(true);
        Sample sample2 = pair.get(false);
        double d13 = (Double)sample.getOccurrences().get(sample.getOccurrences().size() - 1);
        double d14 = (Double)sample2.getOccurrences().get(0);
        if (d14 > d12 / 5.0 && d14 - d13 > (sample2.doubleValue() - sample.doubleValue()) / 3.0) {
            double d15 = d14 * 2.0 / 3.0;
            return d15;
        }
        return Double.NaN;
    }

    public static void calculateAverageKerning(List<TextElement> textElements) {
        int n;
        double d3;
        Object d9;
        if (textElements.size() <= 1) {
            return;
        }
        double d4 = 0.0;
        int n2 = 0;
        boolean bl = true;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MIN_VALUE;
        double d7 = 0.0;
        boolean bl2 = false;
        for (TextElement serializable2 : textElements) {
            d9 = serializable2.getKerningArray();
            double sample = serializable2.getStyle().getWsWidth();
            d7 += sample;
            if (d9 == null && serializable2.getLabel().length() > 1) {
                n2 += serializable2.getLabel().length();
            }
            if (d9 == null || ((double[])d9).length < 2) continue;
            boolean bl3 = serializable2.getText().indexOf(32) < 0;
            bl2 |= !bl3;
            if (((Object)d9).length <= 1) continue;
            String d11 = serializable2.getText();
            for (int i = 1; i < ((Object)d9).length; ++i) {
                d3 = (double)d9[i];
                n = Character.getType(d11.charAt(i));
                if (n == 8 || n == 6 || !bl3 && Character.isWhitespace(d11.charAt(i - 1))) continue;
                d5 = Math.min(d5, d3);
                d6 = Math.max(d6, d3);
                arrayList.add(d3);
                if (d3 > sample) continue;
                ++n2;
                d4 += d3;
                bl &= d3 == 0.0;
            }
        }
        if (bl && arrayList.size() == n2) {
            return;
        }
        RattleSort<Double> rattleSort = new RattleSort<Double>(d2 -> d2);
        Pair pair = rattleSort.cluster2(arrayList, true);
        if (pair == null) {
            if (n2 > 0 && !bl) {
                double d8 = d4 / (double)n2;
                textElements.forEach(textElement -> textElement.getStyle().setAverageKerning(d9));
            }
            return;
        }
        d9 = pair.get(true);
        Sample sample = pair.get(false);
        double d10 = ((Sample)d9).getMax();
        double d11 = sample.getMin();
        if (d11 > (d7 /= (double)textElements.size()) / 4.0 && d11 - d10 > (sample.doubleValue() - ((Sample)d9).doubleValue()) / 4.0) {
            d3 = d11;
            n = !bl2 ? 1 : 0;
            textElements.forEach(arg_0 -> TextModuleUtils.a(d3, n != 0, d10, arg_0));
        }
        if (n2 > 0 && !bl) {
            d3 = d4 / (double)n2;
            textElements.forEach(textElement -> textElement.getStyle().setAverageKerning(d3));
        }
    }

    public static boolean canJoinOnOneWord(double whiteSpaceWidth, Point2D p0, Point2D p1) {
        double d2 = Math.abs(p0.getY() - p1.getY());
        double d3 = 1.0;
        if (d2 >= 1.0) {
            return false;
        }
        double d4 = p1.getX() - p0.getX();
        double d5 = whiteSpaceWidth * 0.98;
        return d4 >= 0.0 ? d4 <= d5 : d4 >= -d5;
    }

    public static boolean canJoinToOneLineForCopyText(Rectangle2D p0, Rectangle2D p1) {
        return TextModuleUtils.canJoinToOneLineForCopyText(p0.getY(), Math.abs(p0.getHeight()), p1.getY(), Math.abs(p1.getHeight()));
    }

    public static boolean canJoinToOneLineForCopyText(double y0, double h0, double y1, double h1) {
        double d2;
        double d3;
        if (gk) {
            return y0 == y1;
        }
        if (h0 < h1) {
            d3 = -h0 / 2.0;
            d2 = d3 + h1;
        } else {
            d2 = h1 / 2.0;
            d3 = d2 - h0;
        }
        double d4 = y0 - y1;
        return !(d4 < d3) && !(d4 > d2);
    }

    private static Point2D c(TextElement textElement) {
        Rectangle2D rectangle2D = textElement.getBounds();
        return new Point2D.Double(rectangle2D.getX(), LocationUtils.getMaxY(rectangle2D));
    }

    private static Point2D a(TextElement textElement, boolean bl) {
        Object object;
        double d2 = 0.0;
        if (bl && ((double[])(object = textElement.getCharacterWidths())).length > 0) {
            d2 = -object[((double[])object).length - 1] * 0.75;
        }
        if (textElement.getTextSlope() == 0.0 && textElement.getRotation() == 0.0) {
            object = textElement.getBounds();
            return new Point2D.Double(((RectangularShape)object).getMaxX() + d2, LocationUtils.getMaxY((Rectangle2D)object));
        }
        object = new AffineTransform(textElement.getTransformMatrix());
        Point2D.Double double_ = new Point2D.Double(textElement.getTextWidth() + d2, 0.0);
        return ((AffineTransform)object).transform(double_, double_);
    }

    public static int getTrimLength(String value) {
        int n;
        if (value == null) {
            return 0;
        }
        int n2 = value.length();
        for (n = 0; n < n2 && TextModuleUtils.isWhitespace(value.charAt(n)); ++n) {
        }
        while (n < n2 && TextModuleUtils.isWhitespace(value.charAt(n2 - 1))) {
            --n2;
        }
        return n2 - n;
    }

    private static TextElement b(TextElement textElement, boolean bl) {
        Object object;
        TextElement textElement2 = textElement.subText(0, textElement.getText().length());
        int n = 0;
        String string = textElement2.getText();
        if (bl) {
            for (var5_5 = 0; var5_5 < string.length() && TextModuleUtils.isWhitespace(string.charAt(var5_5)); ++var5_5) {
                ++n;
            }
        } else {
            for (var5_5 = string.length() - 1; var5_5 >= 0 && TextModuleUtils.isWhitespace(string.charAt(var5_5)); --var5_5) {
                ++n;
            }
        }
        if (n == 0) {
            return textElement;
        }
        double[] dArray = textElement2.getCharacterWidths();
        double[] dArray2 = new double[dArray.length - n];
        System.arraycopy(dArray, bl ? n : 0, dArray2, 0, dArray2.length);
        textElement2.setCharWidths(dArray2);
        double[] dArray3 = textElement2.getKerningArray();
        if (dArray3 != null) {
            object = new double[dArray3.length - n];
            System.arraycopy(dArray3, bl ? n : 0, object, 0, ((double[])object).length);
            textElement2.setKerning((double[])object);
        }
        textElement2.setText(string.substring(bl ? n : 0, string.length() - (bl ? 0 : n)));
        object = new AffineTransform(textElement2.getTransformMatrix());
        if (bl) {
            double d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                d2 += dArray[i];
            }
            double[] dArray4 = new double[6];
            ((AffineTransform)object).translate(d2, 0.0);
            ((AffineTransform)object).getMatrix(dArray4);
            textElement2.setTransformMatrix(dArray4);
        }
        textElement2.calculateBounds((AffineTransform)object, textElement2.getTextWidth(), textElement2.getTextHeight());
        return textElement2;
    }

    private static /* synthetic */ void a(double d2, boolean bl, double d3, TextElement textElement) {
        TextStyle textStyle = textElement.getStyle();
        if (d2 < textStyle.getWsWidth()) {
            double d4 = textStyle.getWsWidthScaled() / textStyle.getWsWidth();
            textStyle.setWsWidth(d2);
            textStyle.setWsWidthScaled(d2 * d4);
        } else if (bl && d3 < textStyle.getWsWidth() / 2.0) {
            textStyle.setWsWidth(textStyle.getWsWidth() / 2.0);
            textStyle.setWsWidthScaled(textStyle.getWsWidthScaled() / 2.0);
        }
    }

    private static class a
    extends BreakIterator {
        private int go;
        private int gp;
        private String gq;
        private int gr;

        private a() {
        }

        @Override
        public int first() {
            return this.gp;
        }

        @Override
        public int last() {
            return this.go;
        }

        @Override
        public int next(int n) {
            ++this.gr;
            while (n > 0 && this.gr < this.gq.length()) {
                if (Character.isWhitespace(this.gq.charAt(this.gr))) {
                    --n;
                }
                ++this.gr;
            }
            return this.gr < this.gq.length() ? this.gr : -1;
        }

        @Override
        public int next() {
            ++this.gr;
            while (this.gr < this.gq.length() && !Character.isWhitespace(this.gq.charAt(this.gr))) {
                ++this.gr;
            }
            return this.gr < this.gq.length() ? this.gr : -1;
        }

        @Override
        public int previous() {
            return -1;
        }

        @Override
        public int following(int offset) {
            ++offset;
            while (offset < this.gq.length() && !Character.isWhitespace(this.gq.charAt(offset))) {
                ++offset;
            }
            return offset < this.gq.length() ? offset : -1;
        }

        @Override
        public int current() {
            return this.gr;
        }

        @Override
        public CharacterIterator getText() {
            throw new IllegalStateException("getText() is not implemented for the NoBreakIterator");
        }

        @Override
        public void setText(CharacterIterator newText) {
            char c2;
            StringBuilder stringBuilder = new StringBuilder(newText.getEndIndex() - newText.getBeginIndex());
            while ((c2 = newText.next()) != '\uffff') {
                stringBuilder.append(c2);
            }
            this.gq = stringBuilder.toString();
            this.gp = newText.getBeginIndex();
            this.go = newText.getEndIndex();
            this.gr = 0;
        }

        @Override
        public void setText(String newText) {
            this.gr = 0;
            this.gq = newText;
            this.go = newText.length();
        }

        @Override
        public boolean isBoundary(int offset) {
            return Character.isWhitespace(this.gq.charAt(offset));
        }
    }

    private static class b {
        private TextElement gs;
        private TextStyle style;

        public b(TextElement textElement) {
            this.style = TextModuleUtils.getStyle(textElement);
            this.gs = textElement;
            TextModuleUtils.b(this);
        }

        public String toString() {
            return this.gs.toString();
        }
    }

    @InternalApi
    public static class StyleState {
        private TextStyle style;
    }
}

