/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.model.ElementID;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;

@InternalApi
public class TwoSidedPaint
implements Paint,
Serializable {
    private transient a gb;
    private transient a gc;

    private TwoSidedPaint() {
    }

    private TwoSidedPaint(a leftPaint, a rightPaint) {
        this.gb = leftPaint;
        this.gc = rightPaint;
    }

    public TwoSidedPaint(Paint paint, ElementID id, boolean leftSide) {
        this.a(paint, id, leftSide);
    }

    public TwoSidedPaint(Paint paintLeft, ElementID idLeft, Paint paintRigth, ElementID idRight) {
        this.a(paintLeft, idLeft, true);
        this.a(paintRigth, idRight, false);
    }

    private void a(Paint paint, ElementID elementID, boolean bl) {
        if (paint instanceof TwoSidedPaint) {
            this.setTwoSided((TwoSidedPaint)paint, bl);
            return;
        }
        if (bl) {
            this.gb = paint != null ? new a(paint, elementID) : null;
        } else {
            this.gc = paint != null ? new a(paint, elementID) : null;
        }
    }

    public void setTwoSided(TwoSidedPaint paint, boolean sameDirection) {
        if (sameDirection) {
            this.gb = TwoSidedPaint.a(this.gb, paint.gb);
            this.gc = TwoSidedPaint.a(this.gc, paint.gc);
        } else {
            this.gc = TwoSidedPaint.a(this.gc, paint.gb);
            this.gb = TwoSidedPaint.a(this.gb, paint.gc);
        }
    }

    private static a a(a a2, a a3) {
        if (a2 == null || a2.gd == null) {
            return a3;
        }
        if (a3 == null || a3.gd == null) {
            return a2;
        }
        if (a2.ge != null && a3.ge != null) {
            if (a2.ge.compareTo(a3.ge) > 0) {
                return a2;
            }
            return a3;
        }
        return a3;
    }

    public void setSameSide(Paint paint, ElementID source) {
        if (paint instanceof TwoSidedPaint) {
            this.a(paint, source, true);
            return;
        }
        if (this.gb == null) {
            this.gb = new a(paint, source);
        } else {
            this.gc = new a(paint, source);
        }
    }

    public void setOtherSide(Paint paint, ElementID source) {
        if (paint instanceof TwoSidedPaint) {
            this.a(paint, source, false);
            return;
        }
        if (this.gb == null) {
            this.gb = new a(paint, source);
        } else {
            this.gc = new a(paint, source);
        }
    }

    public Paint getPaint(boolean leftSide) {
        if (leftSide) {
            return this.gb != null ? this.gb.gd : null;
        }
        return this.gc != null ? this.gc.gd : null;
    }

    public Paint getAny() {
        return this.gb != null && this.gb.gd != null ? this.gb.gd : (this.gc != null ? this.gc.gd : null);
    }

    public boolean hasTwoPaints() {
        return this.gb != null && this.gc != null && !Objects.equals(this.gb, this.gc);
    }

    @Override
    public int getTransparency() {
        return this.getAny().getTransparency();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.getAny().createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    public TwoSidedPaint copy() {
        return new TwoSidedPaint(this.gb, this.gc);
    }

    public TwoSidedPaint copyInverse() {
        return new TwoSidedPaint(this.gc, this.gb);
    }

    public int hashCode() {
        return Objects.hash(this.gb, this.gc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TwoSidedPaint)) {
            return false;
        }
        TwoSidedPaint twoSidedPaint = (TwoSidedPaint)obj;
        return Objects.equals(this.gb, twoSidedPaint.gb) && Objects.equals(this.gc, twoSidedPaint.gc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        TwoSidedPaint.writePaint(this.getPaint(true), out);
        TwoSidedPaint.writePaint(this.getPaint(false), out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        Paint paint = TwoSidedPaint.readPaint(in);
        Paint paint2 = TwoSidedPaint.readPaint(in);
        this.gb = paint != null ? new a(paint, null) : null;
        this.gc = paint2 != null ? new a(paint2, null) : null;
    }

    public static void writePaint(Paint p, ObjectOutputStream out) throws IOException {
        if (p == null || p instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(p);
        } else {
            BufferedGraphics2D bufferedGraphics2D = new BufferedGraphics2D();
            try {
                bufferedGraphics2D.setPaint(p);
                out.writeBoolean(false);
                bufferedGraphics2D.writeExternal((ObjectOutput)out);
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_CORE.warn((Object)("Paint cannot be serialized and will be missing after deserialization: " + p.getClass().getName()));
                out.writeBoolean(true);
                out.writeObject(null);
            }
        }
    }

    public static Paint readPaint(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (in.readBoolean()) {
            return (Paint)in.readObject();
        }
        BufferedGraphics2D bufferedGraphics2D = new BufferedGraphics2D();
        bufferedGraphics2D.readExternal((ObjectInput)in);
        BufferedGraphicsCommand bufferedGraphicsCommand = (BufferedGraphicsCommand)bufferedGraphics2D.getGraphicsProvider().getList().get(0);
        return (Paint)bufferedGraphicsCommand.getParameters()[0];
    }

    public String toString() {
        return "left=" + String.valueOf(this.gb != null ? this.gb.gd : null) + ", right=" + String.valueOf(this.gc != null ? this.gc.gd : null);
    }

    private static class a {
        private Paint gd;
        private ElementID ge;

        public a(Paint paint, ElementID elementID) {
            this.gd = paint;
            this.ge = elementID;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof a)) {
                return false;
            }
            a a2 = (a)obj;
            return Objects.equals(this.gd, a2.gd);
        }
    }
}

