/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.print.MasterAlphaGraphics;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.AnnotationDrawer;
import com.inet.pdfc.results.painter.DifferenceImageCache;
import com.inet.pdfc.results.painter.HighlightPainter;
import com.inet.pdfc.results.painter.IViewInfoProvider;
import com.inet.pdfc.results.painter.MarkerManager;
import com.inet.pdfc.util.BitmapArea;
import com.inet.pdfc.util.LocationUtils;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Painter {
    public static final int MID_HEIGHT_HALF = 5;
    static final Font sF = new Font("Sans Serif", 1, 12);
    private HighlightPainter sG;
    private final DifferenceImageCache sH;
    private ResultModel model;
    private IViewInfoProvider sI;
    private Color sJ;
    private MarkerManager sK;
    private int sL = 3;
    private List<a> sM;
    private Settings settings = new DefaultSetting();

    public Painter(IViewInfoProvider viewInfoProvider, ResultModel model, DifferenceImageCache scaledImageCache, MarkerManager markerManager, Color pageAreaBG) {
        this.sI = viewInfoProvider;
        this.model = model;
        this.sH = scaledImageCache;
        this.sK = markerManager;
        this.sJ = pageAreaBG;
        this.sG = new HighlightPainter(this.settings);
    }

    public void paintBackground(@Nonnull Graphics2D g2, @Nonnull Rectangle rect) {
        if (this.sJ == null) {
            return;
        }
        g2.setColor(this.sJ);
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        Rectangle rectangle2 = g2.getClipBounds();
        if (rectangle2 != null) {
            rectangle = rectangle.intersection(rectangle2);
        }
        g2.fill(rectangle);
    }

    public void setPageAreaBG(Color pageAreaBG) {
        this.sJ = pageAreaBG;
    }

    public void paintContent(@Nonnull Graphics2D g2, @Nonnull Rectangle rect, boolean left, boolean highlightAreas) {
        this.paintContent(g2, rect, left, highlightAreas, false, true);
    }

    public void paintContent(@Nonnull Graphics2D g2, @Nonnull Rectangle rect, boolean left, boolean highlightAreas, boolean export, boolean pageBorders) {
        int n;
        int n2;
        Object object2;
        Rectangle rectangle = rect.getBounds();
        if (this.model.isEmpty()) {
            Painter.a(g2, rectangle);
            return;
        }
        Rectangle rectangle2 = this.a(g2, left, rectangle, export, pageBorders);
        this.sG.clear();
        double d2 = this.sI.getViewScale();
        AnnotationDrawer annotationDrawer = null;
        if (g2 instanceof AnnotationDrawer) {
            annotationDrawer = (AnnotationDrawer)((Object)g2);
        } else if (g2 instanceof MasterAlphaGraphics && (object2 = ((MasterAlphaGraphics)((Object)g2)).getDestination()) instanceof AnnotationDrawer) {
            annotationDrawer = (AnnotationDrawer)object2;
        }
        object2 = this.sI.computeCurrentViewPosition(true);
        IViewInfoProvider.ViewInfo viewInfo = this.sI.computeCurrentViewPosition(false);
        Rectangle rectangle3 = this.sI.computeCurrentDocumentPosition(true);
        Rectangle rectangle4 = this.sI.computeCurrentDocumentPosition(false);
        Shape shape = g2.getClip();
        Rectangle rectangle5 = shape != null ? shape.getBounds() : null;
        HashMap<DiffGroup.GroupType, BitmapArea> hashMap = new HashMap<DiffGroup.GroupType, BitmapArea>();
        int n3 = ((IViewInfoProvider.ViewInfo)object2).y + ((IViewInfoProvider.ViewInfo)object2).height;
        int n4 = viewInfo.y + viewInfo.height;
        int n5 = 0;
        if (this.sL == 1 || this.sL == 2) {
            this.sM = new ArrayList<a>();
        }
        int n6 = rectangle3.y + rectangle3.height;
        int n7 = rectangle4.y + rectangle4.height;
        for (MarkerManager.Marker object3 : this.sK.getMarkers()) {
            int n8;
            Rectangle n12 = object3.getBoundsLeft();
            Rectangle n13 = object3.getBoundsRight();
            n2 = n12 != null ? n12.y + n12.height : 0;
            int n9 = n = n13 != null ? n13.y + n13.height : 0;
            if (!(n12 != null && n2 >= rectangle3.y && n12.y <= n6 || n13 != null && n >= rectangle4.y && n13.y <= n7 || n12 != null && n13 != null && (n2 < rectangle3.y && n13.y > n7 || n2 > n6 && n13.y < rectangle4.y) && n5++ < 5)) continue;
            Rectangle rectangle6 = this.sI.updateMarkerRect(n12, true);
            Rectangle rectangle7 = this.sI.updateMarkerRect(n13, false);
            Rectangle rectangle8 = left ? rectangle6 : rectangle7;
            if (rectangle8 == null) continue;
            Rectangle rectangle9 = left ? rectangle7 : rectangle6;
            int n10 = rectangle6 != null ? rectangle6.y + rectangle6.height : 0;
            int n11 = n8 = rectangle7 != null ? rectangle7.y + rectangle7.height : 0;
            if (this.sL == 1 || this.sL == 2) {
                for (DiffGroup diffGroup : object3.getMarkedGroups()) {
                    this.a(diffGroup, rectangle2, rectangle5, d2, left);
                }
            }
            if (!(rectangle6 != null && n10 >= ((IViewInfoProvider.ViewInfo)object2).y && rectangle6.y <= n3 || rectangle7 != null && n8 >= viewInfo.y && rectangle7.y <= n4 || rectangle6 != null && rectangle7 != null && (n10 < ((IViewInfoProvider.ViewInfo)object2).y && rectangle7.y > n4 || n10 > n3 && rectangle7.y < viewInfo.y) && n5++ < 5)) continue;
            rectangle8.y += rectangle2.y;
            if (rectangle8.height < 1) {
                rectangle8.height = 1;
            }
            BitmapArea bitmapArea = Painter.a(hashMap, object3.getType());
            this.a(annotationDrawer, left, rectangle2, d2, object3, rectangle5);
            if (!highlightAreas) continue;
            this.addMarkerToArea(rectangle8, rectangle9, d2, rectangle, left, bitmapArea, rectangle2, (IViewInfoProvider.ViewInfo)object2, viewInfo);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.a(g2, annotationDrawer);
        this.a(g2, shape, hashMap, export);
        ResultPage resultPage = this.model.getPageAt(new Point(0, (int)(left ? (double)((IViewInfoProvider.ViewInfo)object2).y : (double)viewInfo.y / d2)), left);
        ResultPage resultPage2 = this.model.getPageAt(new Point(0, (int)((double)(left ? n3 : n4) / d2)), left);
        int n12 = resultPage != null ? resultPage.getPageIndex() : this.model.getPageCount(left) - 1;
        int n13 = resultPage2 != null ? resultPage2.getPageIndex() : this.model.getPageCount(left) - 1;
        n2 = Integer.MAX_VALUE;
        for (n = n12; n <= n13; ++n) {
            n2 = Math.min(n2, this.sI.getCenterOffset(n, left, false));
        }
        int n14 = rectangle2.x = n2 < Integer.MAX_VALUE ? n2 : 0;
        if (rectangle2.x != 0 || rectangle2.y != 0) {
            g2.translate(rectangle2.x, rectangle2.y);
        }
        if (rectangle2.x != 0 || rectangle2.y != 0) {
            g2.translate(-rectangle2.x, -rectangle2.y);
        }
        g2.setClip(shape);
    }

    protected void addMarkerToArea(@Nonnull Rectangle markerBounds, @Nullable Rectangle targetRect, double scale, @Nonnull Rectangle visRect, boolean left, @Nonnull BitmapArea markerArea, @Nonnull Rectangle offset, @Nonnull IViewInfoProvider.ViewInfo leftView, @Nonnull IViewInfoProvider.ViewInfo rightView) {
        boolean bl;
        int n;
        Shape shape;
        int n2;
        int n3 = visRect.x + (left ? visRect.width : 0);
        int n4 = this.model.getPageAt(new Point(0, (int)((double)markerBounds.y / scale)), left).getPageIndex();
        int n5 = this.model.getPageAt(new Point(0, (int)((double)(markerBounds.y + markerBounds.height) / scale)), left).getPageIndex();
        int n6 = Integer.MAX_VALUE;
        for (n2 = n4; n2 <= n5; ++n2) {
            n6 = Math.min(n6, this.sI.getCenterOffset(n2, left, false));
        }
        int n7 = n6 = n6 < Integer.MAX_VALUE ? n6 : 0;
        if (left) {
            n2 = n3 - 30;
            if (markerBounds.height == 1 && markerBounds.x > 0) {
                var16_15 = Math.max(markerBounds.x + n6, visRect.x);
                markerArea.add(new Rectangle(Math.min(n2, var16_15), markerBounds.y, Math.abs(var16_15 - n2), markerBounds.height));
                markerArea.add(new Arc2D.Double(new Rectangle2D.Double(var16_15, markerBounds.y - 3, 6.0, 6.0), 0.0, 360.0, 2));
            } else if (targetRect == null) {
                n2 = (int)offset.getMaxX() - 30;
                var16_15 = Math.min(5, markerBounds.height / 2);
                shape = new Area(new Rectangle(n6, markerBounds.y, n2 - n6, markerBounds.height));
                ((Area)shape).add(new Area(new RoundRectangle2D.Double(n2 - 1, markerBounds.y, 30.0, markerBounds.height, var16_15, var16_15)));
                markerArea.add(shape);
            } else {
                markerArea.add(new Rectangle(n6, markerBounds.y, n2 - n6, markerBounds.height));
            }
        } else {
            n2 = 30 + visRect.x;
            if (markerBounds.height == 1 && markerBounds.x > 0) {
                var16_15 = visRect.x + visRect.width - 6;
                int n8 = Math.min(markerBounds.x + n6, var16_15);
                markerArea.add(new Rectangle(n2, markerBounds.y, markerBounds.x + n6 - 30 - visRect.x, markerBounds.height));
                markerArea.add(new Arc2D.Double(new Rectangle2D.Double(n8, markerBounds.y - 3, 6.0, 6.0), 0.0, 360.0, 2));
            } else {
                var16_15 = n6 + offset.width;
                if (targetRect == null) {
                    n2 = 30 + n6;
                    if (var16_15 > visRect.x) {
                        Rectangle rectangle = new Rectangle(n2, markerBounds.y, var16_15 - n2, markerBounds.height);
                        n = Math.min(5, markerBounds.height / 2);
                        Area area = new Area(rectangle);
                        area.add(new Area(new RoundRectangle2D.Double(n6, markerBounds.y, 31.0, markerBounds.height, n, n)));
                        markerArea.add(area);
                    }
                } else if (var16_15 > n2) {
                    markerArea.add(new Rectangle(n2, markerBounds.y, var16_15 - n2, markerBounds.height));
                }
            }
        }
        if (targetRect == null) {
            return;
        }
        targetRect.y = targetRect.y + this.sI.getCenterOffset(0, !left, true);
        IViewInfoProvider.ViewInfo viewInfo = left ? leftView : rightView;
        shape = left ? rightView : leftView;
        n = viewInfo.y >= 0 ? 1 : 0;
        boolean bl2 = bl = ((IViewInfoProvider.ViewInfo)shape).y >= 0;
        n2 = n != 0 && bl ? ((IViewInfoProvider.ViewInfo)shape).getYOffset() - viewInfo.getYOffset() : (n != 0 ? viewInfo.y : (bl ? -((IViewInfoProvider.ViewInfo)shape).y : 0));
        int n9 = (targetRect.y + n2 + targetRect.height / 2 + markerBounds.y + markerBounds.height / 2) / 2;
        markerArea.add(Painter.a(markerBounds, left ? -30 : 30, n9, n3, scale));
    }

    private void a(@Nullable AnnotationDrawer annotationDrawer, boolean bl, @Nonnull Rectangle rectangle, double d2, @Nonnull MarkerManager.Marker marker, @Nullable Rectangle rectangle2) {
        if (!this.settings.isEnabled(Settings.EXPORT.COMMENTS) || annotationDrawer == null || this.sL == 1 && !bl || this.sL == 2 && bl) {
            return;
        }
        for (DiffGroup diffGroup : marker.getMarkedGroups()) {
            for (Modification modification : diffGroup.getModifications()) {
                List<PagedElement> list;
                if (!modification.isVisible() || (list = modification.getAffectedElements(bl)).size() == 0 || this.sL == 1 && modification.getModificationType() == Modification.ModificationType.add || this.sL == 2 && modification.getModificationType() == Modification.ModificationType.remove) continue;
                ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
                for (PagedElement pagedElement : list) {
                    int n = pagedElement.getPageIndex();
                    float f2 = this.model.getPage(n, bl).getPageOffset() + this.sI.getPageGap(n, bl);
                    Rectangle2D rectangle2D = LocationUtils.scaleRect(d2, pagedElement.getBounds());
                    rectangle2D.setRect(rectangle2D.getX() + (double)rectangle.x, rectangle2D.getY() + (double)rectangle.y + d2 * (double)f2, rectangle2D.getWidth(), rectangle2D.getHeight());
                    this.d(rectangle2D);
                    rectangle2D = rectangle2 != null ? rectangle2.intersection(rectangle2D.getBounds()) : rectangle2D.getBounds();
                    if (rectangle2D.isEmpty()) continue;
                    arrayList.add(rectangle2D);
                }
                if (arrayList.isEmpty()) continue;
                annotationDrawer.annotateHighlight(arrayList.toArray(new Rectangle2D[arrayList.size()]), modification.getMessage(), Color.WHITE);
            }
        }
    }

    private void a(@Nonnull Graphics2D graphics2D, @Nullable AnnotationDrawer annotationDrawer) {
        if (this.sM == null || this.sM.isEmpty()) {
            return;
        }
        int n = (int)Math.round(10.0 * Math.cos(1.0471975511965976));
        Color color = graphics2D.getColor();
        graphics2D.setColor(a.sN);
        Collections.sort(this.sM);
        Iterator<a> iterator = this.sM.iterator();
        a a2 = iterator.next();
        a a3 = null;
        do {
            a a4 = a3 = iterator.hasNext() ? iterator.next() : null;
            if (a3 != null && LocationUtils.getMaxY(a3.sO) < LocationUtils.getMaxY(a2.sO) + (double)(2 * n)) {
                a2.a(a3);
                continue;
            }
            Polygon polygon = new Polygon();
            polygon.addPoint(0, 0);
            polygon.addPoint(n, n);
            polygon.addPoint(n, -n);
            polygon.translate(a2.sP, (int)a2.sO.getCenterY());
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            arrayList.add(a2.sO);
            graphics2D.fill(a2.sO);
            if (a2.sQ != null) {
                for (a a5 : a2.sQ) {
                    arrayList.add(a5.sO);
                    graphics2D.fill(a5.sO);
                }
            }
            graphics2D.fill(polygon);
            arrayList.add(polygon.getBounds2D());
            if (annotationDrawer != null) {
                annotationDrawer.annotateHighlight(arrayList.toArray(new Rectangle2D[arrayList.size()]), a2.message, Color.white);
            }
            a2 = a3;
        } while (a3 != null);
        graphics2D.setColor(color);
    }

    private void a(@Nonnull Graphics2D graphics2D, Shape shape, @Nonnull Map<DiffGroup.GroupType, BitmapArea> map, boolean bl) {
        if (this.settings.isEnabled(Settings.METAOPTION.ALLOUTLINEMARKER)) {
            for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
                if (!groupType.isTypePainted()) continue;
                Painter.a(graphics2D, shape, map.get(groupType), this.settings.getMarkerColor(groupType), !bl);
            }
        }
    }

    private void d(@Nonnull Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() < 0.0) {
            rectangle2D.setRect(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY(), -rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (rectangle2D.getHeight() < 0.0) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getWidth(), -rectangle2D.getHeight());
        }
    }

    public void setSettings(Settings setting) {
        this.settings = setting;
        this.sH.setColorProvider(this.settings);
        this.sG.setSettings(this.settings);
    }

    private void a(@Nonnull DiffGroup diffGroup, @Nonnull Rectangle rectangle, @Nonnull Rectangle rectangle2, double d2, boolean bl) {
        PagedElement pagedElement;
        List<PagedElement> list;
        if (!(this.sL == 1 && bl || this.sL == 2 && !bl)) {
            return;
        }
        List<PagedElement> list2 = list = !bl ? diffGroup.getRemovedElements() : diffGroup.getAddedElements();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Modification> arrayList = new ArrayList<Modification>(2);
        for (Modification serializable2 : diffGroup.getModifications()) {
            if (!(bl ? serializable2.getModificationType() == Modification.ModificationType.add : serializable2.getModificationType() == Modification.ModificationType.remove)) continue;
            arrayList.add(serializable2);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (this.sM == null) {
            this.sM = new ArrayList<a>();
        }
        int n = list.get(0).getPageIndex();
        ResultPage resultPage = this.model.getPageAt(new Point(0, diffGroup.getBounds((boolean)bl).y), bl);
        int n2 = 0;
        if (resultPage != null) {
            n2 = resultPage.getPageOffset() + this.sI.getPageGap(n, bl);
        }
        RectangularShape rectangularShape = null;
        PagedElement pagedElement2 = bl ? diffGroup.getBoundingElements().getBeforeFirst() : diffGroup.getBoundingElements().getBeforeSecond();
        PagedElement pagedElement3 = pagedElement = bl ? diffGroup.getBoundingElements().getAfterFirst() : diffGroup.getBoundingElements().getAfterSecond();
        if (pagedElement2 != null) {
            rectangularShape = new Rectangle2D.Double(pagedElement2.getBounds().getMaxX(), pagedElement2.getBounds().getY(), 2.0, pagedElement2.getBounds().getHeight());
        } else if (pagedElement != null) {
            rectangularShape = new Rectangle2D.Double(pagedElement.getBounds().getMinX() - 2.0, pagedElement.getBounds().getY(), 2.0, pagedElement.getBounds().getHeight());
        }
        if (rectangularShape != null) {
            rectangularShape = new Rectangle2D.Double((double)rectangle.x + d2 * rectangularShape.getX(), (double)rectangle.y + d2 * (rectangularShape.getY() + (double)n2), d2 * rectangularShape.getWidth(), d2 * rectangularShape.getHeight());
            this.d((Rectangle2D)rectangularShape);
            rectangularShape = rectangle2.intersection(rectangularShape.getBounds());
            if (!rectangularShape.isEmpty()) {
                for (Modification modification : arrayList) {
                    this.sM.add(new a((Rectangle2D)rectangularShape, (int)((double)rectangle.x + (resultPage != null ? d2 * (double)resultPage.getWidth() : 0.0)) - 30, modification.getMessage()));
                }
            }
        }
    }

    public void setPaintSides(int paintSides) {
        this.sL = paintSides;
    }

    @Nonnull
    private static BitmapArea a(@Nonnull Map<DiffGroup.GroupType, BitmapArea> map, @Nonnull DiffGroup.GroupType groupType) {
        BitmapArea bitmapArea = map.get(groupType);
        if (bitmapArea == null) {
            bitmapArea = new BitmapArea();
            map.put(groupType, bitmapArea);
        }
        return bitmapArea;
    }

    private static void a(@Nonnull Graphics2D graphics2D, @Nullable Shape shape, @Nullable BitmapArea bitmapArea, @Nullable Color color, boolean bl) {
        if (bitmapArea != null) {
            graphics2D.setClip(shape);
            graphics2D.setColor(color);
            bitmapArea.fill(graphics2D, color, bl);
            bitmapArea.drawAllShapes(graphics2D, color, bl);
        }
    }

    @Nonnull
    private static GeneralPath a(@Nonnull Rectangle rectangle, int n, int n2, int n3, double d2) {
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(n3 + n, rectangle.y);
        int n4 = (int)Math.round(5.0 * d2);
        generalPath.curveTo(n3, rectangle.y, n3 + n, n2 - n4, n3, n2 - n4);
        generalPath.lineTo(n3, n2 + n4);
        generalPath.curveTo(n3 + n, n2 + n4, n3, rectangle.y + rectangle.height, n3 + n, rectangle.y + rectangle.height);
        return generalPath;
    }

    @Nonnull
    private Rectangle a(@Nonnull Graphics2D graphics2D, boolean bl, @Nonnull Rectangle rectangle, boolean bl2, boolean bl3) {
        Rectangle rectangle2 = new Rectangle();
        boolean bl4 = (this.settings.isEnabled(Settings.EXPORT.SCALETOPAGEHEIGHT) || this.settings.isEnabled(Settings.EXPORT.AUTOPAGESSIZE)) && bl2;
        boolean bl5 = false;
        double d2 = this.sI.getViewScale();
        double d3 = graphics2D.getTransform().getScaleX();
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = Math.max(this.model.getPageCount(true), this.model.getPageCount(false));
        for (int i = 0; i < n3; ++i) {
            ResultPage resultPage = this.model.getPage(i, bl);
            if (resultPage == null || resultPage.getHeight() <= 0) continue;
            int n4 = this.sI.getPageGap(i, bl);
            Rectangle rectangle3 = new Rectangle(0, resultPage.getPageOffset() + n4, resultPage.getWidth(), resultPage.getHeight());
            rectangle3 = LocationUtils.scaleRect(d2, rectangle3);
            --rectangle3.height;
            rectangle2.y = this.sI.getCenterOffset(i, bl, true);
            rectangle3.y += rectangle2.y;
            Dimension dimension = rectangle3.getSize();
            if (d3 != 1.0) {
                dimension.width = (int)Math.round((double)dimension.width * d3);
                dimension.height = (int)Math.round((double)dimension.height * d3);
            }
            double d4 = rectangle3.getMaxY();
            double d5 = rectangle3.getMinY();
            double d6 = (double)resultPage.getHeight() * 0.1;
            if (d4 >= rectangle.getMinY() && d5 <= rectangle.getMaxY()) {
                bl5 = true;
                if (bl4 && (d5 <= rectangle.getMinY() - d6 || d4 >= rectangle.getMaxY() + d6)) continue;
                rectangle2.x = this.sI.getCenterOffset(i, bl, false);
                n = Math.min(n, rectangle2.x);
                n2 = Math.max(n2, rectangle3.width);
                BufferedGraphics2D bufferedGraphics2D = new BufferedGraphics2D();
                LayerGraphics2D.copyGraphicSettings((Graphics2D)graphics2D, (Graphics2D)bufferedGraphics2D);
                graphics2D.setClip(rectangle3.x + rectangle2.x, rectangle3.y, rectangle3.width, rectangle3.height + 1);
                this.sH.renderPage(bl, i, d2, graphics2D, true);
                LayerGraphics2D.copyGraphicSettings((Graphics2D)bufferedGraphics2D, (Graphics2D)graphics2D);
                Rectangle rectangle4 = new Rectangle(rectangle3.x - 1, rectangle3.y - 1, rectangle3.width + 1, rectangle3.height + 1);
                if (bl3) {
                    Painter.a(graphics2D, rectangle2.x, rectangle4, bl2);
                }
                if (!CollapsePagesModelData.isRealPage(resultPage)) continue;
                List<HighlightData.Highlight> list = resultPage.getHighlights();
                this.sG.drawHighlights(graphics2D, d2, rectangle2.x, rectangle3, list, this.model.getPageImageCache(), bl2);
                continue;
            }
            if (!bl5) continue;
            bl5 = false;
            break;
        }
        rectangle2.x = n < Integer.MAX_VALUE ? n : 0;
        rectangle2.width = n2;
        return rectangle2;
    }

    private static void a(@Nonnull Graphics2D graphics2D, int n, @Nonnull Rectangle rectangle, boolean bl) {
        graphics2D.setColor(Color.GRAY);
        if (bl) {
            graphics2D.setStroke(new BasicStroke(0.2f));
        } else {
            graphics2D.setStroke(new BasicStroke(0.6f));
        }
        graphics2D.draw(new Rectangle(rectangle.x + n, rectangle.y, rectangle.width, rectangle.height));
    }

    private static void a(@Nonnull Graphics2D graphics2D, @Nonnull Rectangle rectangle) {
        graphics2D.setColor(Color.GRAY);
        graphics2D.setFont(new Font("Arial", 3, 16));
        String string = Msg.getMsg("Label.started");
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString(string, rectangle.x + rectangle.width / 2 - graphics2D.getFontMetrics().stringWidth(string) / 2, rectangle.y + rectangle.height / 3);
    }

    private static class a
    implements Comparable<a> {
        private static final Color sN = new Color(0, 128, 255, 128);
        private Rectangle2D sO;
        private int sP;
        private String message;
        private List<a> sQ;

        a(Rectangle2D rectangle2D, int n, String string) {
            this.sO = rectangle2D;
            this.sP = n;
            this.message = string;
        }

        void a(a a2) {
            if (this.sQ == null) {
                this.sQ = new ArrayList<a>();
            }
            this.sQ.add(a2);
            this.message = this.message + "\n _____________ \n\n" + a2.message;
        }

        public int b(a a2) {
            return Double.compare(LocationUtils.getMinY(this.sO), LocationUtils.getMinY(a2.sO));
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.b((a)object);
        }
    }

    @InternalApi
    public static class HighlightColorSetting
    implements ColorSetting {
        private String aH;

        public HighlightColorSetting(String name) {
            this.aH = name;
        }

        @Override
        public String name() {
            return this.aH;
        }

        @Override
        public String getTyp() {
            return "OPTION";
        }
    }
}

