/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter.impl.datasource;

import com.inet.annotations.InternalApi;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi
public class IteratorBasedResultSet
implements ResultSet {
    private final String[] pZ;
    private final List<String> qa;
    private final Iterator<Object[]> qb;
    private Object[] qc;
    private int[] qd;

    public IteratorBasedResultSet(String[] columns, int[] types) {
        this(columns, types, Collections.emptyIterator());
    }

    public IteratorBasedResultSet(String[] columns, int[] types, Iterator<Object[]> rows) {
        this.qd = types;
        int n = columns.length;
        this.pZ = columns;
        this.qa = new ArrayList<String>(n);
        for (int i = 0; i < columns.length; ++i) {
            this.qa.add(columns[i].toUpperCase());
        }
        this.qb = rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IteratorBasedResultSet(ResultSet originalRs) throws SQLException {
        try {
            Object[] objectArray;
            ResultSetMetaData resultSetMetaData = originalRs.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.pZ = new String[n];
            this.qa = new ArrayList<String>(n);
            this.qd = new int[n];
            for (int i = 0; i < n; ++i) {
                this.pZ[i] = objectArray = resultSetMetaData.getColumnName(i + 1);
                this.qa.add(objectArray.toUpperCase());
                this.qd[i] = resultSetMetaData.getColumnType(i + 1);
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while (originalRs.next()) {
                objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = originalRs.getObject(i + 1);
                }
                arrayList.add(objectArray);
            }
            this.qb = arrayList.iterator();
        }
        finally {
            try {
                originalRs.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public String[] getColumnNames() {
        return this.pZ;
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean next() throws SQLException {
        if (this.qb.hasNext()) {
            this.qc = this.qb.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return Double.parseDouble(object.toString());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object != null ? Float.parseFloat(object.toString()) : 0.0f;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object != null ? Integer.parseInt(object.toString()) : 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object != null ? Long.parseLong(object.toString()) : 0L;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object != null ? Short.parseShort(object.toString()) : (short)0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return Boolean.getBoolean(object.toString());
    }

    @Override
    public boolean relative(int rowsToMove) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.qc == null) {
            throw new SQLException("Cursor position is not in a valid row");
        }
        return this.qc[columnIndex - 1];
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object != null ? object.toString() : null;
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int n = this.qa.indexOf(columnName.toUpperCase());
        if (n == -1) {
            throw new SQLException("Column '" + columnName + "' does not exist");
        }
        return 1 + n;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new IteratorResultSetMetaData(this.pZ, this.qd);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("unsupported method call");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public class IteratorResultSetMetaData
    implements ResultSetMetaData {
        private final String[] qe;
        private final int[] qd;

        public IteratorResultSetMetaData(String[] columns, int[] types) {
            this.qe = columns;
            this.qd = types;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.qe.length;
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int isNullable(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.qe[column - 1];
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            return this.qe[column - 1];
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int getScale(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return null;
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            if (this.qd != null) {
                return this.qd[column - 1];
            }
            return 0;
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            throw new SQLException("unsupported method call");
        }
    }
}

