/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.logging.Logger;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.error.PresenterExceptionData;
import com.inet.pdfc.generator.model.DifferencePages;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.FileNameUtil;
import com.inet.pdfc.util.Pair;
import com.inet.plugin.NamedExtension;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

@PublicApi
public abstract class BasePresenter
implements NamedExtension {
    public static final int MAX_FILENAME_LENGTH = 201;
    public static final Logger LOGGER = PDFCCore.LOGGER_PRESENTER;
    private a oE = new a();
    private List<PresenterExceptionData> oF = new LinkedList<PresenterExceptionData>();
    private BasePresenter oG;
    private ResultModel model;

    protected void onClear() throws Exception {
    }

    protected void onInit() throws Exception {
    }

    protected void onDataUpdate() throws Exception {
    }

    protected abstract void onComparisonDone() throws Exception;

    protected void onFinish() {
    }

    protected void onError(ExceptionData error, boolean interrupted, ERROR_SOURCE source) {
    }

    protected void onFilterChange() throws Exception {
    }

    protected void onProgressUpdate(float progress) {
    }

    public void executeImmediately(ResultModel model) throws Exception {
        Serializable serializable;
        PdfcSession pdfcSession = null;
        boolean bl = false;
        if (!PdfcSession.hasSession()) {
            serializable = model.getPageImageCache();
            if (serializable == null) {
                serializable = new PdfcRenderCache();
                bl = true;
            }
            if (!(serializable instanceof PdfcRenderCache)) {
                throw new IllegalStateException("The page image cache of the passed model is of an unsupported type(" + serializable.getClass().getName() + "). Please create a custom PdfcSession before calling executeImmediately()");
            }
            PdfcRenderCache pdfcRenderCache = (PdfcRenderCache)serializable;
            pdfcSession = PdfcSession.createSession(pdfcRenderCache);
            pdfcSession.setThreadLocal();
            pdfcSession.getStoreMap().initFontMap();
        }
        if (model == null && this.getModel() == null) {
            throw new IllegalStateException("Cannot execute a presenter without any kind of result model");
        }
        serializable = this.getModel();
        if (model != null) {
            this.setModel(model);
        }
        this.onClear();
        this.onInit();
        if (!this.model.isEmpty()) {
            this.onDataUpdate();
        }
        this.onComparisonDone();
        this.detachFromModel();
        this.setModel((ResultModel)serializable);
        if (pdfcSession != null) {
            if (bl) {
                pdfcSession.getStoreMap().clear();
            }
            pdfcSession.cleanUp();
            pdfcSession.resetThreadLocal();
        }
    }

    public void setModel(ResultModel newModel) {
        if (this.model != null) {
            this.model.removeChangeListener(this.oE);
        }
        this.model = newModel;
        if (newModel != null) {
            this.model.addChangeListener(this.oE);
        }
    }

    protected ResultModel getModel() {
        return this.model;
    }

    public void detachFromModel() {
        this.model.removeChangeListener(this.oE);
    }

    protected String getDefaultExportName(String presenterType) {
        return FileNameUtil.getDefaultExportName(presenterType, this.getModel(), this);
    }

    public String createExportFilename(String presenterType, String n1, String n2) {
        return FileNameUtil.createExportFilename(presenterType, n1, n2);
    }

    public PresenterExceptionData getLastPresenterException() {
        if (this.oF.isEmpty()) {
            return null;
        }
        return this.oF.get(this.oF.size() - 1);
    }

    public List<PresenterExceptionData> getPresenterExceptions() {
        return new LinkedList<PresenterExceptionData>(this.oF);
    }

    public BasePresenter spawn(boolean spawnWithParent) {
        Class<?> clazz = this.getClass();
        BasePresenter basePresenter = null;
        if (this instanceof Cloneable) {
            try {
                basePresenter = (BasePresenter)this.clone();
                basePresenter.oE = basePresenter.new a();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                PDFCCore.LOGGER_PRESENTER.debug((Object)cloneNotSupportedException);
            }
        }
        if (basePresenter == null) {
            try {
                basePresenter = (BasePresenter)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                PdfcException pdfcException = PdfcException.create((ErrorCode)PdfcErrorCode.spawnNotImplemented, reflectiveOperationException, clazz.getSimpleName());
                PDFCCore.LOGGER_PRESENTER.error((Throwable)((Object)pdfcException));
                throw new IllegalStateException((Throwable)((Object)pdfcException));
            }
        }
        if (spawnWithParent) {
            this.setParent(this);
        }
        if (basePresenter != null) {
            basePresenter.oF = this.oF;
        }
        return basePresenter;
    }

    protected void setParent(BasePresenter parent) {
        this.oG = parent;
    }

    protected BasePresenter getParent() {
        return this.oG;
    }

    int c(Modification modification) {
        int n = -1;
        DifferencePages differencePages = modification.getDifferencePages(true);
        if (differencePages == null) {
            differencePages = modification.getDifferencePages(false);
        }
        if (differencePages != null) {
            n = differencePages.getStartPage();
        }
        return n;
    }

    protected boolean canInformUserOnErrors() {
        return false;
    }

    private class a
    implements ResultModel.ResultModelChangeListener {
        private a() {
        }

        @Override
        public void modelChanged(ResultModel.ChangeInfo change) {
            try {
                switch (change.getType()) {
                    case CLEARED: {
                        BasePresenter.this.onClear();
                        return;
                    }
                    case INIT: {
                        BasePresenter.this.onInit();
                        return;
                    }
                    case COMPLETED: {
                        BasePresenter.this.onComparisonDone();
                        return;
                    }
                    case FILTER_CHANGE: {
                        BasePresenter.this.onFilterChange();
                        return;
                    }
                    case INCREMENTAL: {
                        BasePresenter.this.onDataUpdate();
                        return;
                    }
                    case HIGHLIGHT_UPDATE: {
                        return;
                    }
                    case PROGRESS_UPDATE: {
                        BasePresenter.this.onProgressUpdate(change.getProgress());
                        return;
                    }
                }
                LOGGER.warn((Object)("Unknown data update event '" + String.valueOf((Object)change.getType()) + "'"));
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)((Object)PdfcException.create(exception)));
                String string = BasePresenter.this.getModel().getComparisonParameters().getFirstFile().getPath();
                String string2 = BasePresenter.this.getModel().getComparisonParameters().getSecondFile().getPath();
                BasePresenter.this.oF.add(new PresenterExceptionData(ExceptionDataFactory.createExceptionData(exception), BasePresenter.this.getExtensionName(), new Pair<String>(string, string2)));
            }
        }

        @Override
        public boolean errorOcurred(ExceptionData error, boolean interrupted, ERROR_SOURCE source) {
            BasePresenter.this.onError(error, interrupted, source);
            return BasePresenter.this.canInformUserOnErrors();
        }
    }

    public static final class ERROR_SOURCE
    extends Enum<ERROR_SOURCE> {
        public static final /* enum */ ERROR_SOURCE PREPARE = new ERROR_SOURCE();
        public static final /* enum */ ERROR_SOURCE FIRST_PDF = new ERROR_SOURCE();
        public static final /* enum */ ERROR_SOURCE SECOND_PDF = new ERROR_SOURCE();
        public static final /* enum */ ERROR_SOURCE COMPARE = new ERROR_SOURCE();
        private static final /* synthetic */ ERROR_SOURCE[] oI;

        public static ERROR_SOURCE[] values() {
            return (ERROR_SOURCE[])oI.clone();
        }

        public static ERROR_SOURCE valueOf(String name) {
            return Enum.valueOf(ERROR_SOURCE.class, name);
        }

        private static /* synthetic */ ERROR_SOURCE[] cs() {
            return new ERROR_SOURCE[]{PREPARE, FIRST_PDF, SECOND_PDF, COMPARE};
        }

        static {
            oI = ERROR_SOURCE.cs();
        }
    }
}

