/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.diff;

import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.i18n.Msg;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

@JsonData
public class CurvePointDiff
extends AttributeDifference<Point2D.Double> {
    private static final NumberFormat NUMBER_FORMAT = DecimalFormat.getIntegerInstance();

    public CurvePointDiff(Point2D.Double oldValue, Point2D.Double newValue, PointType type) {
        super(AttributeDifference.TYPE.CURVE_POINT, oldValue, newValue, "module.lines.curves.diff." + String.valueOf((Object)type));
    }

    @Override
    protected String formatValue(Point2D.Double p) {
        return "(" + NUMBER_FORMAT.format(p.getX()) + ", " + NUMBER_FORMAT.format(p.getY()) + ")";
    }

    @Override
    public String getMessage() {
        if (this.getOldValue() == null && this.getNewValue() == null) {
            return super.getMessage();
        }
        return Msg.getMsg(this.getMessageKey(), this.formatValue((Point2D.Double)this.getOldValue()), this.formatValue((Point2D.Double)this.getNewValue()));
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }

    public static final class PointType
    extends Enum<PointType> {
        public static final /* enum */ PointType pointStart = new PointType();
        public static final /* enum */ PointType point1 = new PointType();
        public static final /* enum */ PointType point2 = new PointType();
        public static final /* enum */ PointType pointEnd = new PointType();
        private static final /* synthetic */ PointType[] fY;

        public static PointType[] values() {
            return (PointType[])fY.clone();
        }

        public static PointType valueOf(String name) {
            return Enum.valueOf(PointType.class, name);
        }

        private static /* synthetic */ PointType[] aY() {
            return new PointType[]{pointStart, point1, point2, pointEnd};
        }

        static {
            fY = PointType.aY();
        }
    }
}

