/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.pdfc.PDFC;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.DirectoryPdfSource;
import com.inet.pdfc.config.FilePdfSource;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.error.PresenterExceptionData;
import com.inet.pdfc.generator.ComparatorProperty;
import com.inet.pdfc.generator.InvalidLicenseException;
import com.inet.pdfc.generator.PDFParserTask;
import com.inet.pdfc.generator.filter.FilterFactory;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.ComparatorFactory;
import com.inet.pdfc.plugin.interfaces.CompareRunner;
import com.inet.pdfc.plugin.interfaces.CompareRunnerFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@PublicApi
public class PDFComparer {
    private IProfile profile = new DefaultProfile();
    private List<BasePresenter> r = new ArrayList<BasePresenter>();
    private CompletableFuture<ResultModel> ax;
    private Settings settings = new DefaultSetting();

    public PDFComparer() throws RuntimeException, InvalidLicenseException {
        StackTraceElement[] stackTraceElementArray;
        boolean bl = true;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Exception().getStackTrace()) {
            if (!PDFC.class.getName().equals(stackTraceElement.getClassName())) continue;
            bl = false;
        }
        try {
            PDFParserTask.checkLicense(true, bl, !bl, false);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            String string = Msg.getMsg("License.ActivationForAPI", "PDFC.requestAndSetTrialLicenseIfRequired()");
            PDFCCore.LOGGER_CORE.fatal((Object)string);
            if (bl) {
                throw new InvalidLicenseException(string);
            }
            if (LogManager.getLogStream() != System.out) {
                System.out.println(string);
            }
            System.exit(2);
        }
    }

    public PDFComparer setProfile(IProfile profile) {
        DefaultProfile defaultProfile;
        String string;
        this.profile = profile;
        if (profile instanceof DefaultProfile) {
            PDFCCorePlugin.configureLogging((DefaultProfile)profile, true);
        }
        if (profile instanceof DefaultProfile && (string = (defaultProfile = (DefaultProfile)profile).getProperties().getProperty(PDFCProperty.EXPORT_PDF_ALWAYS.name())) != null) {
            boolean bl = profile.getBool(PDFCProperty.EXPORT_PDF_ALWAYS);
            this.settings.setEnabled(!bl, Settings.EXPORT.ONLY_ON_DIFFERENCES);
        }
        return this;
    }

    public PDFComparer setProfile(String profileID) throws IllegalArgumentException {
        Object object;
        if (profileID == null) {
            throw new IllegalArgumentException("Cannot set a profile with ID 'null'. To reset the profile use setProfile( IProfile ) instead");
        }
        profileID = new GUID(profileID).toString();
        ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)ServerPluginManager.getInstance().getSingleInstance(ProfilePersistenceManager.class);
        try {
            object = profilePersistenceManager.getUserProfile(UserManager.getInstance().getCurrentUserAccountID(), profileID);
            if (object != null) {
                this.setProfile(((ProfilePersistence)object).getProfile());
                return this;
            }
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
        object = DynamicExtensionManager.getInstance().get(ProfilePersistence.class);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ProfilePersistence profilePersistence = (ProfilePersistence)iterator.next();
            if (!profileID.equals(profilePersistence.getGUID().toString())) continue;
            this.setProfile(profilePersistence.getProfile());
            return this;
        }
        throw new IllegalArgumentException("There is no profile with name or id '" + profileID + "' registered.");
    }

    public PDFComparer addPresenter(BasePresenter presenter) {
        this.r.add(presenter);
        return this;
    }

    public ResultModel compare(File document1, File document2) throws PdfcException {
        return this.compare(new FilePdfSource(document1), new FilePdfSource(document2));
    }

    CompareRunner k() {
        CompareRunner compareRunner = CompareRunnerFactory.createRunner();
        compareRunner.setSettings(this.settings);
        compareRunner.setProfile(this.profile);
        compareRunner.setPresenters(this.r);
        compareRunner.setComparerProperty(ComparatorProperty.createTextSelectionData, Boolean.toString(this.isCreateTextSelectionData()));
        return compareRunner;
    }

    public ResultModel compare(PdfSource pdf1, PdfSource pdf2) throws PdfcException {
        try {
            return this.k().compare(pdf1, pdf2).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable != null) {
                throw PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileComparing, throwable, new Object[0]);
            }
            throw PdfcException.create(exception);
        }
    }

    public void batchCompare(File directory1, File directory2) {
        PDFCCore.LOGGER_CORE.info((Object)"Checking directories for documents to compare as batch");
        this.batchCompare(new DirectoryPdfSource(directory1), new DirectoryPdfSource(directory2));
    }

    public void batchCompare(DirectoryPdfSource directory1, DirectoryPdfSource directory2) {
        this.k().batchCompare(directory1, directory2);
    }

    protected boolean isCreateTextSelectionData() {
        return false;
    }

    public PDFComparer setSettings(Settings settings) {
        DefaultProfile defaultProfile;
        String string;
        this.settings = settings;
        if (this.profile instanceof DefaultProfile && (string = (defaultProfile = (DefaultProfile)this.profile).getProperties().getProperty(PDFCProperty.EXPORT_PDF_ALWAYS.name())) != null) {
            boolean bl = this.profile.getBool(PDFCProperty.EXPORT_PDF_ALWAYS);
            settings.setEnabled(!bl, Settings.EXPORT.ONLY_ON_DIFFERENCES);
        }
        return this;
    }

    public CompletableFuture<ResultModel> compareAsync(PdfSource document1, PdfSource document2) {
        if (!(this.ax == null || this.r.size() <= 0 || this.ax.isCancelled() || this.ax.isCompletedExceptionally() || this.ax.isDone())) {
            throw new IllegalStateException("To compare several documents in parallel, please either use batchCompre() or create a new PDFComparer per document pair. Otherwise the registered presenters may created corrupted results.");
        }
        this.ax = this.k().compare(document1, document2);
        this.ax.thenRun(() -> {
            this.ax = null;
        });
        return this.ax;
    }

    public static List<String> getAvailableCompareModeKeys() {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerPluginManager.getInstance().get(ComparatorFactory.class);
        list.forEach(comparatorFactory -> arrayList.add(comparatorFactory.getExtensionName()));
        return arrayList;
    }

    public static List<String> getAvailableFilterKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(FilterFactory.getAvailableInputFilterKeys());
        arrayList.addAll(FilterFactory.getAvailableResultFilterKeys());
        return arrayList;
    }

    public List<PresenterExceptionData> getPresenterExceptions() {
        ArrayList<PresenterExceptionData> arrayList = new ArrayList<PresenterExceptionData>();
        for (BasePresenter basePresenter : this.r) {
            PresenterExceptionData presenterExceptionData = basePresenter.getLastPresenterException();
            if (presenterExceptionData == null) continue;
            arrayList.add(presenterExceptionData);
        }
        return arrayList;
    }

    static {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
    }
}

