/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.CoreUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StringListUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmailUserFieldDefinition
extends StringListUserFieldDefinition
implements CoreUserFieldDefinition {
    public EmailUserFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_string_list", prio);
    }

    @Override
    public FieldValue getFieldValue(UserAccount userAccount) {
        String string = "";
        UserField userField = UserManager.getRecoveryEnabledInstance().getField(this.getFieldKey());
        if (userAccount != null) {
            string = (String)userAccount.getValue(userField);
        }
        if (string == null) {
            string = (String)userField.getDefaultValue();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(EmailAddressHelper.get().getValidEmailAddressesFrom(string));
        FieldValue fieldValue = new FieldValue(new Json().toJson(arrayList));
        fieldValue.setVisibleInPreview(arrayList.size() > 0);
        fieldValue.setEnabled(this.isEnabled());
        return fieldValue;
    }

    @Override
    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object value) {
        String string = this.a(value);
        super.save(userAccount, userUpdateData, string);
    }

    @Override
    public void validate(Object value) throws ClientMessageException {
        String string = this.a(value);
        super.validate(string);
    }

    private String a(Object object) {
        List list = (List)object;
        return EmailAddressHelper.get().convertEmailAddressesToString(list, false);
    }

    @Override
    public boolean isBatchEditable() {
        return true;
    }

    @Override
    public String getLabel() {
        return UsersAndGroups.FIELD_EMAIL.getLabel();
    }

    @Override
    public List<String> getDefaultValue() {
        String string = (String)UsersAndGroups.FIELD_EMAIL.getDefaultValue();
        if (string != null) {
            return EmailAddressHelper.get().getValidEmailAddressesFrom(string);
        }
        return Collections.emptyList();
    }
}

