/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import javax.annotation.Nonnull;

@InternalApi
public class GroupType {
    public static final int NAME_LENGTH_LIMIT = 100;
    @Nonnull
    private final String a;

    @Nonnull
    public static GroupType of(String name) {
        return new GroupType(name);
    }

    private GroupType(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty after trim");
        }
        if (name.length() > 100) {
            String string = String.format("length of the name must not exceed limit of %d characters: %s", 100, name);
            throw new IllegalArgumentException(string);
        }
        this.a = name.toLowerCase();
    }

    @Nonnull
    public String getName() {
        return this.a;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupType groupType = (GroupType)obj;
        return this.a.equals(groupType.a);
    }

    public String toString() {
        return "GroupType-" + this.a;
    }
}

