/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.ui.Type;
import java.util.Objects;

@JsonData
public class Hash {
    private Type type;
    private GUID id;

    private Hash() {
    }

    public static Hash forUser(GUID userAccountID) {
        return new Hash(Type.user, userAccountID);
    }

    public static Hash forGroup(GUID groupID) {
        return new Hash(Type.group, groupID);
    }

    public Hash(Type type, GUID id) {
        this.type = type;
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public GUID getId() {
        return this.id;
    }

    public String toString() {
        return this.type.name() + "\n" + (this.id == null ? "" : this.id);
    }

    public static Hash valueOf(String value) {
        String[] stringArray = value.split("\n");
        GUID gUID = null;
        if (stringArray.length > 1 && !StringFunctions.isEmpty(stringArray[1])) {
            gUID = GUID.valueOf(stringArray[1]);
        }
        return new Hash(Type.valueOf(stringArray[0]), gUID);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hash hash = (Hash)obj;
        if (!Objects.equals(this.id, hash.id)) {
            return false;
        }
        return this.type == hash.type;
    }
}

