/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Version
implements Comparable<Version> {
    public static final boolean IS_TECHNICAL_BUILD = false;
    private String a;
    private int b;
    private int c;
    private int d;
    private int e;
    @Nonnull
    private static Version f = new Version(AccessController.doPrivileged(() -> System.getProperty("java.version")));

    public Version(String version) {
        if (version == null) {
            this.a = String.valueOf(version);
            return;
        }
        this.a = version;
        version = ((String)version).trim() + ".";
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < ((String)version).length(); ++i2) {
            int n4;
            char c2 = ((String)version).charAt(i2);
            if (Character.isDigit(c2)) continue;
            String string = ((String)version).substring(n3, i2);
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = string.isEmpty() && ((String)version).substring(i2).matches("\\$\\{.+\\}.*?") ? Integer.MAX_VALUE : 0;
            }
            switch (n2) {
                case 0: {
                    this.b = n4;
                    break;
                }
                case 1: {
                    this.c = n4;
                    break;
                }
                case 2: {
                    this.d = n4;
                    break;
                }
                case 3: {
                    this.e = n4;
                    return;
                }
            }
            ++n2;
            n3 = i2 + 1;
            if (c2 == '.') continue;
            return;
        }
    }

    public boolean isHigherOrEquals(Version ref) {
        return this.compareTo(ref) >= 0;
    }

    public boolean isHigherThan(Version ref) {
        return this.compareTo(ref) > 0;
    }

    @Override
    public int compareTo(Version ref) {
        if (this.b != ref.b) {
            return this.b - ref.b;
        }
        if (this.c != ref.c) {
            return this.c - ref.c;
        }
        if (this.d != ref.d) {
            return this.d - ref.d;
        }
        return this.e - ref.e;
    }

    public int getMajor() {
        return this.b;
    }

    public int getMinor() {
        return this.c;
    }

    public int getBuild() {
        return this.d;
    }

    public int getMicroBuild() {
        return this.e;
    }

    @Nonnull
    public String toString() {
        return this.a;
    }

    @Nonnull
    public static Version getJavaVersion() {
        return f;
    }

    @Nonnull
    public static String getTechnicalBuildSuffix() {
        Date date = Version.getTechnicalBuildExpirationDate();
        if (date != null) {
            return " Technical Build (valid until " + DateFormat.getDateInstance(3).format(date) + ")";
        }
        return "";
    }

    @Nullable
    public static Date getTechnicalBuildExpirationDate() {
        return null;
    }
}

