/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.util.Scope;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.persistence.Persistence;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.search.AbstractIndexSearchEngine;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataType;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.ConditionTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.ApiSearchTag;
import com.inet.search.index.FileSearchIndexPersistence;
import com.inet.search.index.IdType;
import com.inet.search.index.IndexerStatus;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.SearchResultHolderSeries;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.SearchTagProvider;
import com.inet.search.index.SuggestedTag;
import com.inet.search.index.TagIndex;
import com.inet.search.index.e;
import com.inet.search.index.f;
import com.inet.search.index.g;
import com.inet.search.index.l;
import com.inet.search.index.m;
import com.inet.search.index.n;
import com.inet.search.index.o;
import com.inet.search.index.q;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.SameThreadExecutorService;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class IndexSearchEngine<ID>
extends AbstractIndexSearchEngine
implements SearchTagProvider {
    public static final I18nMessages MSG = new I18nMessages("com.inet.search.i18n.LanguageResources", IndexSearchEngine.class);
    public static final Logger LOGGER = LogManager.getLogger("IndexSearchEngine");
    public static final Set CANCEL_RESULT = Collections.unmodifiableSet(Collections.EMPTY_SET);
    @Nonnull
    public static final Predicate MATCH_ALL = object -> true;
    @Nonnull
    public static final Predicate MATCH_NONE = object -> false;
    static final int MAX_TOKEN_SIZE = 100;
    private final f a;
    private Map<SearchTag, TagIndex<ID>> b = new LinkedHashMap<SearchTag, TagIndex<ID>>();
    private Map<String, SearchTag> c = new LinkedHashMap<String, SearchTag>();
    private Set<SearchTag> d;
    private List<TokenMatcher<ID>> e;
    private final e<ID> f;
    private SearchDataCache<ID> g;
    private final SearchIndexPersistence<ID> h;
    private final String i;
    @Nonnull
    private final IdType<ID> j;
    private final boolean k;
    private int l = -1;
    private long m = -1L;
    private IndexSearchEngine<ID> n;
    private final WeakValueMap<SearchID, SearchResultHolder<ID>> o = new WeakValueMap();
    private Thread p;
    private ServerLock q;
    private int r;
    private Notification s;
    private SearchTag t;

    public IndexSearchEngine() {
        this(null, null, false, Object.class);
    }

    public IndexSearchEngine(@Nullable String name, @Nullable String reindexKey, boolean useOriginalInRecoveryMode, @Nonnull Class<ID> idType) {
        this(name, reindexKey, useOriginalInRecoveryMode, idType, true);
    }

    public IndexSearchEngine(@Nullable String name, @Nullable String reindexKey, boolean useOriginalInRecoveryMode, @Nonnull Class<ID> idType, boolean blocking) {
        this(name, reindexKey, useOriginalInRecoveryMode, new IdType<ID>(idType), blocking);
    }

    public IndexSearchEngine(@Nullable String name, @Nullable String reindexKey, boolean useOriginalInRecoveryMode, @Nonnull IdType<ID> idType, boolean blocking) {
        this(IndexSearchEngine.a(name, useOriginalInRecoveryMode), reindexKey, idType, blocking, false);
    }

    public IndexSearchEngine(@Nonnull FileSearchIndexPersistence<ID> persistence, @Nullable String reindexKey, @Nonnull Class<ID> idType) {
        this(persistence, reindexKey, new IdType<ID>(idType), true, false);
    }

    private IndexSearchEngine(@Nonnull SearchIndexPersistence<ID> persistence, @Nullable String reindexKey, @Nonnull IdType<ID> idType, boolean blocking, boolean isReindex) {
        this.a = new f(blocking);
        this.f = new e<ID>(this.b, this.a, persistence);
        this.h = persistence;
        persistence.setEngine(this);
        this.i = reindexKey;
        this.j = idType;
        this.k = isReindex;
        LOGGER.debug("Index " + this.a() + " created");
    }

    @Nonnull
    private static <ID> SearchIndexPersistence<ID> a(@Nullable String string, boolean bl) {
        if (string == null) {
            return new FileSearchIndexPersistence(null);
        }
        Persistence persistence = bl ? Persistence.getRecoveryEnabledInstance() : Persistence.getInstance();
        return persistence.getSearchIndexPersistence(string);
    }

    private void a(@Nonnull List<TagIndex<ID>> list) {
        Map<String, String> map = this.h.loadIndexAttributes();
        if (map == null) {
            return;
        }
        try {
            TagIndex<ID> tagIndex22;
            boolean bl;
            boolean bl2;
            if (map.size() == 0) {
                bl2 = true;
                if (this.i != null) {
                    bl = false;
                    for (TagIndex<ID> tagIndex22 : this.b.values()) {
                        if (tagIndex22.isNew() || tagIndex22.getDataType() == SearchDataType.Api) continue;
                        LOGGER.info("Reindex " + this.a() + " because attributes was not loaded");
                        bl = true;
                        break;
                    }
                } else {
                    bl = false;
                }
            } else if (!Objects.equals(this.i, map.get("key"))) {
                LOGGER.info("Reindex " + this.a() + " because key has changed from " + map.get("key") + " to " + this.i);
                bl = true;
                bl2 = true;
            } else {
                bl2 = false;
                bl = false;
            }
            Set set = this.b.values().stream().map(tagIndex -> tagIndex.getTag()).collect(Collectors.toSet());
            tagIndex22 = map.get("tags");
            if (tagIndex22 == null) {
                bl2 = true;
            } else {
                try {
                    HashSet hashSet = new Json().fromJson((String)((Object)tagIndex22), HashSet.class);
                    if (!Objects.equals(set, hashSet)) {
                        if (hashSet.containsAll(set)) {
                            bl2 = true;
                        } else {
                            HashSet hashSet2 = new HashSet(set);
                            hashSet2.removeAll(hashSet);
                            Set set2 = list.stream().map(tagIndex -> tagIndex.getTag()).collect(Collectors.toSet());
                            if (hashSet2.containsAll(set2)) {
                                LOGGER.info("Reindex " + this.a() + " because new tags in index: " + String.valueOf(hashSet2));
                                bl = true;
                                list.clear();
                            } else {
                                for (TagIndex<ID> tagIndex3 : this.b.values()) {
                                    if (!hashSet2.contains(tagIndex3.getTag()) || list.contains(tagIndex3)) continue;
                                    list.add(tagIndex3);
                                }
                            }
                            bl2 = true;
                        }
                    }
                }
                catch (Throwable throwable) {
                    bl2 = true;
                }
            }
            if (!this.k && bl) {
                this.h.markForReindex();
            }
            if (bl2) {
                map.put("key", this.i);
                map.put("tags", new Json().toJson(set));
                this.h.saveIndexAttributes(map);
            }
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
        }
    }

    public void addTag(SearchTag searchTag) throws IOException, IllegalStateException {
        if (this.g != null) {
            throw new IllegalStateException("SearchDataCache already set.");
        }
        TagIndex<ID> tagIndex = IndexSearchEngine.createTagIndex(searchTag, this.h);
        this.b.put(searchTag, tagIndex);
        this.c.put(searchTag.getTag(), searchTag);
    }

    public void addTokenMatcher(@Nonnull TokenMatcher<ID> matcher) {
        if (this.e == null) {
            this.e = new ArrayList<TokenMatcher<ID>>();
        }
        this.e.add(matcher);
    }

    public void removeTokenMatcher(@Nonnull TokenMatcher<ID> matcher) {
        if (this.e == null) {
            return;
        }
        this.e.remove(matcher);
    }

    @Nullable
    public List<TokenMatcher<ID>> getTokenMatcher() {
        return this.e == null ? null : Collections.unmodifiableList(this.e);
    }

    @Override
    @Nullable
    public SearchTag getTag(@Nonnull String key) {
        return this.c.get(key);
    }

    public void setPrimaryTag(@Nonnull SearchTag primarySearchTag) {
        if (!this.b.containsKey(primarySearchTag)) {
            throw new IllegalArgumentException();
        }
        this.t = primarySearchTag;
    }

    @Nullable
    TagIndex<ID> a(SearchTag searchTag) {
        return this.b.get(searchTag);
    }

    @Override
    @Nonnull
    public Set<SearchTag> getTags() {
        if (this.d == null) {
            throw new IllegalStateException("SearchDataCache was not set.");
        }
        return this.d;
    }

    @Nonnull
    public List<SuggestedValue> getSuggestedValues(@Nullable String phrase, final int maxValues, final @Nullable Set<SearchTag> suggestedTags) {
        return this.getSuggestedValues(phrase, new SuggestedValuesFilter<ID>(){

            @Override
            public int getMaxValues() {
                return maxValues;
            }

            @Override
            public Collection<SearchTag> getSearchTags() {
                return suggestedTags;
            }

            @Override
            public Collection<TokenMatcher<ID>> getTokenMatchers() {
                return IndexSearchEngine.this.e;
            }
        });
    }

    @Nonnull
    public List<SuggestedValue> getSuggestedValues(@Nullable String phrase, SuggestedValuesFilter<ID> filter) {
        if (filter == null) {
            filter = new SuggestedValuesFilter();
        }
        return new q<ID>(this, filter).a(phrase);
    }

    private String a() {
        String string = this.h.getName();
        if (string != null) {
            return string;
        }
        if (this.g != null) {
            return this.g.getClass().getName();
        }
        return "";
    }

    @Nonnull
    private String b() {
        Object object = this.h.getName();
        if (object == null) {
            object = this.g.getClass().getName() + System.identityHashCode(this);
        }
        return "reindex-" + (String)object;
    }

    @Nonnull
    public IdType<ID> getIdType() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTagsAndReindex(List<SearchTag> removed, List<SearchTag> added) throws IOException {
        LOGGER.info("Change tags of index " + this.a());
        this.a.f();
        try {
            Object object;
            this.h.saveOutstanding();
            for (SearchTag tagIndexArray : removed) {
                this.b.remove(tagIndexArray);
                String string = tagIndexArray.getTag();
                this.c.remove(string);
                this.h.deleteTag(string);
            }
            ArrayList arrayList = new ArrayList();
            for (SearchTag searchTag : added) {
                object = IndexSearchEngine.createTagIndex(searchTag, this.h);
                this.b.put(searchTag, (TagIndex<ID>)object);
                this.c.put(searchTag.getTag(), searchTag);
                arrayList.add(object);
            }
            this.d = Collections.unmodifiableSet(new LinkedHashSet<SearchTag>(this.b.keySet()));
            if (this.g != null && arrayList.size() > 0) {
                TagIndex[] tagIndexArray = arrayList.toArray(new TagIndex[arrayList.size()]);
                Runnable runnable = () -> {
                    e<ID> e2 = this.f;
                    synchronized (e2) {
                        ServerLock serverLock = this.b(false);
                        this.a.b();
                        try {
                            this.a(this.g, this.r, tagIndexArray);
                        }
                        finally {
                            this.a.c();
                            this.a(serverLock);
                        }
                    }
                };
                this.p = new Thread(runnable, "Indexing Main " + this.a());
                object = this.p;
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
            }
        }
        finally {
            this.a.g();
        }
    }

    public void setData(SearchDataCache<ID> cache) throws IOException, IllegalStateException {
        this.setData(cache, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(SearchDataCache<ID> cache, int threadCount) throws IOException, IllegalStateException {
        boolean bl;
        block21: {
            this.r = threadCount;
            ArrayList<TagIndex<ID>> arrayList = new ArrayList<TagIndex<ID>>(this.b.values());
            TagIndex[] tagIndexArray = arrayList.iterator();
            while (tagIndexArray.hasNext()) {
                if (((TagIndex)tagIndexArray.next()).isNew()) continue;
                tagIndexArray.remove();
            }
            this.a(arrayList);
            tagIndexArray = arrayList.toArray(new TagIndex[arrayList.size()]);
            bl = true;
            this.a.b();
            try {
                this.a.f();
                try {
                    if (this.g != null) {
                        throw new IllegalStateException("SearchDataCache already set.");
                    }
                    this.g = cache;
                    this.d = Collections.unmodifiableSet(new LinkedHashSet<SearchTag>(this.b.keySet()));
                    if (!this.a.a() && this.h.needReindex()) {
                        LOGGER.info("Reindex async " + this.a() + " because index was mark for reindexing. Can be in a previous server run.");
                        this.reIndexAsync();
                        bl = false;
                    }
                    if (tagIndexArray.length == 0) {
                        bl = false;
                    } else if (!SearchIndexPersistence.isReindex(this.a())) {
                        LOGGER.info("Reindex " + this.a() + " because new tags " + String.valueOf(arrayList.stream().map(tagIndex -> tagIndex.getTag()).collect(Collectors.toList())));
                    }
                }
                finally {
                    this.a.g();
                }
                if (bl) {
                    if (this.a.a()) {
                        this.a(cache, threadCount, tagIndexArray);
                    } else {
                        Runnable runnable = () -> {
                            ServerLock serverLock = this.b(false);
                            try {
                                this.a(cache, threadCount, tagIndexArray);
                            }
                            finally {
                                this.a(serverLock);
                            }
                        };
                        Thread thread = this.p = new Thread(runnable, "Indexing Main " + this.a());
                        thread.setDaemon(true);
                        thread.start();
                    }
                    break block21;
                }
                this.a.f();
                try {
                    cache.addChangeListener(this.f);
                }
                finally {
                    this.a.g();
                }
            }
            finally {
                this.a.c();
            }
        }
        if (bl) {
            this.h.saveOutstanding();
        }
        if (this.a.a() && this.h.needReindex()) {
            LOGGER.info("Reindex async " + this.a() + " because index was mark for reindexing. Can be in a previous server run.");
            this.reIndexAsync();
            bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SearchDataCache<ID> searchDataCache, int n2, TagIndex<ID>[] tagIndexArray) {
        String string = this.a();
        LOGGER.info("Start Indexing: " + string + " on thread " + Thread.currentThread().getName());
        l<ID> l2 = null;
        if (this.a.a()) {
            l2 = new l<ID>();
            searchDataCache.addChangeListener(l2);
        } else {
            searchDataCache.addChangeListener(this.f);
        }
        this.l = 0;
        this.m = System.currentTimeMillis();
        ExecutorService executorService = n2 <= 0 ? new SameThreadExecutorService() : Executors.newFixedThreadPool(n2, runnable -> {
            Thread thread = new Thread(runnable, "Indexing " + string);
            thread.setDaemon(true);
            return thread;
        });
        Object var7_7 = null;
        try {
            ArrayDeque<Future<a<ID>>> arrayDeque = new ArrayDeque<Future<a<ID>>>();
            Iterator<ID> iterator = searchDataCache.iterator();
            while (iterator.hasNext()) {
                Object ID;
                var7_7 = iterator.next();
                ++this.l;
                Callable<a> callable = () -> {
                    a a2;
                    block5: {
                        a2 = new a();
                        a2.a = ID;
                        try {
                            Map<String, Object> map = searchDataCache.getCacheEntry(ID);
                            if (map == null) break block5;
                            int n2 = tagIndexArray.length;
                            a2.b = new Object[n2 * 2];
                            Object[] objectArray = a2.b;
                            for (int i2 = 0; i2 < n2; ++i2) {
                                Object object2;
                                TagIndex tagIndex = tagIndexArray[i2];
                                SearchTag searchTag = tagIndex.getSearchTag();
                                if (searchTag.getDataType() == SearchDataType.Api) continue;
                                String string2 = searchTag.getTag();
                                try {
                                    object2 = map.get(string2);
                                }
                                catch (Throwable throwable) {
                                    LOGGER.error("Unexpected excption when indexing id '" + String.valueOf(ID) + "' for tag '" + string2 + "' of index '" + string + "'", throwable);
                                    continue;
                                }
                                if (object2 == null && !map.containsKey(string2)) continue;
                                objectArray[2 * i2] = tagIndex;
                                objectArray[2 * i2 + 1] = tagIndex.b(ID, object2);
                            }
                        }
                        catch (Throwable throwable) {
                            LOGGER.error("Unexpected excption when indexing id '" + String.valueOf(ID) + "' of index '" + string + "'", throwable);
                            throw throwable;
                        }
                    }
                    return a2;
                };
                arrayDeque.add(executorService.submit(callable));
                this.a(arrayDeque, n2 * 2);
                if (this.a.a() || this.l % 1000 != 0) continue;
                this.f.b();
            }
            this.a(arrayDeque, 0);
            for (int i2 = 0; i2 < tagIndexArray.length; ++i2) {
                tagIndexArray[i2].finishIndexing();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error(string + ", last id: " + String.valueOf(var7_7) + " indexCount: " + this.l, throwable);
            throw throwable;
        }
        finally {
            executorService.shutdown();
            if (!SearchIndexPersistence.isReindex(string)) {
                this.l = -1;
                this.m = 0L;
            }
            if (this.a.a()) {
                this.a.f();
                try {
                    searchDataCache.addChangeListener(this.f);
                    searchDataCache.removeChangeListener(l2);
                    l2.a(this.f);
                }
                finally {
                    this.a.g();
                }
            }
        }
        LOGGER.info("Indexing of " + this.a() + " finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ArrayDeque<Future<a<ID>>> arrayDeque, int n2) {
        while (arrayDeque.size() > 0) {
            Future<a<ID>> future;
            Iterator<Future<a<ID>>> iterator;
            Future<a<ID>> future2 = arrayDeque.peek();
            if (!future2.isDone()) {
                if (arrayDeque.size() <= n2) {
                    return;
                }
                future2 = null;
                iterator = arrayDeque.iterator();
                while (iterator.hasNext()) {
                    future = iterator.next();
                    if (!future.isDone()) continue;
                    future2 = future;
                    iterator.remove();
                    break;
                }
                if (future2 == null) {
                    future2 = arrayDeque.poll();
                }
            } else {
                future2 = arrayDeque.poll();
            }
            iterator = null;
            try {
                future = future2.get();
                iterator = ((a)((Object)future)).a;
                Object[] objectArray = ((a)((Object)future)).b;
                if (objectArray == null) continue;
                this.a.d();
                try {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        TagIndex tagIndex = (TagIndex)objectArray[n3++];
                        Object object = objectArray[n3++];
                        if (tagIndex == null) continue;
                        tagIndex.c(iterator, object);
                    }
                }
                finally {
                    this.a.e();
                }
            }
            catch (Throwable throwable) {
                LOGGER.error("Unexpected excption when indexing id '" + String.valueOf(iterator) + "' of index '" + this.a() + "'", throwable);
            }
        }
    }

    void a(@Nullable Throwable throwable) {
        String string = this.a();
        if (SearchIndexPersistence.isReindex(string)) {
            if (this.s == null) {
                Object object = MSG.getMsg("ReindexOnReindex", string);
                if (throwable != null) {
                    object = (String)object + "\n" + StringFunctions.getUserFriendlyErrorMessage(throwable);
                }
                Notification notification = this.s = new Notification("Error", (String)object);
                notification.setCritical(true);
                notification.setTargetUrl("diagnostics/logging");
                NotificationManager.getInstance().sendNotificationToAllAdministrators(notification);
            }
            throw new IllegalStateException("Reindex on reindex of " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reIndexAsync() {
        this.getTags();
        f f2 = this.a;
        synchronized (f2) {
            if (!this.isReindexRunning()) {
                LOGGER.info("Reindex " + this.a() + " triggered from " + ThreadUtils.getCallerName(1));
                Thread thread = this.p = new Thread("Reindex " + this.a()){

                    @Override
                    public void run() {
                        try {
                            IndexSearchEngine.this.a(false);
                        }
                        catch (Throwable throwable) {
                            LOGGER.error(throwable);
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                return true;
            }
        }
        return false;
    }

    public int getRunningIndexCount() {
        IndexSearchEngine<ID> indexSearchEngine = this.n;
        return indexSearchEngine != null ? indexSearchEngine.l : this.l;
    }

    public long getRunningStartTime() {
        IndexSearchEngine<ID> indexSearchEngine = this.n;
        return indexSearchEngine != null ? indexSearchEngine.m : this.m;
    }

    public boolean isReindexRunning() {
        if (this.q != null | this.p != null) {
            return true;
        }
        if (Persistence.isFilePersistence()) {
            return this.q != null;
        }
        try (ServerLock serverLock = Persistence.getInstance().tryLock(this.b());){
            boolean bl = serverLock == null;
            return bl;
        }
    }

    public boolean isIndexThread() {
        return this.p != null && Thread.currentThread() == this.p;
    }

    public IndexerStatus getIndexerStatus(long toBeIndexed) {
        return new IndexerStatus(this.a(), this.isReindexRunning(), this.getRunningIndexCount(), toBeIndexed, this.getRunningStartTime());
    }

    public void reIndex() throws IOException {
        this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(boolean bl) throws IOException {
        String string = this.a();
        ServerLock serverLock = this.b(bl);
        if (serverLock == null) {
            block22: {
                Thread thread = this.p;
                if (bl) {
                    LOGGER.debug("Waiting on Reindex: " + string);
                    try {
                        if (thread != null) {
                            thread.join();
                            break block22;
                        }
                        do {
                            Thread.sleep(1000L);
                        } while ((serverLock = Persistence.getInstance().tryLock(this.b())) == null);
                        serverLock.close();
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.debug(interruptedException);
                    }
                } else if (thread == Thread.currentThread()) {
                    this.p = null;
                }
            }
            return;
        }
        LOGGER.debug("Reindex: " + string);
        Set<SearchTag> set = this.getTags();
        SearchIndexPersistence<ID> searchIndexPersistence = null;
        try {
            this.f.a();
            this.a((Throwable)null);
            searchIndexPersistence = this.h.copy();
            IndexSearchEngine<ID> indexSearchEngine = new IndexSearchEngine<ID>(searchIndexPersistence, this.i, this.j, true, true);
            this.n = indexSearchEngine;
            for (SearchTag object : set) {
                indexSearchEngine.addTag(object);
            }
            indexSearchEngine.setData(this.g, this.r);
            searchIndexPersistence.saveOutstanding();
            indexSearchEngine.a.f();
            try {
                this.a.f();
                try {
                    indexSearchEngine.g.removeChangeListener(indexSearchEngine.f);
                    this.h.replaceWith(searchIndexPersistence, indexSearchEngine.b);
                    this.b.clear();
                    this.b.putAll(indexSearchEngine.b);
                }
                finally {
                    this.a.g();
                }
            }
            finally {
                indexSearchEngine.a.g();
            }
            for (SearchResultListener searchResultListener : this.f.c()) {
                this.a(searchResultListener, true);
            }
        }
        catch (Throwable throwable) {
            if (searchIndexPersistence != null) {
                searchIndexPersistence.delete();
            }
            throw throwable;
        }
        finally {
            this.a(serverLock);
            this.n = null;
            this.f.a(-1, null);
        }
        LOGGER.debug("Reindex finish: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerLock b(boolean bl) {
        f f2 = this.a;
        synchronized (f2) {
            ServerLock serverLock = this.q;
            if (serverLock == null) {
                this.q = Persistence.getInstance().tryLock(this.b());
                serverLock = this.q;
                if (serverLock != null) {
                    this.l = 0;
                    if (!bl) {
                        this.p = Thread.currentThread();
                    }
                }
                if (serverLock == null) {
                    LOGGER.info("No index lock received for " + this.a());
                }
                return serverLock;
            }
            LOGGER.info("Index " + this.a() + " already locked");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(@Nullable ServerLock serverLock) {
        if (serverLock != null) {
            f f2 = this.a;
            synchronized (f2) {
                serverLock.close();
                this.q = null;
                this.p = null;
                this.l = -1;
            }
        }
        this.f.b();
    }

    @Nonnull
    private Set<Map.Entry<SearchTag, TagIndex<ID>>> a(@Nonnull SearchCommand searchCommand) {
        Set<Map.Entry<SearchTag, TagIndex<Object>>> set = this.b.entrySet();
        Set<SearchTag> set2 = searchCommand.getTags();
        if (set2 != null && !Objects.equals(this.getTags(), set2)) {
            set = set.stream().filter(entry -> set2.contains(entry.getKey())).collect(Collectors.toSet());
        }
        return set;
    }

    @Nullable
    private List<TokenMatcher<ID>> b(@Nonnull SearchCommand searchCommand) {
        List list = searchCommand.getTokenMatcher();
        return list == null ? this.e : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<ID> simpleSearch(@Nonnull SearchCommand command) {
        SearchResultHolder searchResultHolder;
        AndSearchExpression andSearchExpression = command.getSearchExpression();
        SearchResultHolder searchResultHolder2 = searchResultHolder = this.j.getNodeType() == 'S' ? new SearchResultHolderSeries() : new o();
        if (!this.a(command, searchResultHolder)) {
            return new HashSet();
        }
        Set<Map.Entry<SearchTag, TagIndex<ID>>> set = this.a(command);
        List<TokenMatcher<ID>> list = this.b(command);
        this.a.h();
        try (Scope scope = ClientLocale.scope(command.getLocale());){
            this.a(searchResultHolder, (SearchExpression)andSearchExpression, set, list);
            List list2 = command.getFilters();
            if (list2 != null) {
                for (Predicate predicate : list2) {
                    searchResultHolder.filter(predicate);
                }
            }
            searchResultHolder.e();
        }
        finally {
            this.a.i();
        }
        return searchResultHolder.getResultLimit() == 0 ? CANCEL_RESULT : (Set)searchResultHolder.f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public SearchResult<ID> search(SearchCommand command) {
        AndSearchExpression andSearchExpression = command.getSearchExpression();
        Map<String, Integer> map = command.getPriorities();
        List list = command.getFilters();
        n n2 = new n(this);
        if (!this.a(command, n2)) {
            return new SearchResult(new ArrayList(), true);
        }
        Set<Map.Entry<SearchTag, TagIndex<ID>>> set = this.a(command);
        List<TokenMatcher<ID>> list2 = this.b(command);
        ArrayList arrayList = new ArrayList();
        this.a.h();
        try (Scope scope = ClientLocale.scope(command.getLocale());){
            this.a(n2, (SearchExpression)andSearchExpression, set, list2);
            n2.e();
            if (!n2.d()) {
                this.a(n2, command.getVisibleBoostingExpressions(), set, list2);
                n2.m();
                this.a(n2, command.getBoostingExpressions(), set, list2);
            }
        }
        finally {
            this.a.i();
        }
        block8: for (g g2 : n2.k()) {
            if (list != null) {
                for (Predicate predicate : list) {
                    if (predicate.test(g2.getId())) continue;
                    continue block8;
                }
            }
            arrayList.add(g2);
            g2.a(map);
            if (n2.getResultLimit() != 0) continue;
            break;
        }
        Collections.sort(arrayList);
        return new SearchResult(arrayList, n2.l());
    }

    private boolean a(SearchCommand searchCommand, SearchResultHolder<ID> searchResultHolder) {
        searchResultHolder.a(searchCommand.getResultLimit());
        SearchID searchID = searchCommand.getID();
        if (searchID != null) {
            Map.Entry<SearchID, SearchResultHolder<ID>> entry = this.o.getEntry(searchID);
            if (entry != null) {
                if (entry.getKey().getTimestamp() <= searchID.getTimestamp()) {
                    entry.getValue().a(0);
                } else {
                    return false;
                }
            }
            this.o.put(searchID, searchResultHolder);
        }
        return true;
    }

    public void cancel(@Nonnull SearchID id) {
        Map.Entry<SearchID, SearchResultHolder<ID>> entry = this.o.getEntry(id);
        if (entry != null) {
            entry.getValue().a(0);
        }
    }

    private void a(n<ID> n2, @Nullable List<SearchExpression> list, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list2) {
        if (list != null) {
            for (SearchExpression searchExpression : list) {
                n2.b();
                this.a(n2, searchExpression, set, list2);
                n2.c();
                n2.j();
            }
        }
    }

    private void a(SearchResultHolder<ID> searchResultHolder, SearchExpression searchExpression, Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        searchResultHolder.a(true);
        switch (searchExpression.getType()) {
            case Condition: {
                this.a(searchResultHolder, (SearchCondition)searchExpression, set, list);
                break;
            }
            case And: {
                this.a(searchResultHolder, (AndSearchExpression)searchExpression, set, list);
                break;
            }
            case Or: {
                this.a(searchResultHolder, (OrSearchExpression)searchExpression, set, list);
                break;
            }
            case Pre: {
                this.a(searchResultHolder, (PrefilteredSearchExpression)searchExpression);
                break;
            }
            case Phrase: {
                this.a(searchResultHolder, (PhraseSearchExpression)searchExpression, set, list);
                break;
            }
            case Subtract: {
                this.a(searchResultHolder, (SubtractSearchExpression)searchExpression, set, list);
            }
        }
        searchResultHolder.a(false);
    }

    private void a(SearchResultHolder<ID> searchResultHolder, @Nonnull AndSearchExpression andSearchExpression, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        andSearchExpression = com.inet.search.index.m.a(andSearchExpression);
        int n2 = andSearchExpression.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SearchExpression searchExpression = (SearchExpression)andSearchExpression.get(i2);
            searchResultHolder.b(i2 == n2 - 1);
            searchResultHolder.b();
            this.a(searchResultHolder, searchExpression, set, list);
            searchResultHolder.c();
            if (searchResultHolder.d()) break;
        }
        searchResultHolder.b(false);
    }

    private void a(SearchResultHolder<ID> searchResultHolder, OrSearchExpression orSearchExpression, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        block3: for (SearchExpression searchExpression : orSearchExpression) {
            SearchExpression.Type type = searchExpression.getType();
            switch (type) {
                case Condition: 
                case Or: 
                case Pre: {
                    this.a(searchResultHolder, searchExpression, set, list);
                    continue block3;
                }
            }
            SearchResultHolder<ID> searchResultHolder2 = searchResultHolder.a();
            this.a(searchResultHolder2, searchExpression, set, list);
            searchResultHolder.a(searchResultHolder2);
        }
    }

    private <CONTAINER> void a(SearchResultHolder<ID> searchResultHolder, SubtractSearchExpression subtractSearchExpression, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        SearchResultHolder<ID> searchResultHolder2 = searchResultHolder.a();
        searchResultHolder2.b();
        this.a(searchResultHolder2, subtractSearchExpression.getRight(), set, list);
        searchResultHolder2.c();
        searchResultHolder.b(searchResultHolder2);
    }

    private void a(SearchResultHolder<ID> searchResultHolder, PrefilteredSearchExpression prefilteredSearchExpression) {
        searchResultHolder.a(prefilteredSearchExpression.getIDs());
    }

    private <CONTAINER> void a(SearchResultHolder<ID> searchResultHolder, PhraseSearchExpression phraseSearchExpression, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        String string = phraseSearchExpression.getLeftOperand();
        if (string == null) {
            Object object;
            SuggestedTag suggestedTag;
            searchResultHolder.b();
            for (Map.Entry<SearchTag, TagIndex<ID>> object2 : set) {
                suggestedTag = object2.getKey();
                if (!((SearchTag)suggestedTag).isSuggestedTag()) continue;
                object = searchResultHolder.a();
                this.a((SearchResultHolder<ID>)object, phraseSearchExpression, (SearchTag)suggestedTag, set, list);
                searchResultHolder.a((SearchResultHolder<ID>)object);
            }
            if (list != null) {
                for (TokenMatcher tokenMatcher : list) {
                    if (!tokenMatcher.isSuggestedTag() || tokenMatcher.getType() != TokenMatcher.Type.Condition || !(suggestedTag = (ConditionTokenMatcher)tokenMatcher).isUsedForFreeSearch() || !((object = suggestedTag.createSearchExpression(phraseSearchExpression.getPhrase(), phraseSearchExpression.getOperator(), true, false)) instanceof SearchCondition)) continue;
                    SearchCondition searchCondition = (SearchCondition)object;
                    this.a(searchResultHolder, searchCondition, set, list);
                }
            }
            searchResultHolder.c();
        } else {
            SearchTag searchTag = this.c.get(string);
            if (searchTag != null) {
                this.a(searchResultHolder, phraseSearchExpression, searchTag, set, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <CONTAINER> void a(SearchResultHolder<ID> searchResultHolder, PhraseSearchExpression phraseSearchExpression, @Nonnull SearchTag searchTag, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        Object object;
        String string = phraseSearchExpression.getPhrase();
        Collection<String> collection = phraseSearchExpression.getTokens();
        if (string.isEmpty() || phraseSearchExpression.getOperator() != SearchCondition.SearchTermOperator.Equals) {
            SearchExpression searchExpression;
            if (searchResultHolder.a && this.t != null) {
                searchResultHolder.b();
                searchExpression = new SearchCondition(this.t.getTag(), SearchCondition.SearchTermOperator.StartsWith, "");
                this.a((SearchResultHolder<ID>)searchResultHolder, (SearchCondition)searchExpression, set, list);
                searchResultHolder.c();
            }
            searchExpression = string.isEmpty() ? new SearchCondition(searchTag.getTag(), SearchCondition.SearchTermOperator.StartsWith, "") : new PhraseSearchExpression(phraseSearchExpression.getLeftOperand(), SearchCondition.SearchTermOperator.Equals, string, phraseSearchExpression.getTokens());
            this.a(searchResultHolder, new SubtractSearchExpression(searchExpression), set, list);
            return;
        }
        searchResultHolder.b();
        try {
            switch (searchTag.getDataType()) {
                case String: 
                case ID: 
                case IntegerMap: 
                case StringMap: {
                    break;
                }
                case Api: {
                    SearchCondition searchCondition = new SearchCondition(searchTag.getTag(), SearchCondition.SearchTermOperator.Equals, string, true);
                    ((ApiSearchTag)searchTag).search(searchCondition, searchResultHolder, string);
                    return;
                }
                default: {
                    return;
                }
            }
            object = this.b.get(searchTag);
            SearchResultHolder<Object> searchResultHolder2 = searchResultHolder.a();
            SearchCondition searchCondition = new SearchCondition(searchTag.getTag(), SearchCondition.SearchTermOperator.Equals, string, true);
            ((TagIndex)object).searchToken(string, searchCondition, searchResultHolder);
            switch (searchTag.getDataType()) {
                case IntegerMap: 
                case StringMap: {
                    return;
                }
            }
            for (String string2 : collection) {
                searchResultHolder2.b();
                searchCondition = new SearchCondition(searchTag.getTag(), SearchCondition.SearchTermOperator.Equals, string2, true);
                ((TagIndex)object).searchToken(string2, searchCondition, searchResultHolder2);
                searchResultHolder2.c();
            }
            searchResultHolder.a(searchResultHolder2);
        }
        finally {
            searchResultHolder.c();
        }
        if (searchResultHolder.d()) {
            return;
        }
        object = PhraseSearchExpression.normalize(string);
        if (collection.size() == 1 && ((String)object).equalsIgnoreCase(collection.iterator().next())) {
            return;
        }
        try {
            this.a.i();
            long l2 = System.currentTimeMillis() + 20000L;
            searchResultHolder.filter(arg_0 -> this.a(searchResultHolder, l2, searchTag, (String)object, arg_0));
            return;
        }
        finally {
            this.a.h();
        }
    }

    private void a(final SearchResultHolder<ID> searchResultHolder, final SearchCondition searchCondition, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        this.a(new b<ID>(){

            @Override
            void a(@Nonnull TagIndex<ID> tagIndex) {
                tagIndex.getAllIds(searchResultHolder, searchCondition);
            }

            @Override
            void a(@Nonnull TagIndex<ID> tagIndex, @Nonnull Object object, SearchCondition searchCondition2) {
                tagIndex.searchToken(object, searchCondition2, searchResultHolder);
            }
        }, searchCondition, set, list);
    }

    private void a(b<ID> b2, SearchCondition searchCondition, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list) {
        Object object;
        Object object3;
        String string = searchCondition.getLeftOperand();
        Object object4 = searchCondition.getRightOperand();
        SearchCondition.SearchTermOperator searchTermOperator = searchCondition.getOperator();
        Object[] objectArray = switch (searchTermOperator) {
            case SearchCondition.SearchTermOperator.BETWEEN, SearchCondition.SearchTermOperator.NOT_BETWEEN -> {
                object3 = (Object[])object4;
                String object22 = IndexSearchEngine.a(object3[0]);
                object = IndexSearchEngine.a(object3[1]);
                if (object22 != null && object != null) {
                    yield new Object[]{object22, object};
                }
                yield null;
            }
            default -> IndexSearchEngine.a(object4);
        };
        if (string == null) {
            Object object2;
            if ("".equals(objectArray) || objectArray == null) {
                throw new IllegalArgumentException("Empty left and right operand in search condition");
            }
            for (Map.Entry entry : set) {
                object = (SearchTag)entry.getKey();
                if (!((SearchTag)object).isSuggestedTag()) continue;
                object2 = IndexSearchEngine.a((SearchTag)object, searchCondition, searchTermOperator, objectArray, object4);
                b2.a((TagIndex)entry.getValue(), object2, searchCondition);
            }
            if (list != null) {
                for (TokenMatcher tokenMatcher : list) {
                    if (!tokenMatcher.isSuggestedTag() || tokenMatcher.getType() != TokenMatcher.Type.Condition || !(object = (ConditionTokenMatcher)tokenMatcher).isUsedForFreeSearch() || !((object2 = object.createSearchExpression((String)object4, SearchCondition.SearchTermOperator.StartsWith, false, false)) instanceof SearchCondition)) continue;
                    this.a(b2, (SearchCondition)object2, set, list);
                }
            }
        } else {
            object3 = this.c.get(string);
            if (object3 != null) {
                TagIndex<ID> tagIndex = this.b.get(object3);
                object = IndexSearchEngine.a((SearchTag)object3, searchCondition, searchTermOperator, objectArray, object4);
                if (searchTermOperator == SearchCondition.SearchTermOperator.StartsWith && ("".equals(object) || object == null)) {
                    b2.a(tagIndex);
                } else {
                    b2.a(tagIndex, object, searchCondition);
                }
            }
        }
    }

    private static String a(Object object) {
        if (object != null && object.getClass() == String.class) {
            String string = ((String)object).trim().toLowerCase();
            if (string.length() > 100) {
                string = string.substring(0, 100);
            }
            return string;
        }
        return null;
    }

    private static Object a(@Nonnull SearchTag searchTag, SearchCondition searchCondition, SearchCondition.SearchTermOperator searchTermOperator, @Nullable Object object, @Nullable Object object2) {
        if (object == null) {
            return object2;
        }
        switch (searchTag.getDataType()) {
            case ID: {
                return object2;
            }
            case StringMap: {
                if (searchTermOperator == SearchCondition.SearchTermOperator.Equals && !searchCondition.isFromTextExpression()) {
                    return object2;
                }
                return object;
            }
        }
        return object;
    }

    @Nullable
    public <T> T getMinToken(@Nonnull SearchTag searchTag) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return (T)tagIndex.getMinToken();
    }

    @Nullable
    public <T> T getMaxToken(@Nonnull SearchTag searchTag) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return (T)tagIndex.getMaxToken();
    }

    @Nonnull
    public <T> Iterator<T> createValuesIterator(@Nonnull SearchTag searchTag, @Nullable Comparable<T> startsWith, @Nonnull Predicate<ID> filter) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(true, TagIndex.IteratorType.VALUES, startsWith, filter, null);
    }

    @Nonnull
    public <T> Iterator<T> createValuesIterator(@Nonnull SearchTag searchTag, boolean forward) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(forward, TagIndex.IteratorType.VALUES, null, MATCH_ALL, null);
    }

    @Nonnull
    public <T> Iterator<T> createValuesIterator(@Nonnull SearchTag searchTag, boolean forward, @Nullable Comparable<T> startsWith, @Nonnull Predicate<ID> filter) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(forward, TagIndex.IteratorType.VALUES, startsWith, filter, null);
    }

    @Nonnull
    public Iterator<ID> createIdsIterator(@Nonnull SearchTag searchTag, boolean forward) {
        return this.createIdsIterator(searchTag, forward, MATCH_ALL);
    }

    @Nonnull
    public Iterator<ID> createIdsIterator(@Nonnull SearchTag searchTag, boolean forward, Predicate<ID> filter) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(forward, TagIndex.IteratorType.ID, null, filter, null);
    }

    @Nonnull
    public <T> Iterator<Map.Entry<T, Set<ID>>> createEntryIterator(@Nonnull SearchTag searchTag, boolean forward) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(forward, TagIndex.IteratorType.ENTRY, null, MATCH_ALL, null);
    }

    @Nonnull
    public <T> Iterator<Map.Entry<T, Set<ID>>> createEntryIterator(@Nonnull SearchTag searchTag, @Nullable Comparable<T> startsWith) {
        return this.createEntryIterator(searchTag, startsWith, MATCH_ALL);
    }

    @Nonnull
    public <T> Iterator<Map.Entry<T, Set<ID>>> createEntryIterator(@Nonnull SearchTag searchTag, @Nullable Comparable<T> startsWith, @Nonnull Predicate<ID> filter) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(true, TagIndex.IteratorType.ENTRY, startsWith, filter, null);
    }

    @Nonnull
    public <T> Iterator<Map.Entry<T, Set<ID>>> createEntryIterator(@Nonnull SearchTag searchTag, boolean forward, @Nullable Comparable<T> startsWith, @Nonnull Predicate<ID> filter) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        return tagIndex.createIterator(forward, TagIndex.IteratorType.ENTRY, startsWith, filter, null);
    }

    public int getIndexCountOfValues(@Nonnull SearchTag searchTag) {
        return this.a(searchTag, true);
    }

    public int getIndexCountOfIDs(@Nonnull SearchTag searchTag) {
        return this.a(searchTag, false);
    }

    public int getIndexCountOfIDs() {
        SearchTag searchTag = this.t;
        if (searchTag == null) {
            throw new IllegalStateException("No primary searchtag set");
        }
        int n2 = this.f.d();
        if (n2 < 0 && !this.isReindexRunning()) {
            this.a.h();
            try {
                n2 = this.a(searchTag, false);
                this.f.a(n2, searchTag);
            }
            finally {
                this.a.i();
            }
        }
        return n2;
    }

    private int a(@Nonnull SearchTag searchTag, boolean bl) {
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        int n2 = 0;
        Iterator iterator = tagIndex.createIterator(true, bl ? TagIndex.IteratorType.VALUES : TagIndex.IteratorType.ID, null, MATCH_ALL, null);
        while (iterator.hasNext()) {
            iterator.next();
            ++n2;
        }
        return n2;
    }

    public <T> Iterator<String> createDisplayValuesIterator(@Nonnull SearchTag searchTag, Comparable<T> startsWith) {
        return this.createDisplayValuesIterator(searchTag, startsWith, MATCH_ALL);
    }

    @Nonnull
    public <T> Iterator<String> createDisplayValuesIterator(@Nonnull SearchTag searchTag, Comparable<T> startsWith, @Nonnull Predicate<ID> filter) {
        Function<Object, String> function = null;
        TagIndex<ID> tagIndex = this.b.get(searchTag);
        switch (tagIndex.getDataType()) {
            case IntegerMap: 
            case StringMap: {
                String string;
                String string2;
                Map.Entry<Comparable<?>, String> entry2;
                String string3 = startsWith == null ? null : ((String)((Object)startsWith)).toLowerCase();
                HashMap hashMap = new HashMap();
                Map<Comparable<?>, String> map = searchTag.getMapData();
                for (Map.Entry<Comparable<?>, String> entry2 : map.entrySet()) {
                    string2 = entry2.getValue();
                    if (string2 == null) continue;
                    string = string2.toLowerCase();
                    if (string3 != null && !string.contains(string3)) continue;
                    hashMap.put(entry2.getKey(), (String)entry2.getValue());
                }
                ArrayList arrayList = new ArrayList();
                entry2 = tagIndex.createIterator(true, TagIndex.IteratorType.VALUES, null, filter, null);
                while (entry2.hasNext()) {
                    String string4;
                    string2 = entry2.next();
                    string = (String)hashMap.get(string2);
                    if (string != null) {
                        arrayList.add(string);
                        continue;
                    }
                    if (!searchTag.showAlsoNonMapValues() || map.containsKey(string2) || string2 == null || (string4 = string2.toString()).isEmpty() || string3 != null && !string4.contains(string3)) continue;
                    arrayList.add(string2.toString());
                }
                arrayList.sort(Collator.getInstance(ClientLocale.getThreadLocale()));
                return arrayList.iterator();
            }
            case Integer: {
                try {
                    if (startsWith == null || startsWith.getClass() != String.class) break;
                    if (StringFunctions.isEmpty((String)((Object)startsWith))) {
                        startsWith = null;
                        break;
                    }
                    startsWith = Integer.valueOf((String)((Object)startsWith));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return Collections.emptyIterator();
                }
            }
            case Date: {
                DateFormat dateFormat = DateFormat.getDateInstance(3, ClientLocale.getThreadLocale());
                function = object -> dateFormat.format(object);
            }
            case Long: {
                try {
                    if (startsWith == null || startsWith.getClass() != String.class) break;
                    if (StringFunctions.isEmpty((String)((Object)startsWith))) {
                        startsWith = null;
                        break;
                    }
                    startsWith = Long.valueOf((String)((Object)startsWith));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return Collections.emptyIterator();
                }
            }
            case Double: {
                try {
                    if (startsWith != null && startsWith.getClass() == String.class) {
                        if (StringFunctions.isEmpty((String)((Object)startsWith))) {
                            startsWith = null;
                        } else {
                            Number number = NumberFormat.getInstance(ClientLocale.getThreadLocale()).parse((String)((Object)startsWith));
                            startsWith = number.doubleValue();
                        }
                    }
                }
                catch (NumberFormatException | ParseException exception) {
                    return Collections.emptyIterator();
                }
                NumberFormat numberFormat = NumberFormat.getInstance(ClientLocale.getThreadLocale());
                if (numberFormat instanceof DecimalFormat) {
                    ((DecimalFormat)numberFormat).setMaximumFractionDigits(Integer.MAX_VALUE);
                }
                function = object -> numberFormat.format(object);
            }
        }
        if (function == null) {
            function = object -> object.toString();
        }
        return tagIndex.createIterator(true, TagIndex.IteratorType.VALUES, (Comparable<?>)((Object)startsWith), filter, function);
    }

    public void addSearchResultListener(@Nonnull SearchResultListener<ID> listener) {
        listener.a(this);
        this.a(listener, true);
        this.f.a(listener);
    }

    public void removeSearchResultListener(@Nonnull SearchResultListener<ID> listener) {
        this.a(listener, false);
        this.f.b(listener);
        listener.a(null);
    }

    private void a(@Nonnull SearchResultListener<ID> searchResultListener, boolean bl) {
        SearchCommand searchCommand = searchResultListener.getCommand();
        Set<Map.Entry<SearchTag, TagIndex<ID>>> set = this.a(searchCommand);
        List<TokenMatcher<ID>> list = this.b(searchCommand);
        List<SearchExpression> list2 = searchCommand.getSearchExpression();
        this.a(searchResultListener, bl, list2, set, list);
        list2 = searchCommand.getBoostingExpressions();
        if (list2 != null) {
            this.a(searchResultListener, bl, list2, set, list);
        }
    }

    private void a(final @Nonnull SearchResultListener<ID> searchResultListener, final boolean bl, List<SearchExpression> list, @Nonnull Set<Map.Entry<SearchTag, TagIndex<ID>>> set, @Nullable List<TokenMatcher<ID>> list2) {
        for (SearchExpression searchExpression : list) {
            switch (searchExpression.getType()) {
                case And: 
                case Or: {
                    this.a(searchResultListener, bl, (ArrayList)((Object)searchExpression), set, list2);
                    break;
                }
                case Condition: {
                    this.a(new b<ID>(){

                        @Override
                        void a(@Nonnull TagIndex<ID> tagIndex) {
                            tagIndex.a(searchResultListener, bl);
                        }

                        @Override
                        void a(@Nonnull TagIndex<ID> tagIndex, @Nonnull Object object, SearchCondition searchCondition) {
                            tagIndex.handleTokenChangedListener(object, searchCondition, searchResultListener, bl);
                        }
                    }, (SearchCondition)searchExpression, set, list2);
                    break;
                }
                case Phrase: {
                    PhraseSearchExpression phraseSearchExpression = (PhraseSearchExpression)searchExpression;
                    ArrayList<SearchExpression> arrayList = new ArrayList<SearchExpression>();
                    for (String string : phraseSearchExpression.getTokens()) {
                        arrayList.add(new SearchCondition(phraseSearchExpression.getLeftOperand(), SearchCondition.SearchTermOperator.Equals, string));
                    }
                    this.a(searchResultListener, bl, arrayList, set, list2);
                    break;
                }
                case Subtract: {
                    SubtractSearchExpression subtractSearchExpression = (SubtractSearchExpression)searchExpression;
                    this.a(searchResultListener, bl, Collections.singletonList(subtractSearchExpression.getRight()), set, list2);
                }
            }
        }
    }

    public void dumpTo(PrintStream target) throws IOException {
        for (TagIndex<ID> tagIndex : this.b.values()) {
            target.println(tagIndex.getTag());
            tagIndex.dumpTo(target);
        }
    }

    private /* synthetic */ boolean a(SearchResultHolder searchResultHolder, long l2, SearchTag searchTag, String string, Object object) {
        if (searchResultHolder.getResultLimit() == 0) {
            return false;
        }
        if (System.currentTimeMillis() > l2) {
            return true;
        }
        Map<String, Object> map = this.g.getCacheEntry(object);
        if (map == null) {
            return false;
        }
        Object object2 = map.get(searchTag.getTag());
        return searchTag.isPhraseContainsIn(string, object2);
    }

    private static class a<ID> {
        private ID a;
        private Object[] b;

        private a() {
        }
    }

    static abstract class b<ID> {
        b() {
        }

        abstract void a(@Nonnull TagIndex<ID> var1);

        abstract void a(@Nonnull TagIndex<ID> var1, @Nonnull Object var2, SearchCondition var3);
    }
}

