/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.command;

import com.inet.annotations.InternalApi;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ApiSearchCommandBuilder {
    private final ArrayList<SearchExpression> a = new ArrayList();
    private OrSearchExpression b;

    @Nonnull
    public SearchCommand build() {
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[0]);
        AndSearchExpression andSearchExpression = searchCommand.getSearchExpression();
        if (this.b != null) {
            if (this.b.size() == 1) {
                andSearchExpression.remove(andSearchExpression.size() - 1);
                andSearchExpression.add((SearchExpression)this.b.get(0));
            }
            this.b = null;
        }
        andSearchExpression.addAll(this.a);
        return searchCommand;
    }

    @Nonnull
    public ApiSearchCommandBuilder or() {
        ArrayList<SearchExpression> arrayList = this.a;
        if (arrayList.size() > 0) {
            SearchExpression searchExpression = arrayList.remove(arrayList.size() - 1);
            if (searchExpression.getType() != SearchExpression.Type.Or) {
                OrSearchExpression orSearchExpression = this.b = new OrSearchExpression();
                orSearchExpression.add(searchExpression);
            } else {
                this.b = (OrSearchExpression)searchExpression;
            }
            arrayList.add(this.b);
        }
        return this;
    }

    @Nonnull
    public ApiSearchCommandBuilder startsWith(@Nonnull String key, @Nonnull String value) {
        assert (key != null);
        assert (value != null && !value.isEmpty());
        return this.addSearchExpression(new SearchCondition(key, SearchCondition.SearchTermOperator.StartsWith, value));
    }

    @Nonnull
    public ApiSearchCommandBuilder anyStartsWith(@Nonnull String value) {
        assert (value != null && !value.isEmpty());
        return this.addSearchExpression(new SearchCondition(null, SearchCondition.SearchTermOperator.StartsWith, value));
    }

    @Nonnull
    public ApiSearchCommandBuilder equals(@Nonnull String key, @Nullable Object value) {
        assert (key != null);
        return this.addSearchExpression(new SearchCondition(key, SearchCondition.SearchTermOperator.Equals, value));
    }

    @Nonnull
    public ApiSearchCommandBuilder anyEquals(@Nullable Object value) {
        return this.addSearchExpression(new SearchCondition(null, SearchCondition.SearchTermOperator.Equals, value));
    }

    @Nonnull
    public ApiSearchCommandBuilder withValue(@Nonnull String key) {
        assert (key != null);
        return this.addSearchExpression(new SearchCondition(key, SearchCondition.SearchTermOperator.StartsWith, ""));
    }

    @Nonnull
    public ApiSearchCommandBuilder anyWithValue() {
        return this.addSearchExpression(new SearchCondition(null, SearchCondition.SearchTermOperator.StartsWith, ""));
    }

    @Nonnull
    public ApiSearchCommandBuilder withoutValue(@Nonnull String key) {
        assert (key != null);
        return this.addSearchExpression(new PhraseSearchExpression(key, SearchCondition.SearchTermOperator.Equals, "", Collections.emptySet()));
    }

    @Nonnull
    public ApiSearchCommandBuilder addSearchExpression(@Nonnull SearchExpression expr) {
        ArrayList arrayList;
        assert (expr != null);
        if (this.b != null) {
            arrayList = this.b;
            this.b = null;
        } else {
            arrayList = this.a;
        }
        if (!arrayList.contains(expr)) {
            arrayList.add(expr);
        }
        return this;
    }
}

