/*
 * Decompiled with CFR 0.152.
 */
package com.inet.process;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.http.security.CombinedProvider;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.PreferencesUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.Logger;
import com.inet.logging.StartupLogger;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistenceFactory;
import com.inet.process.a;
import com.inet.process.b;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ProcessStarter {
    public static final boolean DEBUG = DebugUtils.DEBUG;
    public static final String RESTART_EXITCODE = "restart.exitcode";
    private static final int RESTART_EXITVALUE = 100;
    public static final String APP_DATA_PATH = "AppDataPath";
    public static final String UPDATE_PATH = "pending-update";

    public static boolean start(Class<?> mainClass, String[] args, String config, @Nonnull String corePluginId) {
        CombinedProvider.getKeystoreType();
        if (DEBUG) {
            System.out.println("Starting in debug mode: " + String.valueOf(ManagementFactory.getRuntimeMXBean().getInputArguments()));
            return false;
        }
        if (System.getProperty(RESTART_EXITCODE) == null) {
            ProcessStarter.a(mainClass, args, config, corePluginId);
            return true;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (System.in.read() != -1) {
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                System.out.println("Parent process terminated. Stopping myself!");
                System.exit(0);
            }
        }, "Server Starter Monitor");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
        try {
            b.registerHandler();
            a.registerHandler();
        }
        catch (Throwable throwable) {
            String string = StringFunctions.getUserFriendlyErrorMessage(throwable);
            System.err.println("The signal handler for restarting the sub-proces using SIGTERM is not available: " + string);
        }
        return false;
    }

    private static void a(final Class<?> clazz, final String[] stringArray, final String string, final @Nonnull String string2) throws IllegalStateException {
        Process[] processArray;
        if (ConfigurationManager.ISINIT) {
            processArray = null;
            if (processArray == null) {
                processArray = new IllegalStateException("ConfigurationManager was initialized in starter process.");
            }
            processArray.printStackTrace(System.err);
            System.exit(1);
        }
        processArray = new Process[1];
        new Thread(new Runnable(){

            @Override
            @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="No client parameter are used")
            public void run() {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string3 = System.getProperty("java.home");
                    arrayList.add(string3 + File.separator + "bin" + File.separator + "java");
                    RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                    List<String> list = runtimeMXBean.getInputArguments();
                    Object processBuilder = list.iterator();
                    block12: while (processBuilder.hasNext()) {
                        String object2;
                        switch (object2 = processBuilder.next()) {
                            case "exit": 
                            case "abort": {
                                continue block12;
                            }
                        }
                        if (object2.startsWith("-agentlib:jdwp=")) continue;
                        arrayList.add(object2);
                    }
                    arrayList.add("-Djava.class.path=" + runtimeMXBean.getClassPath());
                    arrayList.add("-Drestart.exitcode=100");
                    ProcessStarter.a(arrayList, string, string2);
                    arrayList.add(clazz.getName());
                    arrayList.addAll(Arrays.asList(stringArray));
                    ProcessStarter.a();
                    processBuilder = new ProcessBuilder(arrayList);
                    ((ProcessBuilder)processBuilder).redirectOutput(ProcessStarter.a(System.out));
                    ((ProcessBuilder)processBuilder).redirectError(ProcessStarter.a(System.err));
                    Process process = processArray[0] = ((ProcessBuilder)processBuilder).start();
                    ForkJoinPool.commonPool().execute(() -> {
                        try {
                            Thread.sleep(30000L);
                            System.runFinalization();
                            System.gc();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                    process.waitFor();
                    System.out.println("Sub process exit code was: " + process.exitValue());
                    switch (process.exitValue()) {
                        case 100: {
                            ProcessStarter.a(clazz, stringArray, string, string2);
                            break;
                        }
                        default: {
                            int n2 = process.exitValue();
                            if (n2 < 0) {
                                System.err.println("Sub process command line was: " + String.valueOf(arrayList));
                                System.err.flush();
                            }
                            System.exit(n2);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
        }).start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int n2;
                    Process process = processArray[0];
                    process.getOutputStream().close();
                    long l2 = System.currentTimeMillis();
                    process.waitFor(60L, TimeUnit.SECONDS);
                    try {
                        n2 = process.exitValue();
                    }
                    catch (Exception exception) {
                        n2 = 123456;
                    }
                    System.out.println("Sub process stopped after: " + (System.currentTimeMillis() - l2) + " ms with: " + n2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
        }));
    }

    private static void a(List<String> list, @Nullable String string, @Nonnull String string2) {
        block11: {
            try {
                if (!Persistence.isFilePersistence()) {
                    return;
                }
                Preferences preferences = ProcessStarter.getPreferences(string);
                if (preferences == null) break block11;
                String string3 = preferences.get("vm.maxHeapMemory", null);
                if (string3 != null && !string3.isEmpty()) {
                    try {
                        Integer.parseInt(string3);
                        list.add("-Xmx" + string3 + "m");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                    }
                }
                if ((string3 = preferences.get("vm.user.language", null)) != null && !string3.isEmpty()) {
                    list.add("-Duser.language=" + string3);
                }
                if ((string3 = preferences.get("vm.user.country", null)) != null && !string3.isEmpty()) {
                    list.add("-Duser.country=" + string3);
                }
                if ((string3 = preferences.get("vm.arguments", null)) != null && !string3.isEmpty()) {
                    for (String string4 : string3.split("\\s+")) {
                        list.add(string4);
                    }
                }
                if (Persistence.isFilePersistence()) {
                    string3 = ProcessStarter.getAppDataPath(string2, preferences, new StartupLogger());
                    list.add("-DAppDataPath=" + string3);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Nonnull
    public static String getAppDataPath(@Nonnull String corePluginId, @Nonnull Preferences prefs, @Nonnull Logger logger) throws IOException {
        String string = prefs.get(APP_DATA_PATH, null);
        return new FilePersistenceFactory(corePluginId, prefs.isUserNode() ? "User" : "System", prefs.name(), string, logger).getPersistenceFolder().toString();
    }

    @Nullable
    public static Preferences getPreferences(@Nullable String config) {
        try {
            String string = System.getProperty("clearreports.config");
            if (string != null) {
                config = string;
            }
            if (config == null) {
                return null;
            }
            int n2 = (config = config.trim()).indexOf(47);
            if (n2 < 0) {
                return null;
            }
            String string2 = config.substring(0, n2);
            String string3 = config.substring(n2 + 1);
            Preferences preferences = string2.equalsIgnoreCase("System") ? PreferencesUtils.systemRoot() : PreferencesUtils.userRoot();
            preferences.sync();
            preferences = preferences.node("/com/inet/report/config/cc");
            preferences.sync();
            if (preferences.nodeExists(string3)) {
                preferences = preferences.node(string3);
                preferences.sync();
                return preferences;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        return null;
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private static ProcessBuilder.Redirect a(FilterOutputStream filterOutputStream) {
        String string = ProcessStarter.b(filterOutputStream);
        return string == null ? ProcessBuilder.Redirect.INHERIT : ProcessBuilder.Redirect.appendTo(new File(string));
    }

    @Nullable
    private static String b(FilterOutputStream filterOutputStream) {
        try {
            OutputStream outputStream;
            Field field = FilterOutputStream.class.getDeclaredField("out");
            field.setAccessible(true);
            while ((outputStream = (OutputStream)field.get(filterOutputStream)) instanceof FilterOutputStream) {
                filterOutputStream = (FilterOutputStream)outputStream;
            }
            if (outputStream instanceof FileOutputStream) {
                field = FileOutputStream.class.getDeclaredField("path");
                field.setAccessible(true);
                String string = (String)field.get(outputStream);
                return string;
            }
        }
        catch (Throwable throwable) {
            System.out.println("Possible redirection of stdout and stderr to a file cannot be detected. Add the following command line parameters if you need the redirection: '--add-opens java.base/java.io=ALL-UNNAMED'");
        }
        return null;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private static void a() {
        try {
            URL uRL = ProcessStarter.class.getProtectionDomain().getCodeSource().getLocation();
            File file = IOFunctions.getFile(uRL);
            if (!file.getName().endsWith(".jar")) {
                return;
            }
            File file2 = file.getParentFile();
            File file3 = new File(file2, UPDATE_PATH);
            File[] fileArray = file3.listFiles();
            if (fileArray == null) {
                return;
            }
            System.out.println("Update directory found: " + String.valueOf(file3));
            for (File file4 : fileArray) {
                File file5 = new File(file2, file4.getName());
                if (file5.exists()) {
                    System.out.println("Update found: " + String.valueOf(file4));
                    try (FileInputStream fileInputStream = new FileInputStream(file4);
                         FileOutputStream fileOutputStream = new FileOutputStream(file5);){
                        fileInputStream.transferTo(fileOutputStream);
                    }
                    file5.setLastModified(file4.lastModified());
                }
                file4.delete();
            }
            file3.delete();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean isProcessStarterRunning() {
        try {
            Integer.parseInt(System.getProperty(RESTART_EXITCODE));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

