/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.image;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonData
public class AvatarMetadata {
    private String checksum;
    private long lastCheck;

    private AvatarMetadata() {
    }

    public AvatarMetadata(@Nonnull String checksum, long lastCheck) {
        if (StringFunctions.isEmpty(checksum)) {
            throw new IllegalArgumentException("checksum must not be null or empty after trim");
        }
        if (lastCheck < 0L) {
            throw new IllegalArgumentException("lastCheck must not be negative");
        }
        this.checksum = checksum;
        this.lastCheck = lastCheck;
    }

    @Nonnull
    public String getChecksum() {
        return this.checksum != null ? this.checksum : "";
    }

    public long getLastCheck() {
        return this.lastCheck > 0L ? this.lastCheck : -1L;
    }

    public int hashCode() {
        return Objects.hash(this.checksum, this.lastCheck);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvatarMetadata avatarMetadata = (AvatarMetadata)obj;
        return Objects.equals(this.checksum, avatarMetadata.checksum) && this.lastCheck == avatarMetadata.lastCheck;
    }
}

