/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto.aes;

import com.inet.persistence.crypto.CryptoAlgorithm;
import com.inet.persistence.crypto.CryptoAlgorithmFactory;
import com.inet.persistence.crypto.EncryptionData;
import com.inet.persistence.crypto.aes.AESAlgorithm;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnull;

public class AESAlgorithmFactory
implements CryptoAlgorithmFactory {
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";

    @Override
    @Nonnull
    public String getExtensionName() {
        return TRANSFORMATION;
    }

    @Override
    public boolean supports(String algorithm) {
        return TRANSFORMATION.equals(algorithm);
    }

    @Override
    public boolean supports(EncryptionData data) {
        return this.supports(data.getAlgorithm());
    }

    @Override
    public CryptoAlgorithm create(char[] password, byte[] salt, byte[] customData) throws GeneralSecurityException {
        return new AESAlgorithm(password, salt, customData);
    }
}

