/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import com.inet.mdns.MDNSInputStream;
import com.inet.mdns.MDNSOutputStream;
import com.inet.mdns.Question;
import com.inet.mdns.record.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Message {
    public static final int FLAGS_RESPONSE = 32768;
    public static final int FLAGS_AUTHORATIVE = 1024;
    private int a;
    private int b;
    private List<Question> c = new ArrayList<Question>();
    private List<Record> d = new ArrayList<Record>();
    private List<Record> e = new ArrayList<Record>();

    public static Message fromByteArray(byte[] buf, int length) {
        Message message = new Message();
        MDNSInputStream mDNSInputStream = new MDNSInputStream(buf, 0, length);
        try {
            Record record;
            int n2;
            message.a = mDNSInputStream.readUnsignedShort();
            message.b = mDNSInputStream.readUnsignedShort();
            int n3 = mDNSInputStream.readUnsignedShort();
            int n4 = mDNSInputStream.readUnsignedShort();
            int n5 = mDNSInputStream.readUnsignedShort();
            mDNSInputStream.readUnsignedShort();
            for (n2 = 0; n2 < n3; ++n2) {
                message.c.add(new Question(mDNSInputStream.readName(), mDNSInputStream.readUnsignedShort(), mDNSInputStream.readUnsignedShort()));
            }
            for (n2 = 0; n2 < n4; ++n2) {
                record = Record.read(mDNSInputStream);
                if (record == null) continue;
                message.d.add(record);
            }
            for (n2 = 0; n2 < n5; ++n2) {
                record = Record.read(mDNSInputStream);
                if (record == null) continue;
                message.e.add(record);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message;
    }

    public byte[] toByteArray() {
        MDNSOutputStream mDNSOutputStream = new MDNSOutputStream();
        mDNSOutputStream.writeShort(this.a);
        mDNSOutputStream.writeShort(this.b);
        mDNSOutputStream.writeShort(this.c.size());
        mDNSOutputStream.writeShort(this.d.size());
        mDNSOutputStream.writeShort(this.e.size());
        mDNSOutputStream.writeShort(0);
        for (Question object : this.c) {
            object.writeTo(mDNSOutputStream);
        }
        for (Record record : this.d) {
            record.writeTo(mDNSOutputStream);
        }
        for (Record record : this.e) {
            record.writeTo(mDNSOutputStream);
        }
        return mDNSOutputStream.toByteArray();
    }

    public void setFlags(int flags) {
        this.b = flags;
    }

    public String toString() {
        return "Q:" + String.valueOf(this.c) + "   A: " + String.valueOf(this.d) + "   AA: " + String.valueOf(this.e);
    }

    public void addQuestion(Question question) {
        this.c.add(question);
    }

    public void addAnswer(Record record) {
        this.d.add(record);
    }

    public void addAnswers(ArrayList<Record> records) {
        this.d.addAll(records);
    }

    public void addAuthoriativeAnswer(Record record) {
        this.e.add(record);
    }

    public List<Question> getQuestions() {
        return this.c;
    }

    List<Record> a() {
        return this.d;
    }

    List<Record> b() {
        return this.e;
    }
}

