/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.digest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DigestAuthorizationHeader {
    static final String USERNAME = "username";
    static final String REALM = "realm";
    static final String NONCE = "nonce";
    static final String NC = "nc";
    static final String CNONCE = "cnonce";
    static final String QOP = "qop";
    static final String URI = "uri";
    static final String RESPONSE = "response";
    static final String ALGORITHM = "algorithm";
    private Map<String, String> a;

    private DigestAuthorizationHeader(Map<String, String> map) {
        this.a = map;
    }

    public static DigestAuthorizationHeader from(String header) {
        String string = "Digest ";
        if (header == null || !header.startsWith(string)) {
            return null;
        }
        header = header.substring(string.length());
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(USERNAME, REALM, NONCE, NC, CNONCE, QOP, URI, RESPONSE));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : header.split(",")) {
            boolean bl;
            int n2 = string2.indexOf(61);
            if (n2 <= 0 || n2 >= string2.length()) {
                return null;
            }
            String string3 = string2.substring(0, n2).trim();
            boolean bl2 = string3.equals(ALGORITHM);
            if (!(bl2 || hashSet.contains(string3) && !hashMap.containsKey(string3))) {
                return null;
            }
            String string4 = string2.substring(n2 + 1).trim();
            boolean bl3 = string3.equals(NC) || string3.equals(QOP) || string3.equals(ALGORITHM);
            boolean bl4 = bl = string4.startsWith("\"") && string4.endsWith("\"");
            if (bl && string4.length() > 1) {
                string4 = string4.substring(1, string4.length() - 1);
            } else if (!bl3) {
                return null;
            }
            hashMap.put(string3, string4);
        }
        if (hashMap.containsKey(ALGORITHM) && "MD5".equals(hashMap.get(ALGORITHM))) {
            hashMap.remove(ALGORITHM);
        }
        if (hashMap.keySet().equals(hashSet)) {
            return new DigestAuthorizationHeader(hashMap);
        }
        return null;
    }

    public String getUsername() {
        return this.a.get(USERNAME);
    }

    public String getRealm() {
        return this.a.get(REALM);
    }

    public String getNonce() {
        return this.a.get(NONCE);
    }

    public String getNc() {
        return this.a.get(NC);
    }

    public String getCnonce() {
        return this.a.get(CNONCE);
    }

    public String getQop() {
        return this.a.get(QOP);
    }

    public String getUri() {
        return this.a.get(URI);
    }

    public String getResponse() {
        return this.a.get(RESPONSE);
    }
}

