/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.classloader.I18nMessages;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.html.css.HTML;
import com.inet.id.GUID;
import com.inet.mail.api.AttachedFile;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.mail.api.MailEncodingUtilities;
import com.inet.mail.api.PartContent;
import com.inet.mail.api.PartHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import srv.mail.MailFileMethods;

public class MessagePartsChecker {
    private static final int ERROR_MAIL = -1;
    private static final int HTML_MAIL = 1;
    private static final int TEXT_MAIL = 0;
    private static final String ERROR_MAILS = "HD_Error_Messages";
    private static final String LEER_STRING = "";
    private final int critical_plaintext_size;
    private final int critical_html_size;
    private I18nMessages emailsLangRess;
    private Map<HTML.Tag, Boolean> ignoreMap;
    private MailFileMethods mailFileMethods;

    public MessagePartsChecker(MailFileMethods mailFileMethods, I18nMessages emailsLangRess, Map<HTML.Tag, Boolean> ignoreMap, int critical_plaintext_size, int critical_html_size) {
        this.mailFileMethods = mailFileMethods;
        this.emailsLangRess = emailsLangRess;
        this.ignoreMap = ignoreMap;
        this.critical_plaintext_size = critical_plaintext_size;
        this.critical_html_size = critical_html_size;
    }

    public CheckPartsResult checkParts(ArrayList<PartHandler> list, String[] content, List<AttachedFile> allFiles, boolean imapProtokoll, String firstId) throws Exception {
        int mailType = 0;
        boolean errorInAttachment = false;
        String acknowledge = null;
        String possibleId = null;
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).checkPart(list, i - 1);
        }
        PartHandler textPart = PartHandler.getTextBodyPart(list);
        for (PartHandler part : list) {
            String end = part.getFileExtention();
            String fileN = part.getFileName();
            if (".pif".equalsIgnoreCase(end) || ".scr".equalsIgnoreCase(end)) {
                return new CheckPartsResult(possibleId, -1, acknowledge, errorInAttachment);
            }
            AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName((String)fileN, (String)end, allFiles));
            anlage.setLocation(part.getContentLocation());
            anlage.setContentID(part.getContentID());
            anlage.setFile(this.mailFileMethods.getFile(anlage.getFileName()));
            if (part.isMessage() && !"Message".equals(fileN)) {
                possibleId = fileN;
            }
            if (part.getPart() instanceof PartContent) {
                PartContent innerPart = (PartContent)part.getPart();
                this.mailFileMethods.writeToFile(anlage.getFile(), innerPart.getContent().toString(), innerPart.getTransferEncoding());
                allFiles.add(anlage);
                continue;
            }
            if (part.getPartContentString() != null) {
                this.mailFileMethods.writeToFile(anlage.getFile(), part.getPartContentString().getBytes());
                continue;
            }
            MailFileMethods.WritePartToFileResult result = this.mailFileMethods.writePartToFile(anlage.getFile(), part.getPart(), part.isMessage(), possibleId, firstId);
            possibleId = result.getPossibleId();
            if (result.isSuccess()) {
                allFiles.add(anlage);
                anlage.setDeliveryStatusPart(part.isDeliveryStatusPart());
                continue;
            }
            if (acknowledge == null) {
                acknowledge = "Attachment " + fileN;
                acknowledge = imapProtokoll ? acknowledge + "! Check: HD Error Messages" : acknowledge + "! Check: " + AppDataLocation.getAttachmentDirectory().resolve(ERROR_MAILS).getPath();
            }
            errorInAttachment = true;
        }
        if (textPart != null) {
            mailType = textPart.isHtmlPart() ? 1 : 0;
            String gmailInternalBounceInfo = textPart.getPartHeader("X-Failed-Recipients");
            if (gmailInternalBounceInfo != null && gmailInternalBounceInfo.length() > 0) {
                allFiles.add(AttachedFile.GMAIL_RFC_BOUNCE_DUMMY);
            }
            try {
                String theMessage;
                content[0] = theMessage = textPart.getContentAsString();
                mailType = this.checkMessageContent(content, mailType, allFiles);
            }
            catch (UnsupportedEncodingException ex) {
                HDLogger.error(ex);
                String ct = textPart.getContentTyp();
                if (ct.indexOf("utf-7") > -1) {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    textPart.getPart().writeTo((OutputStream)bao);
                    content[0] = MailEncodingUtilities.decodeUTF7((byte[])bao.toByteArray(), (mailType == 1 ? 1 : 0) != 0);
                    content[0] = this.removeAttachmentsFromMailbody(content[0], mailType, allFiles);
                }
                throw ex;
            }
        }
        return new CheckPartsResult(possibleId, mailType, acknowledge, errorInAttachment);
    }

    private String removeAttachmentsFromMailbody(String message, int textTyp, List<AttachedFile> allFiles) {
        int pos = message.indexOf("\r\n\r\nbegin 6");
        if (pos > -1 && this.getAttachments(message.substring(pos + 14), allFiles)) {
            message = message.substring(0, pos);
        }
        if ((pos = message.indexOf(0)) > -1) {
            HDLogger.debug("Conntent has 0 character at Position: " + pos);
            if (textTyp == 0) {
                message = message.substring(pos + 1);
            }
        }
        return message;
    }

    private boolean getAttachments(String cont, List<AttachedFile> allFiles) {
        String ext;
        String fn;
        int startpos = cont.indexOf(13) + 2;
        int endpos = cont.indexOf("\r\nend\r\n") - 1;
        if (endpos == -1) {
            HDLogger.debug("Fehler bei Attachment!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return false;
        }
        String fileName = cont.substring(0, startpos - 2);
        int dot = fileName.indexOf(46);
        if (dot > -1) {
            fn = fileName.substring(0, dot);
            ext = fileName.substring(dot);
        } else {
            fn = fileName.length() > 0 ? fileName : "Content";
            ext = ".txt";
        }
        fileName = MailAttachmentUtilities.getFileName((String)fn, (String)ext, allFiles);
        AttachedFile anl = new AttachedFile(fileName);
        anl.setFile(this.mailFileMethods.getFile(anl.getFileName()));
        this.mailFileMethods.writeToFile(anl.getFile(), MessagePartsChecker.decode(cont.substring(startpos, endpos).getBytes()));
        allFiles.add(anl);
        startpos = cont.indexOf("\r\nbegin 6", endpos);
        if (startpos > 0) {
            this.getAttachments(cont.substring(startpos + 12), allFiles);
        }
        return true;
    }

    private static String getEncoding(String content) {
        if (content != null) {
            int start = 0;
            for (int i = 1; i < content.length(); ++i) {
                if (content.charAt(i) == '<') {
                    start = i;
                    continue;
                }
                if (content.charAt(i) != '>') continue;
                String meta = content.substring(start + 1, i);
                if (meta.equalsIgnoreCase("/head") || meta.equalsIgnoreCase("body")) break;
                int charsetIndex = meta.indexOf("charset=");
                if (charsetIndex <= -1) continue;
                return MailAttachmentUtilities.extractCharset((String)meta, (int)charsetIndex);
            }
        }
        return LEER_STRING;
    }

    private int checkMessageContent(String[] messageData, int textTyp, List<AttachedFile> allFiles) {
        Object message = messageData[0];
        if (textTyp == 1 && ((String)message).length() > this.critical_html_size) {
            message = this.convertDataImagesToAttachmentsIfExists((String)message, allFiles);
        }
        if (textTyp == 1 && ((String)message).length() < this.critical_html_size * 4) {
            message = HtmlConverter.getCompactHtmlText((String)message, null, this.ignoreMap);
        }
        Object messageToAdd = LEER_STRING;
        if (textTyp == 1 && ((String)message).length() > this.critical_html_size) {
            messageToAdd = "...\n" + this.emailsLangRess.getMsg("AttachmentSee", new Object[0]) + this.mailFileMethods.writeToFile("all", ".html", (String)message, allFiles, true);
            if (((String)(message = HtmlConverter.html2text((String)message))).length() > this.critical_plaintext_size * 5 / 4) {
                message = ((String)message).substring(0, this.critical_plaintext_size);
            }
            textTyp = 0;
        } else if (textTyp != 1) {
            Object boundary = MessagePartsChecker.testForBoundaries((String)(message = MessagePartsChecker.preparePartString((String)message)));
            if (boundary != null) {
                String header;
                String h;
                int i;
                ArrayList<String> stringParts = new ArrayList<String>();
                ArrayList<String> stringPartHeaders = new ArrayList<String>();
                MessagePartsChecker.splitMessage((String)message, (String)boundary, stringParts, stringPartHeaders);
                for (i = stringPartHeaders.size() - 1; i > -1; --i) {
                    h = stringPartHeaders.get(i);
                    header = h.toLowerCase();
                    if (header.indexOf("content-type: multipart/related;") <= -1) continue;
                    int bound = header.indexOf("boundary=\"");
                    int boundEnd = header.indexOf(34, bound + 11);
                    if (bound <= -1 || boundEnd <= -1) continue;
                    boundary = "--" + h.substring(bound + 10, header.indexOf(34, boundEnd));
                    String multi = stringParts.get(i);
                    stringParts.remove(i);
                    stringPartHeaders.remove(i);
                    MessagePartsChecker.splitMessage(multi, (String)boundary, stringParts, stringPartHeaders);
                }
                for (i = stringPartHeaders.size() - 1; i > -1; --i) {
                    String ext;
                    String fn;
                    h = stringPartHeaders.get(i);
                    header = h.toLowerCase();
                    int filnamePos = header.indexOf("filename=\"");
                    if (filnamePos <= -1) continue;
                    String name = h.substring(filnamePos + 10, header.indexOf(34, filnamePos + 12));
                    int dot = name.indexOf(46);
                    if (dot > -1) {
                        fn = name.substring(0, dot);
                        ext = name.substring(dot);
                    } else {
                        fn = name.length() > 0 ? name : "Content";
                        ext = ".txt";
                    }
                    String encoding = null;
                    int index = header.indexOf("content-transfer-encoding:");
                    if (index > -1) {
                        int end = header.indexOf("\r\n", index + 27);
                        encoding = header.substring(index + 27, end > -1 ? end : header.length());
                    }
                    AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName((String)fn, (String)ext, allFiles));
                    anlage.setFile(this.mailFileMethods.getFile(anlage.getFileName()));
                    this.mailFileMethods.writeToFile(anlage.getFile(), stringParts.get(i), encoding);
                    allFiles.add(anlage);
                    stringParts.remove(i);
                    stringPartHeaders.remove(i);
                }
                message = stringParts.get(0).replaceAll("=\r\n", LEER_STRING);
                message = ((String)message).replaceAll("=3D", "=");
                if (((String)(message = ((String)message).replaceAll("=5F", "_"))).startsWith("<html>")) {
                    textTyp = 1;
                } else {
                    message = this.removeAttachmentsFromMailbody((String)message, textTyp, allFiles);
                }
            }
            if (((String)message).length() > this.critical_plaintext_size * 5 / 4) {
                messageToAdd = "...\n" + this.emailsLangRess.getMsg("AttachmentSee", new Object[0]) + this.mailFileMethods.writeToFile("all", ".txt", (String)message, allFiles, true);
                message = ((String)message).substring(0, this.critical_plaintext_size);
            }
        }
        if (((String)messageToAdd).length() > 0) {
            message = (String)message + (String)messageToAdd;
        }
        messageData[0] = message;
        return textTyp;
    }

    private String convertDataImagesToAttachmentsIfExists(String message, List<AttachedFile> allFiles) {
        Pattern p = Pattern.compile("(<\\s*?img[^>]*?\\ssrc\\s*?=)((\\s*?\"[^\"]*?\")|((?!/>)[^\\s>])+)([^>]*?>)", 2);
        Matcher m = p.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String originalFileName = m.group(2);
            if (originalFileName.startsWith("\"") && originalFileName.endsWith("\"")) {
                originalFileName = originalFileName.substring(1, originalFileName.length() - 1);
            }
            Object replacementText = originalFileName;
            if (originalFileName.startsWith("data:image/")) {
                try {
                    byte[] data = originalFileName.contains(";base64,") ? Base64.getDecoder().decode(originalFileName.substring(originalFileName.indexOf(";base64,") + 8).trim()) : originalFileName.substring(originalFileName.indexOf(44)).getBytes(StandardCharsets.UTF_8);
                    int index = originalFileName.indexOf(59);
                    if (index == -1) {
                        index = originalFileName.indexOf(44);
                    }
                    String extension = originalFileName.substring(originalFileName.indexOf(47) + 1, index);
                    this.mailFileMethods.writeToFile("image", "." + extension, new String(data), allFiles, true);
                    String cid = GUID.generateNew().toString();
                    allFiles.get(allFiles.size() - 1).setContentID(new String[]{cid});
                    replacementText = "cid:" + cid;
                }
                catch (Throwable th) {
                    HDLogger.error(th);
                }
            }
            replacementText = m.group(1) + "\"" + (String)replacementText + "\"" + m.group(5);
            replacementText = ((String)replacementText).replace("\\", "\\\\");
            replacementText = ((String)replacementText).replace("$", "\\$");
            m.appendReplacement(sb, (String)replacementText);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String preparePartString(String in) {
        if (in != null && in.length() > 0 && (in.charAt(0) < '!' || in.charAt(in.length() - 1) < '!')) {
            int lastSign;
            int firstSign;
            for (firstSign = 0; firstSign < in.length() && in.charAt(firstSign) <= ' '; ++firstSign) {
            }
            for (lastSign = in.length() - 1; lastSign > -1 && in.charAt(lastSign) <= ' '; --lastSign) {
            }
            if (firstSign > lastSign) {
                return LEER_STRING;
            }
            return in.substring(firstSign, lastSign + 1);
        }
        return in;
    }

    private static String testForBoundaries(String in) {
        String firstLine;
        if (in != null && in.indexOf("\r\n") > 30 && in.startsWith("--") && in.endsWith("--") && in.endsWith((firstLine = in.substring(0, in.indexOf("\r\n"))) + "--") && firstLine.indexOf("=") > -1) {
            return firstLine;
        }
        return null;
    }

    private static void splitMessage(String in, String boundary, ArrayList<String> parts, ArrayList<String> headers) {
        int end;
        int start = boundary.length() + 1;
        while ((end = in.indexOf(boundary, start)) > -1) {
            while (in.charAt(start) < '!') {
                ++start;
            }
            int stringEnd = end;
            while (in.charAt(stringEnd - 1) < '!') {
                --stringEnd;
            }
            MessagePartsChecker.splitHeaders(in, start, stringEnd, parts, headers);
            start = end + boundary.length() + 1;
        }
    }

    private static void splitHeaders(String in, int start, int ende, ArrayList<String> parts, ArrayList<String> headers) {
        int posLeerZeile = in.indexOf("\r\n\r\n", start);
        headers.add(in.substring(start, posLeerZeile));
        posLeerZeile += 4;
        while (in.charAt(posLeerZeile) < '!') {
            ++posLeerZeile;
        }
        parts.add(in.substring(posLeerZeile, ende));
    }

    private static byte[] decode(byte[] src) {
        int kor = src.length % 63 == 0 ? src.length / 63 * 45 : src.length / 63 * 45 + (((src[src.length / 63 * 63] & 0x40) >> 1) + (src[src.length / 63 * 63] & 0x1F));
        byte[] dest = new byte[kor];
        int i = 0;
        int j = 1;
        while (j + 3 < src.length) {
            dest[i] = (byte)(((~src[j] & 0x20) << 2) + ((src[j] & 0x1F) << 2) + ((~src[j + 1] & 0x20) >> 4) + ((src[j + 1] & 0x10) >> 4));
            if (i + 1 < dest.length) {
                dest[i + 1] = (byte)(((src[j + 1] & 0xF) << 4) + ((~src[j + 2] & 0x20) >> 2) + ((src[j + 2] & 0x1C) >> 2));
            }
            if (i + 2 < dest.length) {
                dest[i + 2] = (byte)(((src[j + 2] & 3) << 6) + (~src[j + 3] & 0x20) + (src[j + 3] & 0x1F));
            }
            i += 3;
            if (((j += 4) + 2) % 63 != 0) continue;
            j += 3;
        }
        return dest;
    }

    public class CheckPartsResult {
        private String possibleId;
        private int mailType;
        private String acknowledge;
        private boolean errorInAttachment;

        CheckPartsResult(String possibleId, int mailType, String acknowledge, boolean errorInAttachment) {
            this.possibleId = possibleId;
            this.mailType = mailType;
            this.acknowledge = acknowledge;
            this.errorInAttachment = errorInAttachment;
        }

        public String getPossibleId() {
            return this.possibleId;
        }

        public int getMailType() {
            return this.mailType;
        }

        public String getAcknowledge() {
            return this.acknowledge;
        }

        public boolean isErrorInAttachment() {
            return this.errorInAttachment;
        }
    }
}

