/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketCreateRequestData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
@InternalApi
public class HelpDeskTicketCreateHandler
extends RequestHandler<HelpDeskTicketCreateRequestData, Integer> {
    public static final String CREATE_REQUEST_HANDLER_NAME = "create";

    public HelpDeskTicketCreateHandler() {
        super(new String[]{CREATE_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.create";
    }

    @Operation(summary="Create a new ticket", description="Creates a new ticket in the HelpDesk system with the provided details, attachments, and owner information", responses={@ApiResponse(responseCode="200", description="Ticket created successfully", content={@Content(schema=@Schema(description="The ID of the created ticket", type="integer", format="int32"))}), @ApiResponse(responseCode="400", description="Invalid request data or missing required fields"), @ApiResponse(responseCode="401", description="User not authorized to create tickets"), @ApiResponse(responseCode="403", description="Non-supporter user attempting to set owner GUID")})
    public Integer handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable HelpDeskTicketCreateRequestData requestData, boolean previewModeEnabled) throws IOException {
        if (requestData == null) {
            throw new ClientMessageException(WebAPIExtension.getI18nMessages().getMsg("webapi.jsonEmptyError", new Object[0]));
        }
        MutableTicketData mutableTicketData = HelpDeskWebAPIHelper.createMutableTicketData(requestData.getTicketFields(), null);
        ExtensionArguments actionArguments = HelpDeskWebAPIHelper.createActionArguments(requestData.getActionArguments());
        HelpDeskWebAPIHelper.addAttachmentsToActionArguments(actionArguments, request, requestData.getAttachments());
        String emailEingang = null;
        ReaStepTextVO ticketText = ReaStepTextVO.of(requestData.getText(), requestData.isHtmlContent());
        GUID ownerGUID = requestData.getOwnerGUID();
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        if (ownerGUID == null && currentUserAccount != null && !currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
            ownerGUID = currentUserAccount.getID();
        } else if (!(ownerGUID == null || currentUserAccount != null && HDUsersAndGroups.isSupporter(currentUserAccount))) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.ownerGUIDMustNotBeGiven", new Object[0]));
        }
        if (previewModeEnabled) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.previewModeEnabledWhileTicketCreate", new Object[0]));
        }
        mutableTicketData.put(Tickets.FIELD_OWNER_GUID, ownerGUID);
        TicketVO ticketVO = TicketManager.getManipulator().createTicket(ticketText, mutableTicketData, emailEingang, actionArguments);
        if (ticketVO == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.errorWhileCreatingTicket", new Object[0]));
        }
        Integer ticketID = ticketVO.getID();
        boolean requiresTicketIdEncoded = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId();
        ResponseWriter.json((HttpServletResponse)response, (Object)(requiresTicketIdEncoded ? Tickets.encodeTicketId(ticketID) : ticketID));
        return ticketID;
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

